/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.controller;

import com.apktoolscnm.apktoolcnm.model.LoginRequest;
import com.apktoolscnm.apktoolcnm.model.LoginResponse;
import com.apktoolscnm.apktoolcnm.service.AuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    @Autowired
    private AuthService authService;

    @PostMapping(value={"/login"})
    public ResponseEntity<LoginResponse> login(@RequestBody LoginRequest request) {
        LoginResponse response = this.authService.authenticate(request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/logout"})
    public ResponseEntity<Map<String, String>> logout(HttpServletRequest request) {
        String token = this.extractToken(request);
        if (token != null) {
            this.authService.logout(token);
        }
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("message", "\u767b\u51fa\u6210\u529f");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/validate"})
    public ResponseEntity<Map<String, Object>> validateToken(HttpServletRequest request) {
        String token = this.extractToken(request);
        boolean isValid = this.authService.validateToken(token);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("valid", isValid);
        response.put("message", isValid ? "Token\u6709\u6548" : "Token\u65e0\u6548\u6216\u5df2\u8fc7\u671f");
        return ResponseEntity.ok(response);
    }

    private String extractToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            return authHeader.substring(7);
        }
        return null;
    }
}

