/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.controller;

import com.apktoolscnm.apktoolcnm.controller.FileUploadController;
import com.apktoolscnm.apktoolcnm.model.TaskStatus;
import com.apktoolscnm.apktoolcnm.service.ApkProcessingService;
import com.apktoolscnm.apktoolcnm.service.TaskTrackingService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/apk"})
public class FileUploadController {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);
    @Autowired
    private TaskTrackingService taskTrackingService;
    @Autowired
    private ApkProcessingService apkService;

    @PostMapping(value={"/upload"})
    public ResponseEntity<UploadResponse> handleFileUpload(@RequestParam(value="file") MultipartFile file, @RequestParam String newAppName, @RequestParam(value="newIcon", required=false) MultipartFile newIcon, @RequestParam String newIp, @RequestParam String newPort, @RequestParam String newWebUrl, @RequestParam(value="replaceRules", required=false) String replaceRulesJson) {
        try {
            List replaceRules = null;
            if (replaceRulesJson != null && !replaceRulesJson.isEmpty()) {
                ObjectMapper mapper = new ObjectMapper();
                replaceRules = (List)mapper.readValue(replaceRulesJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (file.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1a\u6587\u4ef6\u4e3a\u7a7a"));
            }
            if (!file.getOriginalFilename().toLowerCase().endsWith(".apk")) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1a\u53ea\u652f\u6301APK\u6587\u4ef6"));
            }
            if (newAppName == null || newAppName.trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1a\u5e94\u7528\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (newIp == null || newIp.trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1aIP\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (newPort == null || newPort.trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1a\u7aef\u53e3\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (newWebUrl == null || newWebUrl.trim().isEmpty()) {
                return ResponseEntity.badRequest().body((Object)new UploadResponse("\u9519\u8bef\uff1a\u7f51\u7ad9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (newIcon != null && !newIcon.isEmpty()) {
                logger.info("\u68c0\u6d4b\u5230\u56fe\u6807\u6587\u4ef6: {}, \u5927\u5c0f: {} bytes", (Object)newIcon.getOriginalFilename(), (Object)newIcon.getSize());
            } else {
                logger.info("\u672a\u68c0\u6d4b\u5230\u56fe\u6807\u6587\u4ef6");
            }
            String taskId = UUID.randomUUID().toString();
            logger.info("\u5f00\u59cb\u5904\u7406APK\u4e0a\u4f20\u4efb\u52a1: {}", (Object)taskId);
            this.taskTrackingService.updateStatus(taskId, TaskStatus.PENDING);
            this.apkService.processApkAsync(taskId, file, newAppName, newIcon, newIp, newPort, newWebUrl, replaceRules);
            logger.info("APK\u4e0a\u4f20\u4efb\u52a1\u5df2\u63d0\u4ea4: {}", (Object)taskId);
            return ResponseEntity.accepted().body((Object)new UploadResponse(taskId));
        }
        catch (Exception e) {
            logger.error("\u5904\u7406APK\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return ResponseEntity.internalServerError().body((Object)new UploadResponse("\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/download/{taskId}"})
    public ResponseEntity<Resource> downloadApk(@PathVariable String taskId) {
        try {
            logger.info("\u4e0b\u8f7dAPK\u6587\u4ef6: {}", (Object)taskId);
            TaskStatus status = this.apkService.getTaskStatus(taskId);
            if (status != TaskStatus.COMPLETED) {
                return ResponseEntity.status((int)202).build();
            }
            Resource file = this.apkService.getProcessedApk(taskId);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"modified.apk\""})).body((Object)file);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7dAPK\u6587\u4ef6\u5931\u8d25: {}", (Object)taskId, (Object)e);
            return ResponseEntity.notFound().build();
        }
    }

    @GetMapping(value={"/status/{taskId}"})
    public ResponseEntity<Map<String, Object>> getTaskStatus(@PathVariable String taskId) {
        try {
            TaskStatus status = this.taskTrackingService.getStatus(taskId);
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("taskId", taskId);
            response.put("status", status.name());
            response.put("message", this.getStatusMessage(status));
            logger.debug("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001: {} -> {}", (Object)taskId, (Object)status);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u5931\u8d25: {}", (Object)taskId, (Object)e);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("taskId", taskId);
            response.put("status", "ERROR");
            response.put("message", "\u67e5\u8be2\u72b6\u6001\u5931\u8d25: " + e.getMessage());
            return ResponseEntity.ok(response);
        }
    }

    private String getStatusMessage(TaskStatus status) {
        switch (2.$SwitchMap$com$apktoolscnm$apktoolcnm$model$TaskStatus[status.ordinal()]) {
            case 1: {
                return "\u4efb\u52a1\u7b49\u5f85\u4e2d";
            }
            case 2: {
                return "\u6b63\u5728\u5904\u7406APK";
            }
            case 3: {
                return "\u5904\u7406\u5b8c\u6210\uff0c\u53ef\u4ee5\u4e0b\u8f7d";
            }
            case 4: {
                return "\u5904\u7406\u5931\u8d25";
            }
        }
        return "\u672a\u77e5\u72b6\u6001";
    }
}

