/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.controller;

import com.apktoolscnm.apktoolcnm.util.DebugKeyGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/health"})
public class HealthController {
    private static final Logger logger = LoggerFactory.getLogger(HealthController.class);
    @Autowired
    private DebugKeyGenerator debugKeyGenerator;

    @GetMapping
    public Map<String, Object> healthCheck() {
        HashMap<String, Object> health = new HashMap<String, Object>();
        try {
            File keystoreFile = new File(this.debugKeyGenerator.getKeystorePath());
            boolean keystoreExists = keystoreFile.exists();
            File tempDir = new File("./apk_temp");
            boolean tempDirExists = tempDir.exists();
            boolean apktoolAvailable = this.checkCommand("apktool");
            boolean jarsignerAvailable = this.checkCommand("jarsigner");
            health.put("status", "UP");
            health.put("keystore", keystoreExists ? "OK" : "MISSING");
            health.put("tempDir", tempDirExists ? "OK" : "MISSING");
            health.put("apktool", apktoolAvailable ? "OK" : "NOT_AVAILABLE");
            health.put("jarsigner", jarsignerAvailable ? "OK" : "NOT_AVAILABLE");
            logger.info("\u5065\u5eb7\u68c0\u67e5\u5b8c\u6210: {}", health);
        }
        catch (Exception e) {
            logger.error("\u5065\u5eb7\u68c0\u67e5\u5931\u8d25", (Throwable)e);
            health.put("status", "DOWN");
            health.put("error", e.getMessage());
        }
        return health;
    }

    private boolean checkCommand(String command) {
        try {
            ProcessBuilder pb = command.equals("apktool") ? new ProcessBuilder(command) : new ProcessBuilder(command, "--version");
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            boolean finished = process.waitFor(5L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                return false;
            }
            int exitCode = process.exitValue();
            if (command.equals("apktool")) {
                return output.toString().contains("Apktool");
            }
            return exitCode == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

