/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.service;

import com.apktoolscnm.apktoolcnm.controller.FileUploadController;
import com.apktoolscnm.apktoolcnm.model.TaskStatus;
import com.apktoolscnm.apktoolcnm.service.TaskTrackingService;
import com.apktoolscnm.apktoolcnm.util.ApkToolUtil;
import com.apktoolscnm.apktoolcnm.util.ImageConverter;
import com.apktoolscnm.apktoolcnm.util.PngValidator;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApkProcessingService {
    private static final Logger logger = LoggerFactory.getLogger(ApkProcessingService.class);
    private final Map<String, File> processedFiles = new ConcurrentHashMap();
    @Value(value="${temp.dir:./apk_temp}")
    private String tempDir;
    @Autowired
    private ApkToolUtil apkToolUtil;
    @Autowired
    private TaskTrackingService taskTrackingService;

    @PostConstruct
    public void init() {
        File tempDirFile = new File(this.tempDir);
        if (!tempDirFile.exists()) {
            tempDirFile.mkdirs();
        }
        logger.info("\u4e34\u65f6\u76ee\u5f55\u521d\u59cb\u5316\u5b8c\u6210: {}", (Object)tempDirFile.getAbsolutePath());
    }

    @Async
    public void processApkAsync(String taskId, MultipartFile apkFile, String newAppName, MultipartFile newIcon, String newIp, String newPort, String newWebUrl, List<FileUploadController.ReplaceRule> replaceRules) {
        try {
            logger.info("\u5f00\u59cb\u5904\u7406APK\u4efb\u52a1: {}", (Object)taskId);
            if (newIcon == null || newIcon.isEmpty()) {
                logger.info("\u670d\u52a1\u5c42\u672a\u63a5\u6536\u5230\u56fe\u6807\u6587\u4ef6");
            }
            this.taskTrackingService.updateStatus(taskId, TaskStatus.PROCESSING);
            File taskDir = new File(this.tempDir, taskId);
            if (!taskDir.exists() && !taskDir.mkdirs()) {
                throw new IOException("\u65e0\u6cd5\u521b\u5efa\u4efb\u52a1\u76ee\u5f55: " + taskDir.getAbsolutePath());
            }
            File originalApk = new File(taskDir.getAbsolutePath(), "original.apk");
            apkFile.transferTo(originalApk);
            logger.info("APK\u6587\u4ef6\u5df2\u4fdd\u5b58: {}", (Object)originalApk.getAbsolutePath());
            File iconFile = null;
            if (newIcon != null && !newIcon.isEmpty()) {
                File originalIconFile = new File(taskDir.getAbsolutePath(), "original_icon." + this.getFileExtension(newIcon.getOriginalFilename()));
                newIcon.transferTo(originalIconFile);
                logger.info("\u539f\u59cb\u56fe\u6807\u6587\u4ef6\u5df2\u4fdd\u5b58: {} (\u5927\u5c0f: {} bytes)", (Object)originalIconFile.getAbsolutePath(), (Object)originalIconFile.length());
                if (PngValidator.isValidPng((File)originalIconFile)) {
                    logger.info("\u539f\u59cb\u6587\u4ef6\u662f\u6709\u6548\u7684PNG\u683c\u5f0f\uff0c\u76f4\u63a5\u4f7f\u7528");
                    iconFile = originalIconFile;
                } else {
                    logger.info("\u539f\u59cb\u6587\u4ef6\u4e0d\u662fPNG\u683c\u5f0f\uff0c\u5c1d\u8bd5\u8f6c\u6362\u4e3aPNG");
                    if (ImageConverter.isSupportedImageFormat((File)originalIconFile)) {
                        File convertedIconFile = new File(taskDir.getAbsolutePath(), "converted_icon.png");
                        if (ImageConverter.convertToPng((File)originalIconFile, (File)convertedIconFile)) {
                            logger.info("\u56fe\u7247\u8f6c\u6362\u6210\u529f\uff0c\u4f7f\u7528\u8f6c\u6362\u540e\u7684PNG\u6587\u4ef6");
                            iconFile = convertedIconFile;
                        } else {
                            logger.error("\u56fe\u7247\u8f6c\u6362\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6");
                            iconFile = originalIconFile;
                        }
                    } else {
                        logger.warn("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6");
                        iconFile = originalIconFile;
                    }
                }
            }
            File modifiedApk = this.processApk(originalApk, newAppName, newIp, newPort, newWebUrl, iconFile, taskDir, replaceRules);
            this.processedFiles.put(taskId, modifiedApk);
            this.taskTrackingService.updateStatus(taskId, TaskStatus.COMPLETED);
            logger.info("APK\u5904\u7406\u5b8c\u6210: {}", (Object)taskId);
        }
        catch (Exception e) {
            logger.error("APK\u5904\u7406\u5931\u8d25: {}", (Object)taskId, (Object)e);
            this.taskTrackingService.updateStatus(taskId, TaskStatus.FAILED);
            throw new RuntimeException("APK\u5904\u7406\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private File processApk(File originalApk, String newAppName, String newIp, String newPort, String newWebUrl, File newIcon, File taskDir, List<FileUploadController.ReplaceRule> replaceRules) throws Exception {
        logger.info("\u5f00\u59cb\u53cd\u7f16\u8bd1APK: {}", (Object)originalApk.getName());
        File decompiledDir = new File(this.tempDir, "decompiled_" + System.currentTimeMillis());
        try {
            this.apkToolUtil.decompileApk(originalApk, decompiledDir);
            logger.info("APK\u53cd\u7f16\u8bd1\u5b8c\u6210");
            if (newAppName != null && !newAppName.trim().isEmpty()) {
                this.apkToolUtil.modifyAppName(decompiledDir, newAppName);
                logger.info("\u5e94\u7528\u540d\u5df2\u4fee\u6539\u4e3a: {}", (Object)newAppName);
            }
            logger.info("processApk\u65b9\u6cd5\u4e2d\u68c0\u67e5\u56fe\u6807\u6587\u4ef6: newIcon={}", (Object)(newIcon != null ? newIcon.getAbsolutePath() : "null"));
            if (newIcon != null && newIcon.exists()) {
                logger.info("\u5f00\u59cb\u5904\u7406\u56fe\u6807\u66ff\u6362\uff0c\u56fe\u6807\u6587\u4ef6: {}, \u5927\u5c0f: {} bytes", (Object)newIcon.getName(), (Object)newIcon.length());
                this.apkToolUtil.testIconReplacement(decompiledDir);
                this.apkToolUtil.replaceIcon(decompiledDir, newIcon);
                logger.info("\u5e94\u7528\u56fe\u6807\u5df2\u66ff\u6362");
            } else {
                logger.info("\u6ca1\u6709\u4e0a\u4f20\u56fe\u6807\u6587\u4ef6");
            }
            this.applyCustomReplacements(decompiledDir, newAppName, newIp, newPort, newWebUrl, replaceRules);
            logger.info("\u81ea\u5b9a\u4e49\u66ff\u6362\u89c4\u5219\u5df2\u5e94\u7528");
            File unsignedApk = new File(this.tempDir, "unsigned_" + originalApk.getName());
            this.apkToolUtil.buildApk(decompiledDir, unsignedApk);
            logger.info("APK\u6253\u5305\u5b8c\u6210");
            this.cleanupTempFiles(decompiledDir, null);
            return unsignedApk;
        }
        catch (Exception e) {
            this.cleanupTempFiles(decompiledDir, null);
            throw e;
        }
    }

    private void cleanupTempFiles(File decompiledDir, File unsignedApk) {
        try {
            if (decompiledDir != null && decompiledDir.exists()) {
                FileUtils.deleteDirectory((File)decompiledDir);
            }
            if (unsignedApk != null && unsignedApk.exists()) {
                unsignedApk.delete();
            }
        }
        catch (Exception e) {
            logger.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public Resource getProcessedApk(String taskId) {
        TaskStatus status = this.taskTrackingService.getStatus(taskId);
        if (status != TaskStatus.COMPLETED) {
            throw new RuntimeException("\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e: " + String.valueOf(status) + "\uff0c\u4efb\u52a1ID: " + taskId);
        }
        File file = (File)this.processedFiles.get(taskId);
        if (file == null || !file.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5c1a\u672a\u5904\u7406\u5b8c\u6210\uff0c\u4efb\u52a1ID: " + taskId);
        }
        return new FileSystemResource(file);
    }

    public TaskStatus getTaskStatus(String taskId) {
        return this.taskTrackingService.getStatus(taskId);
    }

    private String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "bin";
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "bin";
    }

    private void applyCustomReplacements(File decompiledDir, String newAppName, String newIp, String newPort, String newWebUrl, List<FileUploadController.ReplaceRule> replaceRules) {
        try {
            logger.info("\u5f00\u59cb\u5e94\u7528\u81ea\u5b9a\u4e49\u66ff\u6362\u89c4\u5219: AppName={}, IP={}, Port={}, WebUrl={}", new Object[]{newAppName, newIp, newPort, newWebUrl});
            if (newAppName != null && !newAppName.trim().isEmpty()) {
                this.applyAppNameReplacement(decompiledDir, newAppName);
            }
            if (newIp != null && !newIp.trim().isEmpty()) {
                this.applyIpReplacement(decompiledDir, newIp);
            }
            if (newPort != null && !newPort.trim().isEmpty()) {
                this.applyPortReplacement(decompiledDir, newPort);
            }
            if (newWebUrl != null && !newWebUrl.trim().isEmpty()) {
                this.applyWebUrlReplacement(decompiledDir, newWebUrl);
            }
            logger.info("\u81ea\u5b9a\u4e49\u66ff\u6362\u89c4\u5219\u5e94\u7528\u5b8c\u6210");
            if (replaceRules != null && !replaceRules.isEmpty()) {
                for (FileUploadController.ReplaceRule rule : replaceRules) {
                    if (rule.scope == null || rule.source == null || rule.target == null || rule.scope.isEmpty() || rule.source.isEmpty()) continue;
                    Pattern pattern = null;
                    if ("smali".equalsIgnoreCase(rule.scope)) {
                        pattern = Pattern.compile(".*\\.smali$");
                    } else if ("xml".equalsIgnoreCase(rule.scope)) {
                        pattern = Pattern.compile(".*\\.xml$");
                    }
                    if (pattern == null) continue;
                    this.applyReplacementToFiles(decompiledDir, pattern, rule.source, rule.target, "\u591a\u7ec4\u9ad8\u7ea7\u5168\u5c40\u66ff\u6362");
                    logger.info("\u5df2\u5e94\u7528\u9ad8\u7ea7\u5168\u5c40\u66ff\u6362: scope={}, source={}, target={}", new Object[]{rule.scope, rule.source, rule.target});
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5e94\u7528\u81ea\u5b9a\u4e49\u66ff\u6362\u89c4\u5219\u5931\u8d25", (Throwable)e);
        }
    }

    private void applyAppNameReplacement(File decompiledDir, String newAppName) {
        try {
            Pattern xmlPattern = Pattern.compile(".*\\.xml$");
            this.applyReplacementToFiles(decompiledDir, xmlPattern, "\u8c46\u5305", newAppName, "app\u63cf\u8ff0\u66ff\u6362");
        }
        catch (Exception e) {
            logger.error("App\u63cf\u8ff0\u66ff\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    private void applyIpReplacement(File decompiledDir, String newIp) {
        try {
            Pattern smaliPattern = Pattern.compile(".*\\.smali$");
            this.applyReplacementToFiles(decompiledDir, smaliPattern, "154.91.227.180", newIp, "IP\u5730\u5740\u66ff\u6362");
        }
        catch (Exception e) {
            logger.error("IP\u5730\u5740\u66ff\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    private void applyPortReplacement(File decompiledDir, String newPort) {
        try {
            Pattern smaliPattern = Pattern.compile(".*\\.smali$");
            this.applyReplacementToFiles(decompiledDir, smaliPattern, ", \"5000\"", ", \"" + newPort + "\"", "\u7aef\u53e3\u53f7\u66ff\u6362");
        }
        catch (Exception e) {
            logger.error("\u7aef\u53e3\u53f7\u66ff\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    private void applyWebUrlReplacement(File decompiledDir, String newWebUrl) {
        try {
            Pattern smaliPattern = Pattern.compile(".*\\.smali$");
            this.applyReplacementToFiles(decompiledDir, smaliPattern, "https://www.doubao.com/chat/", newWebUrl, "WEB\u57df\u540d\u66ff\u6362");
        }
        catch (Exception e) {
            logger.error("WEB\u57df\u540d\u66ff\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    private void applyReplacementToFiles(File rootDir, Pattern filePattern, String target, String replacement, String description) {
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            return;
        }
        try {
            Files.walk(rootDir.toPath(), new FileVisitOption[0]).filter(path -> filePattern.matcher(path.getFileName().toString()).matches()).forEach(path -> {
                try {
                    File file = path.toFile();
                    if (file.isFile()) {
                        this.applyReplacementToFile(file, target, replacement, description);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u6587\u4ef6\u5931\u8d25: {}", path, (Object)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("\u904d\u5386\u6587\u4ef6\u5931\u8d25: {}", (Object)rootDir.getAbsolutePath(), (Object)e);
        }
    }

    private void applyReplacementToFile(File file, String target, String replacement, String description) {
        try {
            String content;
            String originalContent = content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            content = content.replace(target, replacement);
            if (!content.equals(originalContent)) {
                Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                logger.debug("{} \u6210\u529f: {} -> {}, \u6587\u4ef6: {}", new Object[]{description, target, replacement, file.getAbsolutePath()});
            }
        }
        catch (Exception e) {
            logger.error("{} \u5931\u8d25: \u6587\u4ef6={}", new Object[]{description, file.getAbsolutePath(), e});
        }
    }
}

