/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.util;

import com.apktoolscnm.apktoolcnm.util.DebugKeyGenerator;
import com.apktoolscnm.apktoolcnm.util.ImageConverter;
import com.apktoolscnm.apktoolcnm.util.PngValidator;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ApkToolUtil {
    private static final Logger logger = LoggerFactory.getLogger(ApkToolUtil.class);
    @Value(value="${apktool.path:apktool}")
    private String apktoolPath;
    @Value(value="${jarsigner.path:jarsigner}")
    private String jarsignerPath;
    @Autowired
    private DebugKeyGenerator debugKeyGenerator;

    @PostConstruct
    public void init() {
        logger.info("\u521d\u59cb\u5316ApkToolUtil...");
        try {
            this.validateCommand(this.apktoolPath, "apktool");
            this.validateCommand(this.jarsignerPath, "jarsigner");
            logger.info("ApkToolUtil\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("ApkToolUtil\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private void validateCommand(String command, String name) {
        try {
            logger.info("\u9a8c\u8bc1 {} \u547d\u4ee4: {}", (Object)name, (Object)command);
            ProcessBuilder pb = name.equals("apktool") ? new ProcessBuilder(command) : new ProcessBuilder(command, "--version");
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                logger.warn("{} \u547d\u4ee4\u9a8c\u8bc1\u8d85\u65f6", (Object)name);
                return;
            }
            int exitCode = process.waitFor();
            if (name.equals("apktool")) {
                if (output.toString().contains("Apktool")) {
                    logger.info("{} \u547d\u4ee4\u9a8c\u8bc1\u6210\u529f", (Object)name);
                } else {
                    logger.warn("{} \u547d\u4ee4\u9a8c\u8bc1\u5931\u8d25\uff0c\u4f46\u53ef\u80fd\u4ecd\u7136\u53ef\u7528", (Object)name);
                }
            } else if (exitCode == 0) {
                logger.info("{} \u547d\u4ee4\u9a8c\u8bc1\u6210\u529f", (Object)name);
            } else {
                logger.warn("{} \u547d\u4ee4\u9a8c\u8bc1\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}", (Object)name, (Object)exitCode);
            }
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1 {} \u547d\u4ee4\u5931\u8d25: {}", (Object)name, (Object)e.getMessage());
        }
    }

    public void decompileApk(File apkFile, File outputDir) throws IOException {
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new IOException("\u65e0\u6cd5\u521b\u5efa\u8f93\u51fa\u76ee\u5f55: " + outputDir.getAbsolutePath());
        }
        CharSequence[] command = new String[]{this.apktoolPath, "d", apkFile.getAbsolutePath(), "-o", outputDir.getAbsolutePath(), "-f"};
        try {
            this.executeCommand((String[])command, 300000L);
            logger.info("APK\u53cd\u7f16\u8bd1\u5b8c\u6210: {}", (Object)apkFile.getName());
        }
        catch (IOException e) {
            logger.warn("\u53cd\u7f16\u8bd1\u5931\u8d25: {}", (Object)e.getMessage());
            throw new IOException("\u53cd\u7f16\u8bd1\u5931\u8d25: " + apkFile.getName() + "\n\u547d\u4ee4: " + String.join((CharSequence)" ", command) + "\n\u539f\u56e0: " + e.getMessage(), e);
        }
    }

    public void modifyAppName(File decompiledDir, String newAppName) throws IOException {
        File stringsXml = new File(decompiledDir, "res/values/strings.xml");
        if (!stringsXml.exists()) {
            logger.warn("strings.xml\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u5e94\u7528\u540d\u4fee\u6539");
            return;
        }
        String content = FileUtils.readFileToString((File)stringsXml, (Charset)StandardCharsets.UTF_8);
        content = content.replaceAll("<string name=\"app_name\">.*?</string>", "<string name=\"app_name\">" + newAppName + "</string>");
        FileUtils.write((File)stringsXml, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        logger.info("\u5e94\u7528\u540d\u5df2\u4fee\u6539\u4e3a: {}", (Object)newAppName);
    }

    public void replaceIcon(File decompiledDir, File newIcon) throws IOException {
        File resDir = new File(decompiledDir, "res");
        if (!resDir.exists()) {
            logger.warn("res\u76ee\u5f55\u4e0d\u5b58\u5728: {}", (Object)resDir.getAbsolutePath());
            return;
        }
        List iconDirectories = this.findIconDirectories(resDir);
        if (iconDirectories.isEmpty()) {
            logger.warn("\u672a\u627e\u5230\u4efb\u4f55\u56fe\u6807\u76ee\u5f55\uff0c\u521b\u5efa\u9ed8\u8ba4\u76ee\u5f55");
            File defaultIconDir = new File(resDir, "mipmap-hdpi");
            if (!defaultIconDir.exists()) {
                defaultIconDir.mkdirs();
            }
            iconDirectories.add(defaultIconDir);
        }
        int replacedCount = 0;
        for (File iconDir : iconDirectories) {
            try {
                File[] existingIcons = iconDir.listFiles((dir, name) -> name.toLowerCase().contains("launcher") && name.toLowerCase().endsWith(".png"));
                if (existingIcons != null) {
                    for (File icon : existingIcons) {
                        icon.delete();
                        logger.debug("\u5220\u9664\u73b0\u6709\u56fe\u6807: {}", (Object)icon.getAbsolutePath());
                    }
                }
                File newIconFile = new File(iconDir, "ic_launcher.png");
                if (!newIcon.exists()) {
                    logger.error("\u6e90\u56fe\u6807\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)newIcon.getAbsolutePath());
                    continue;
                }
                if (newIcon.length() == 0L) {
                    logger.error("\u6e90\u56fe\u6807\u6587\u4ef6\u4e3a\u7a7a: {}", (Object)newIcon.getAbsolutePath());
                    continue;
                }
                if (PngValidator.isValidPng((File)newIcon)) {
                    logger.debug("\u6e90\u6587\u4ef6\u662f\u6709\u6548\u7684PNG\u683c\u5f0f");
                } else {
                    logger.warn("\u6e90\u6587\u4ef6\u4e0d\u662f\u6709\u6548\u7684PNG\u683c\u5f0f\uff0c\u6587\u4ef6\u5934: {}", (Object)PngValidator.getFileHeader((File)newIcon));
                    logger.warn("\u4f46\u4ecd\u5c1d\u8bd5\u590d\u5236\u6587\u4ef6");
                }
                int targetSize = this.getTargetIconSize(iconDir.getName());
                logger.debug("\u76ee\u6807\u56fe\u6807\u5c3a\u5bf8: {}x{} (\u76ee\u5f55: {})", new Object[]{targetSize, targetSize, iconDir.getName()});
                if (targetSize > 0) {
                    if (ImageConverter.convertToPngWithResize((File)newIcon, (File)newIconFile, (int)targetSize)) {
                        logger.info("\u56fe\u6807\u5df2\u8c03\u6574\u5c3a\u5bf8\u5e76\u8f6c\u6362: {}x{}", (Object)targetSize, (Object)targetSize);
                    } else {
                        logger.warn("\u56fe\u6807\u8c03\u6574\u5c3a\u5bf8\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6");
                        Files.copy(newIcon.toPath(), newIconFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    Files.copy(newIcon.toPath(), newIconFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                if (newIconFile.exists() && newIconFile.length() > 0L) {
                    logger.info("\u5e94\u7528\u56fe\u6807\u5df2\u66ff\u6362: {} (\u5927\u5c0f: {} bytes)", (Object)newIconFile.getAbsolutePath(), (Object)newIconFile.length());
                    ++replacedCount;
                    continue;
                }
                logger.error("\u56fe\u6807\u6587\u4ef6\u590d\u5236\u5931\u8d25: {}", (Object)newIconFile.getAbsolutePath());
            }
            catch (IOException e) {
                logger.error("\u66ff\u6362\u56fe\u6807\u5931\u8d25\uff0c\u76ee\u5f55: {}", (Object)iconDir.getAbsolutePath(), (Object)e);
            }
        }
        logger.info("\u603b\u5171\u66ff\u6362\u4e86 {} \u4e2a\u56fe\u6807\u6587\u4ef6", (Object)replacedCount);
    }

    private List<File> findIconDirectories(File resDir) {
        ArrayList<File> iconDirectories = new ArrayList<File>();
        if (!resDir.exists() || !resDir.isDirectory()) {
            return iconDirectories;
        }
        File[] subDirs = resDir.listFiles(File::isDirectory);
        if (subDirs != null) {
            for (File subDir : subDirs) {
                File[] iconFiles;
                if (subDir.getName().startsWith("mipmap") && (iconFiles = subDir.listFiles((dir, name) -> name.toLowerCase().contains("launcher") && name.toLowerCase().endsWith(".png"))) != null && iconFiles.length > 0) {
                    iconDirectories.add(subDir);
                    logger.debug("\u627e\u5230\u56fe\u6807\u76ee\u5f55: {}", (Object)subDir.getAbsolutePath());
                }
                iconDirectories.addAll(this.findIconDirectories(subDir));
            }
        }
        return iconDirectories;
    }

    private int getTargetIconSize(String dirName) {
        if (dirName == null) {
            return 0;
        }
        String lowerDirName = dirName.toLowerCase();
        if (lowerDirName.contains("mipmap-ldpi")) {
            return 36;
        }
        if (lowerDirName.contains("mipmap-mdpi")) {
            return 48;
        }
        if (lowerDirName.contains("mipmap-hdpi")) {
            return 72;
        }
        if (lowerDirName.contains("mipmap-xhdpi")) {
            return 96;
        }
        if (lowerDirName.contains("mipmap-xxhdpi")) {
            return 144;
        }
        if (lowerDirName.contains("mipmap-xxxhdpi")) {
            return 192;
        }
        if (lowerDirName.contains("drawable-ldpi")) {
            return 36;
        }
        if (lowerDirName.contains("drawable-mdpi")) {
            return 48;
        }
        if (lowerDirName.contains("drawable-hdpi")) {
            return 72;
        }
        if (lowerDirName.contains("drawable-xhdpi")) {
            return 96;
        }
        if (lowerDirName.contains("drawable-xxhdpi")) {
            return 144;
        }
        if (lowerDirName.contains("drawable-xxxhdpi")) {
            return 192;
        }
        return 0;
    }

    public void testIconReplacement(File decompiledDir) {
        logger.info("\u5f00\u59cb\u6d4b\u8bd5\u56fe\u6807\u66ff\u6362\u529f\u80fd...");
        File resDir = new File(decompiledDir, "res");
        if (!resDir.exists()) {
            logger.warn("res\u76ee\u5f55\u4e0d\u5b58\u5728: {}", (Object)resDir.getAbsolutePath());
            return;
        }
        List iconDirectories = this.findIconDirectories(resDir);
        logger.info("\u627e\u5230 {} \u4e2a\u56fe\u6807\u76ee\u5f55:", (Object)iconDirectories.size());
        for (File iconDir : iconDirectories) {
            logger.info("  - {}", (Object)iconDir.getAbsolutePath());
            File[] iconFiles = iconDir.listFiles((dir, name) -> name.toLowerCase().contains("launcher") && name.toLowerCase().endsWith(".png"));
            if (iconFiles == null) continue;
            for (File iconFile : iconFiles) {
                logger.info("    * {}", (Object)iconFile.getName());
            }
        }
        logger.info("\u56fe\u6807\u66ff\u6362\u529f\u80fd\u6d4b\u8bd5\u5b8c\u6210");
    }

    public void buildApk(File decompiledDir, File outputApk) throws IOException {
        String[] command = new String[]{this.apktoolPath, "b", decompiledDir.getAbsolutePath(), "-o", outputApk.getAbsolutePath()};
        try {
            this.executeCommand(command, 300000L);
        }
        catch (IOException e) {
            logger.warn("\u6253\u5305\u5931\u8d25: {}", (Object)e.getMessage());
            throw new IOException("\u6253\u5305\u5931\u8d25: " + decompiledDir.getName() + "\n\u539f\u56e0: " + e.getMessage(), e);
        }
    }

    public void signApk(File unsignedApk, File signedApk) throws IOException {
        this.debugKeyGenerator.ensureDebugKeyExists();
        String keystorePath = this.debugKeyGenerator.getKeystorePath();
        String[] command = new String[]{this.jarsignerPath, "-verbose", "-sigalg", "SHA1withRSA", "-digestalg", "SHA1", "-keystore", keystorePath, "-storepass", "android", "-keypass", "android", signedApk.getAbsolutePath(), "androiddebugkey"};
        try {
            this.executeCommand(command, 60000L);
        }
        catch (IOException e) {
            throw new IOException("APK\u7b7e\u540d\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void executeCommand(String[] command, long timeout) throws IOException {
        for (int i = 0; i < command.length; ++i) {
            if (command[i] != null) continue;
            throw new IOException("\u547d\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3anull\uff0c\u7d22\u5f15: " + i);
        }
        logger.info("\u6267\u884c\u547d\u4ee4: {}", (Object)String.join((CharSequence)" ", command));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        try {
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            boolean finished = process.waitFor(timeout, TimeUnit.MILLISECONDS);
            if (!finished) {
                process.destroyForcibly();
                throw new IOException("\u547d\u4ee4\u8d85\u65f6 (" + timeout + "ms)");
            }
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new IOException("\u547d\u4ee4\u5931\u8d25\uff0c\u9000\u51fa\u7801: " + exitCode + "\n\u8f93\u51fa: " + String.valueOf(output));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("\u547d\u4ee4\u6267\u884c\u4e2d\u65ad", e);
        }
        catch (IOException e) {
            throw new IOException("\u65e0\u6cd5\u6267\u884c\u547d\u4ee4: " + e.getMessage(), e);
        }
    }
}

