/*
 * Decompiled with CFR 0.152.
 */
package com.apktoolscnm.apktoolcnm.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ApktoolInstaller
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(ApktoolInstaller.class);
    @Value(value="${apktool.install.path:/usr/local/bin}")
    private String installPath;

    public void run(String ... args) throws Exception {
        logger.info("\u5f00\u59cb\u5b89\u88c5apktool\u5230: {}", (Object)this.installPath);
        try {
            String[] files;
            Path installDir = Paths.get(this.installPath, new String[0]);
            if (!Files.exists(installDir, new LinkOption[0])) {
                Files.createDirectories(installDir, new FileAttribute[0]);
                logger.info("\u521b\u5efa\u5b89\u88c5\u76ee\u5f55: {}", (Object)installDir);
            }
            for (String filename : files = new String[]{"apktool", "apktool.jar"}) {
                this.installFile(filename, installDir);
            }
            this.verifyInstallation();
        }
        catch (Exception e) {
            logger.error("apktool\u5b89\u88c5\u5931\u8d25", (Throwable)e);
        }
    }

    private void installFile(String filename, Path installDir) throws Exception {
        Path destPath = installDir.resolve(filename);
        if (Files.exists(destPath, new LinkOption[0])) {
            logger.info("{} \u5df2\u5b58\u5728\u4e8e {}", (Object)filename, (Object)destPath);
            return;
        }
        ClassPathResource resource = new ClassPathResource("apktool/" + filename);
        if (!resource.exists()) {
            logger.warn("\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: apktool/{}", (Object)filename);
            return;
        }
        try (InputStream in = resource.getInputStream();){
            Files.copy(in, destPath, StandardCopyOption.REPLACE_EXISTING);
            logger.info("\u5df2\u590d\u5236 {} \u5230 {}", (Object)filename, (Object)destPath);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6587\u4ef6\u5931\u8d25: {}", (Object)filename, (Object)e);
            throw e;
        }
        if (filename.equals("apktool")) {
            File file = destPath.toFile();
            if (file.setExecutable(true)) {
                logger.info("\u5df2\u8bbe\u7f6e\u53ef\u6267\u884c\u6743\u9650: {}", (Object)destPath);
            } else {
                logger.warn("\u8bbe\u7f6e\u53ef\u6267\u884c\u6743\u9650\u5931\u8d25: {}", (Object)destPath);
            }
        }
    }

    private void verifyInstallation() {
        logger.info("\u9a8c\u8bc1apktool\u5b89\u88c5...");
        try {
            ProcessBuilder pb = new ProcessBuilder(this.installPath + "/apktool");
            Process process = pb.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
            boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroyForcibly();
                logger.warn("apktool\u9a8c\u8bc1\u8d85\u65f6");
                return;
            }
            int exitCode = process.waitFor();
            if (exitCode == 0 || output.toString().contains("Apktool")) {
                logger.info("apktool\u5b89\u88c5\u9a8c\u8bc1\u6210\u529f!");
            } else {
                logger.warn("apktool\u9a8c\u8bc1\u5931\u8d25\uff0c\u9000\u51fa\u7801: {}\uff0c\u4f46\u53ef\u80fd\u4ecd\u7136\u53ef\u7528", (Object)exitCode);
            }
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1apktool\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
        }
    }
}

