/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.ApktoolProperties;
import brut.androlib.apk.PackageInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.apk.VersionInfo;
import brut.androlib.apk.YamlLine;
import brut.androlib.apk.YamlReader;
import brut.androlib.apk.YamlSerializable;
import brut.androlib.apk.YamlWriter;
import brut.androlib.exceptions.AndrolibException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;

public final class ApkInfo
implements YamlSerializable {
    public static final String[] RESOURCES_DIRNAMES;
    public static final String[] RAW_DIRNAMES;
    public static final Pattern ORIGINAL_FILENAMES_PATTERN;
    public static final Pattern STANDARD_FILENAMES_PATTERN;
    public transient ExtFile mApkFile;
    public String version;
    public String apkFileName;
    public boolean isFrameworkApk;
    public UsesFramework usesFramework;
    public final LinkedHashMap sdkInfo = new LinkedHashMap();
    public PackageInfo packageInfo = new PackageInfo();
    public VersionInfo versionInfo = new VersionInfo();
    public final LinkedHashMap featureFlags = new LinkedHashMap();
    public boolean sharedLibrary;
    public boolean sparseResources;
    public boolean compactEntries;
    public ArrayList doNotCompress = new ArrayList();

    public ApkInfo() {
        this.version = ApktoolProperties.get("application.version");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApkInfo load(InputStream object) {
        YamlLine yamlLine;
        ApkInfo apkInfo;
        YamlReader yamlReader;
        YamlReader yamlReader2 = yamlReader;
        yamlReader = new YamlReader((InputStream)object);
        object = apkInfo;
        apkInfo = new ApkInfo();
        if (yamlReader.isEnd()) return object;
        if (!yamlReader2.isEnd()) {
            YamlReader yamlReader3;
            do {
                yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
                if (!yamlLine.isEmpty && !yamlLine.isComment) break;
                yamlReader3 = yamlReader2;
                ++yamlReader3.mCurrent;
            } while (!yamlReader3.isEnd());
        }
        while (!yamlReader2.isEnd()) {
            yamlLine = (YamlLine)yamlReader2.mLines.get(yamlReader2.mCurrent);
            if (yamlLine.indent == 0 && yamlLine.hasColon) {
                ((ApkInfo)object).readItem(yamlReader2);
                yamlReader2.nextLine();
                continue;
            }
            yamlReader2.nextLine();
        }
        return object;
    }

    static {
        Pattern pattern;
        CharSequence[] charSequenceArray = new String[3];
        CharSequence[] charSequenceArray2 = charSequenceArray;
        charSequenceArray[0] = "res";
        charSequenceArray[1] = "r";
        charSequenceArray[2] = "R";
        RESOURCES_DIRNAMES = charSequenceArray;
        CharSequence[] charSequenceArray3 = new String[2];
        CharSequence[] charSequenceArray4 = charSequenceArray3;
        charSequenceArray3[0] = "assets";
        charSequenceArray3[1] = "lib";
        RAW_DIRNAMES = charSequenceArray3;
        ORIGINAL_FILENAMES_PATTERN = pattern = Pattern.compile("AndroidManifest\\.xml|META-INF/[^/]+\\.(RSA|SF|MF)|stamp-cert-sha256");
        STANDARD_FILENAMES_PATTERN = Pattern.compile("[^/]+\\.dex|resources\\.arsc|(" + String.join((CharSequence)"|", charSequenceArray2) + "|" + String.join((CharSequence)"|", charSequenceArray4) + ")/.*|" + pattern.pattern());
    }

    public static int mapSdkShorthandToVersion(String string) {
        String string2 = string.toUpperCase();
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1925547863: {
                if (!string2.equals("SDK_CUR_DEVELOPMENT")) break;
                n = 15;
                break;
            }
            case 378189004: {
                if (!string2.equals("BAKLAVA")) break;
                n = 14;
                break;
            }
            case 345728426: {
                if (!string2.equals("VANILLA_ICE_CREAM")) break;
                n = 13;
                break;
            }
            case 28758568: {
                if (!string2.equals("UPSIDE_DOWN_CAKE")) break;
                n = 12;
                break;
            }
            case 82479: {
                if (!string2.equals("SV2")) break;
                n = 11;
                break;
            }
            case 84: {
                if (!string2.equals("T")) break;
                n = 10;
                break;
            }
            case 83: {
                if (!string2.equals("S")) break;
                n = 9;
                break;
            }
            case 82: {
                if (!string2.equals("R")) break;
                n = 8;
                break;
            }
            case 81: {
                if (!string2.equals("Q")) break;
                n = 7;
                break;
            }
            case 80: {
                if (!string2.equals("P")) break;
                n = 6;
                break;
            }
            case 79: {
                if (!string2.equals("O")) break;
                n = 5;
                break;
            }
            case 78: {
                if (!string2.equals("N")) break;
                n = 4;
                break;
            }
            case 77: {
                if (!string2.equals("M")) break;
                n = 3;
                break;
            }
            case -652872116: {
                if (!string2.equals("UPSIDEDOWNCAKE")) break;
                n = 2;
                break;
            }
            case -1154541982: {
                if (!string2.equals("TIRAMISU")) break;
                n = 1;
                break;
            }
            case -1229388494: {
                if (!string2.equals("VANILLAICECREAM")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return Integer.parseInt(string);
            }
            case 15: {
                return 10000;
            }
            case 14: {
                return 36;
            }
            case 11: {
                return 32;
            }
            case 9: {
                return 31;
            }
            case 8: {
                return 30;
            }
            case 7: {
                return 29;
            }
            case 6: {
                return 28;
            }
            case 5: {
                return 26;
            }
            case 4: {
                return 24;
            }
            case 3: {
                return 23;
            }
            case 2: 
            case 12: {
                return 34;
            }
            case 1: 
            case 10: {
                return 33;
            }
            case 0: 
            case 13: 
        }
        return 35;
    }

    public final boolean hasResources() {
        ExtFile extFile = ((ApkInfo)((Object)extFile)).mApkFile;
        if (extFile == null) {
            return false;
        }
        try {
            return extFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void save(File file) {
        YamlWriter yamlWriter;
        ApkInfo apkInfo = yamlWriter2;
        YamlWriter yamlWriter2 = yamlWriter;
        yamlWriter = new YamlWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]));
        try {
            apkInfo.write(yamlWriter);
        }
        catch (Throwable throwable) {
            try {
                yamlWriter2.mWriter.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new AndrolibException(exception);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AndrolibException("File not found");
                }
            }
        }
        yamlWriter2.mWriter.close();
    }

    @Override
    public final void readItem(YamlReader yamlReader) {
        YamlLine yamlLine = (YamlLine)yamlReader.mLines.get(yamlReader.mCurrent);
        String string = yamlLine.getKey();
        string.getClass();
        int n = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 1947723784: {
                if (!string.equals("sdkInfo")) break;
                n = 11;
                break;
            }
            case 1185869105: {
                if (!string.equals("featureFlags")) break;
                n = 10;
                break;
            }
            case 1078908901: {
                if (!string.equals("sparseResources")) break;
                n = 9;
                break;
            }
            case 955505032: {
                if (!string.equals("isFrameworkApk")) break;
                n = 8;
                break;
            }
            case 908622356: {
                if (!string.equals("packageInfo")) break;
                n = 7;
                break;
            }
            case 720675821: {
                if (!string.equals("compactEntries")) break;
                n = 6;
                break;
            }
            case 688769446: {
                if (!string.equals("versionInfo")) break;
                n = 5;
                break;
            }
            case 459524195: {
                if (!string.equals("apkFileName")) break;
                n = 4;
                break;
            }
            case 351608024: {
                if (!string.equals("version")) break;
                n = 3;
                break;
            }
            case -126270314: {
                if (!string.equals("sharedLibrary")) break;
                n = 2;
                break;
            }
            case -639607350: {
                if (!string.equals("doNotCompress")) break;
                n = 1;
                break;
            }
            case -1981305966: {
                if (!string.equals("usesFramework")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 11: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.sdkInfo.clear();
                yamlReader.readStringMap(apkInfo.sdkInfo);
                break;
            }
            case 10: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.featureFlags.clear();
                yamlReader.readBoolMap(apkInfo.featureFlags);
                break;
            }
            case 9: {
                yamlSerializable.sparseResources = yamlLine.getValueBool();
                break;
            }
            case 8: {
                yamlSerializable.isFrameworkApk = yamlLine.getValueBool();
                break;
            }
            case 7: {
                PackageInfo packageInfo;
                ApkInfo apkInfo = yamlSerializable;
                YamlSerializable yamlSerializable = packageInfo;
                packageInfo = new PackageInfo();
                apkInfo.packageInfo = yamlSerializable;
                yamlReader.readObject(yamlSerializable);
                break;
            }
            case 6: {
                yamlSerializable.compactEntries = yamlLine.getValueBool();
                break;
            }
            case 5: {
                VersionInfo versionInfo;
                ApkInfo apkInfo = yamlSerializable;
                YamlSerializable yamlSerializable = versionInfo;
                versionInfo = new VersionInfo();
                apkInfo.versionInfo = yamlSerializable;
                yamlReader.readObject(yamlSerializable);
                break;
            }
            case 4: {
                yamlSerializable.apkFileName = yamlLine.getValue();
                break;
            }
            case 3: {
                yamlSerializable.version = yamlLine.getValue();
                break;
            }
            case 2: {
                yamlSerializable.sharedLibrary = yamlLine.getValueBool();
                break;
            }
            case 1: {
                ApkInfo apkInfo = yamlSerializable;
                apkInfo.doNotCompress.clear();
                yamlReader.readStringList(apkInfo.doNotCompress);
                break;
            }
            case 0: {
                UsesFramework usesFramework;
                ApkInfo apkInfo = yamlSerializable;
                YamlSerializable yamlSerializable = usesFramework;
                usesFramework = new UsesFramework();
                apkInfo.usesFramework = yamlSerializable;
                yamlReader.readObject(yamlSerializable);
            }
        }
    }

    @Override
    public final void write(YamlWriter yamlWriter) {
        yamlWriter.writeString("version", this.version);
        yamlWriter.writeString("apkFileName", this.apkFileName);
        yamlWriter.writeBool("isFrameworkApk", this.isFrameworkApk);
        yamlWriter.writeObject("usesFramework", this.usesFramework);
        yamlWriter.writeMap("sdkInfo", this.sdkInfo);
        yamlWriter.writeObject("packageInfo", this.packageInfo);
        yamlWriter.writeObject("versionInfo", this.versionInfo);
        if (!this.featureFlags.isEmpty()) {
            yamlWriter.writeMap("featureFlags", this.featureFlags);
        }
        yamlWriter.writeBool("sharedLibrary", this.sharedLibrary);
        yamlWriter.writeBool("sparseResources", this.sparseResources);
        yamlWriter.writeBool("compactEntries", this.compactEntries);
        if (!this.doNotCompress.isEmpty()) {
            yamlWriter.writeList("doNotCompress", this.doNotCompress);
        }
    }
}

