/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.StringBlock;
import brut.util.ExtDataInputStream;
import com.google.common.io.CountingInputStream;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ARSCDecoder {
    public static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    public final ExtDataInputStream mIn;
    public final ResTable mResTable;
    public final ArrayList mFlagsOffsets;
    public final boolean mKeepBroken;
    public final Config mConfig;
    public final LinkedHashMap mMissingResSpecMap;
    public final HashMap mResTypeSpecs;
    public ARSCHeader mHeader;
    public StringBlock mTableStrings;
    public StringBlock mTypeNames;
    public StringBlock mSpecNames;
    public ResPackage mPkg;
    public ResTypeSpec mTypeSpec;
    public ResType mType;
    public int mResId;
    public int mTypeIdOffset;

    public ARSCDecoder(InputStream object, ResTable resTable, boolean bl, boolean bl2) {
        ExtDataInputStream extDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream;
        CountingInputStream countingInputStream;
        CountingInputStream countingInputStream2 = countingInputStream;
        countingInputStream = new CountingInputStream((InputStream)object);
        object = littleEndianDataInputStream;
        littleEndianDataInputStream = new LittleEndianDataInputStream(countingInputStream2);
        ExtDataInputStream extDataInputStream2 = extDataInputStream;
        extDataInputStream = new ExtDataInputStream((DataInput)object, countingInputStream2);
        this.mIn = extDataInputStream2;
        this.mResTable = resTable;
        if (bl) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            object = null;
        }
        ARSCDecoder aRSCDecoder = this;
        this.mFlagsOffsets = object;
        this.mKeepBroken = bl2;
        aRSCDecoder.mConfig = resTable.mConfig;
        aRSCDecoder.mMissingResSpecMap = new LinkedHashMap();
        aRSCDecoder.mResTypeSpecs = new HashMap();
    }

    public static char[] unpackLanguageOrRegion(byte by, byte by2, char c) {
        if ((by >> 7 & 1) == 1) {
            byte by3 = by;
            byte by4 = by2;
            by2 = (byte)(by4 & 0x1F);
            byte by5 = by = (byte)(((by4 & 0xE0) >> 5) + ((by & 3) << 3));
            by = (byte)(by2 + c);
            by2 = (byte)(by5 + c);
            c = (char)(((by3 & 0x7C) >> 2) + c);
            return new char[]{(char)by, (char)by2, c};
        }
        by = by;
        by2 = by2;
        return new char[]{(char)by, (char)by2};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ARSCData decode() {
        FlagsOffset[] flagsOffsetArray;
        block3: {
            try {
                ResPackage[] resPackageArray = resPackageArray.readResourceTable();
                flagsOffsetArray = resPackageArray.mFlagsOffsets;
                if (resPackageArray.mFlagsOffsets == null) break block3;
            }
            catch (IOException iOException) {
                throw new AndrolibException("Could not decode arsc file", iOException);
            }
            flagsOffsetArray = flagsOffsetArray.toArray(new FlagsOffset[0]);
            return new ARSCData(resPackageArray, flagsOffsetArray);
        }
        flagsOffsetArray = null;
        return new ARSCData(resPackageArray, flagsOffsetArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ResPackage[] readResourceTable() {
        var1_1 = v0;
        v0 = new LinkedHashSet<ResPackage>();
        var2_2 = 1;
        block29: while (true) {
            block114: {
                block115: {
                    block116: {
                        var3_5 = this.mIn;
                        var4_18 = var3_5.mCountIn.count;
                        try {
                            var6_42 = var3_5.mDelegate.readShort();
                        }
                        catch (EOFException v3) {
                            var7_47 = v4;
                            var3_6 = 0;
                            var4_19 = 0;
                            var5_27 = var3_5.mCountIn.count;
                            v4 = new ARSCHeader(-1, var3_6, var4_19, var5_27);
                        }
                        var7_47 = v1;
                        v2 = var3_5;
                        var3_6 = v2.mDelegate.readShort();
                        v1 = new ARSCHeader(var6_42, var3_6, v2.mDelegate.readInt(), var4_18);
                        this.mHeader = var7_47;
                        var3_7 = ARSCDecoder.LOGGER;
                        var4_20 = var2_2++;
                        var5_28 = this.mIn.mCountIn.count;
                        var6_43 = this.mHeader.type;
                        var7_47 = this.mHeader.chunkSize;
                        var3_7.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", new Object[]{var4_20, var5_28, var6_43, var7_47}));
                        var4_21 = this.mHeader.type;
                        if (var4_21 == 0) break block114;
                        if (var4_21 == 1) break block115;
                        if (var4_21 == 2) break block116;
                        switch (var4_21) {
                            default: {
                                if (var4_21 != -1) {
                                    v5 = var3_7;
                                    var2_3 = (short)var4_21;
                                    v6 = new Object[1];
                                    var3_7 = v6;
                                    v6[0] = var2_3;
                                    v5.severe(String.format("Unknown chunk type: %04x", (Object[])var3_7));
                                }
                                if (this.mConfig.mDecodeResolveMode == 1 && (var2_4 = this.mPkg) != null && var2_4.mResSpecs.size() > 0) {
                                    for (Object var3_7 : this.mMissingResSpecMap.keySet()) {
                                        var4_22 = var3_7.intValue();
                                        var3_7 = (Integer)this.mMissingResSpecMap.get(var3_7);
                                        var3_7.getClass();
                                        var5_28 = "APKTOOL_DUMMY_" + Integer.toHexString(var4_22);
                                        var6_43 = v7;
                                        v7 = new ResID(var4_22);
                                        var4_23 = v8;
                                        var3_7 = (ResTypeSpec)this.mResTypeSpecs.get(var3_7);
                                        v8 = new ResResSpec((ResID)var6_43, (String)var5_28, this.mPkg, (ResTypeSpec)var3_7);
                                        if (this.mPkg.mResSpecs.containsKey(var6_43)) continue;
                                        if (this.mPkg.mResSpecs.put(var6_43, var4_23) == null) {
                                            var4_23.mType.addResSpec(var4_23);
                                            var3_7 = this.mPkg;
                                            var5_28 = v9;
                                            v9 = new ResConfigFlags();
                                            var6_43 = (ResType)var3_7.mConfigs.get(var5_28);
                                            if (var6_43 == null) {
                                                var6_43 = v10;
                                                v10 = new ResType((ResConfigFlags)var5_28);
                                                var3_7.mConfigs.put(var5_28, var6_43);
                                            }
                                            var3_7 = v11;
                                            v11 = new ResReferenceValue(this.mPkg, "");
                                            var5_28 = v12;
                                            var6_43.addResource(new ResResource((ResType)var6_43, var4_23, (ResValue)var3_7), false);
                                            var4_23.addResource((ResResource)var5_28, false);
                                            continue;
                                        }
                                        throw new AndrolibException("Multiple resource specs: " + var4_23);
                                    }
                                }
                                return var1_1.toArray(new ResPackage[0]);
                            }
                            case 518: {
                                var3_8 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_21 = 0;
                                while (true) {
                                    if (var4_21 >= var3_8) continue block29;
                                    var5_28 = this.mIn.mDelegate.readInt();
                                    var6_43 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", new Object[]{var5_28, var6_43}));
                                    ++var4_21;
                                }
                            }
                            case 517: {
                                this.checkChunkType(517);
                                this.mIn.mDelegate.readInt();
                                var3_9 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_21 = 0;
                                while (true) {
                                    if (var4_21 >= var3_9) continue block29;
                                    var5_28 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Skipping overlay (%h)", new Object[]{var5_28}));
                                    ++var4_21;
                                }
                            }
                            case 516: {
                                v13 = var3_7;
                                this.checkChunkType(516);
                                var3_7 = this.mIn.readNullEndedString(256);
                                var4_24 = this.mIn.readNullEndedString(256);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                v14 = var5_28 = v15;
                                var5_28("Overlay name: \"");
                                v14.append((String)var3_7);
                                v14.append("\", actor: \"");
                                v15.append(var4_24);
                                v15.append("\")");
                                v13.fine(v15.toString());
                                continue block29;
                            }
                            case 515: {
                                this.checkChunkType(515);
                                var3_10 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_21 = 0;
                                while (true) {
                                    if (var4_21 >= var3_10) continue block29;
                                    var5_28 = this.mIn.readNullEndedString(128);
                                    var6_43 = this.mIn.mDelegate.readInt();
                                    v16 = new Object[2];
                                    var7_47 = v16;
                                    v16[0] = var5_28;
                                    v16[1] = var6_43;
                                    ARSCDecoder.LOGGER.info(String.format("Decoding Shared Library (%s), pkgId: %d", var7_47));
                                    ++var4_21;
                                }
                            }
                            case 514: {
                                this.checkChunkType(514);
                                var3_11 = this.mIn.mDelegate.readUnsignedByte();
                                this.mIn.skipBytes(1);
                                this.mIn.skipBytes(2);
                                var4_21 = this.mIn.mDelegate.readInt();
                                var5_28 = this.mFlagsOffsets;
                                if (var5_28 != null) {
                                    var5_28.add(new FlagsOffset((int)this.mIn.mCountIn.count, var4_21));
                                }
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                this.mIn.skipBytes(var4_21 * 4);
                                var4_25 = v17;
                                var3_12 = this.mTypeNames.getString(var3_11 - 1);
                                v17 = new ResTypeSpec(var3_11, (String)var3_12);
                                this.mTypeSpec = var4_25;
                                var5_28 = this.mPkg;
                                if (var5_28.mTypes.containsKey(var3_12)) {
                                    ResPackage.LOGGER.warning("Multiple types detected! " + var4_25 + " ignored!");
                                } else {
                                    var5_28.mTypes.put(var3_12, var4_25);
                                }
                                var3_12 = this.mTypeSpec;
                                this.mResTypeSpecs.put(var3_12.mId, var3_12);
                                continue block29;
                            }
                            case 513: {
                                this.checkChunkType(513);
                                var4_21 = this.mIn.mDelegate.readUnsignedByte() - this.mTypeIdOffset;
                                if (this.mResTypeSpecs.containsKey(var4_21)) {
                                    this.mTypeSpec = (ResTypeSpec)this.mResTypeSpecs.get(var4_21);
                                } else {
                                    var5_28 = v18;
                                    v18 = new ResTypeSpec(var4_21, this.mTypeNames.getString(var4_21 - 1));
                                    this.mTypeSpec = var5_28;
                                    this.mResTypeSpecs.put(var4_21, var5_28);
                                    var5_28 = this.mPkg;
                                    var6_43 = this.mTypeSpec;
                                    if (var5_28.mTypes.containsKey(var6_43.mName)) {
                                        ResPackage.LOGGER.warning("Multiple types detected! " + var6_43 + " ignored!");
                                    } else {
                                        var5_28.mTypes.put(var6_43.mName, var6_43);
                                    }
                                }
                                this.mResId = this.mResId & -16777216 | this.mTypeSpec.mId << 16;
                                var5_29 = this.mIn.mDelegate.readByte();
                                this.mIn.skipBytes(2);
                                var6_44 = this.mIn.mDelegate.readInt();
                                var7_48 = this.mIn.mDelegate.readInt();
                                var7_49 = this.mHeader.startPosition + (long)var7_48;
                                var9_50 = this.mIn.mDelegate.readInt();
                                var10_59 = 8;
                                if (var9_50 < 8) ** GOTO lbl578
                                var11_63 = 0;
                                var12_72 = this.mIn.mDelegate.readShort();
                                var13_76 = this.mIn.mDelegate.readShort();
                                var14_79 /* !! */  = new char[]{};
                                var15_85 /* !! */  = new char[]{};
                                if (var9_50 >= 12) {
                                    var14_79 /* !! */  = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), 'a');
                                    var15_85 /* !! */  = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), '0');
                                    var10_59 = 12;
                                }
                                var16_87 = 0;
                                var17_89 = 0;
                                if (var9_50 >= 14) {
                                    var16_87 = this.mIn.mDelegate.readByte();
                                    var17_89 = this.mIn.mDelegate.readByte();
                                    var10_59 = 14;
                                }
                                var18_92 = 0;
                                if (var9_50 >= 16) {
                                    var18_92 = this.mIn.mDelegate.readUnsignedShort();
                                    var10_59 = 16;
                                }
                                var19_95 = 0;
                                var20_96 = 0;
                                var21_98 = 0;
                                var22_100 = 0;
                                if (var9_50 >= 20) {
                                    var19_95 = this.mIn.mDelegate.readByte();
                                    var20_96 = this.mIn.mDelegate.readByte();
                                    var21_98 = this.mIn.mDelegate.readByte();
                                    var22_100 = this.mIn.mDelegate.readByte();
                                    var10_59 = 20;
                                }
                                var23_101 = 0;
                                var24_103 = 0;
                                var25_104 = 0;
                                if (var9_50 >= 28) {
                                    var23_101 = this.mIn.mDelegate.readShort();
                                    var24_103 = this.mIn.mDelegate.readShort();
                                    var25_104 = this.mIn.mDelegate.readShort();
                                    this.mIn.skipBytes(2);
                                    var10_59 = 28;
                                }
                                var26_106 = false;
                                var27_107 = 0;
                                var28_108 = 0;
                                if (var9_50 >= 32) {
                                    var26_106 = this.mIn.mDelegate.readByte();
                                    var27_107 = this.mIn.mDelegate.readByte();
                                    var28_108 = this.mIn.mDelegate.readShort();
                                    var10_59 = 32;
                                }
                                var29_109 = 0;
                                var30_110 = 0;
                                if (var9_50 >= 36) {
                                    var29_109 = this.mIn.mDelegate.readShort();
                                    var30_110 = this.mIn.mDelegate.readShort();
                                    var10_59 = 36;
                                }
                                var31_111 = null;
                                var32_112 = null;
                                if (var9_50 >= 48) {
                                    var31_111 = this.readVariantLengthString(4).toCharArray();
                                    var32_112 = this.readVariantLengthString(8).toCharArray();
                                    var10_59 = 48;
                                }
                                var33_113 = 0;
                                var34_114 = 0;
                                if (var9_50 >= 52) {
                                    var33_113 = this.mIn.mDelegate.readByte();
                                    var34_114 = this.mIn.mDelegate.readByte();
                                    this.mIn.skipBytes(2);
                                    var10_59 = 52;
                                }
                                var35_115 = null;
                                if (var9_50 >= 60) {
                                    var35_115 = this.readVariantLengthString(8).toCharArray();
                                    var10_59 = 60;
                                }
                                if ((var36_116 = var9_50 - 64) > 0) {
                                    v19 = var36_116;
                                    var10_60 /* !! */  = new byte[v19];
                                    var36_116 = var10_59 + v19;
                                    this.mIn.mDelegate.readFully(var10_60 /* !! */ );
                                    var37_117 = v20;
                                    if (new BigInteger(1, var10_60 /* !! */ ).equals(BigInteger.ZERO)) {
                                        v21 = var3_7;
                                        var3_7 = 64;
                                        v22 = new Object[1];
                                        var10_60 /* !! */  = (byte[])v22;
                                        v22[0] = var3_7;
                                        v21.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", var10_60 /* !! */ ));
                                        var10_59 = var36_116;
                                    } else {
                                        v23 = var3_7;
                                        var3_7 = 64;
                                        var10_60 /* !! */  = (byte[])var9_50;
                                        v24 = new Object[3];
                                        var11_64 = v24;
                                        v24[0] = var3_7;
                                        v24[1] = var10_60 /* !! */ ;
                                        v24[2] = var37_117;
                                        v23.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", var11_64));
                                        var11_63 = 1;
                                        var10_59 = var36_116;
                                    }
                                }
                                if ((var3_13 = var9_50 - var10_59) > 0) {
                                    this.mIn.skipBytes(var3_13);
                                }
                                var3_14 = v25;
                                v25 = new ResConfigFlags((short)var12_72, (short)var13_76, var14_79 /* !! */ , var15_85 /* !! */ , (byte)var16_87, var17_89, var18_92, (byte)var19_95, var20_96, var21_98, (byte)var22_100, var23_101, (short)var24_103, var25_104, (byte)var26_106, var27_107, var28_108, var29_109, var30_110, var31_111, var32_112, var33_113, var34_114, var35_115, var9_50, (boolean)var11_63);
                                this.mIn.mark(this.mHeader.chunkSize);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var9_50 = (var5_29 & 2) != 0 ? 1 : 0;
                                var5_29 = (var5_29 & 1) != 0 ? 1 : 0;
                                if (var5_29 != 0) {
                                    var10_61 = this.mResTable;
                                    if (!var10_61.mMainPkgLoaded) {
                                        var10_61.mApkInfo.sparseResources = var10_62 = true;
                                    }
                                }
                                var10_58 = v26;
                                v26 = new LinkedHashMap<Integer, Integer>();
                                for (var11_63 = 0; var11_63 < var6_44; ++var11_63) {
                                    if (var5_29 != 0) {
                                        var10_58.put(this.mIn.mDelegate.readUnsignedShort(), this.mIn.mDelegate.readUnsignedShort() * 4);
                                        continue;
                                    }
                                    if (var9_50 != 0) {
                                        var12_72 = this.mIn.mDelegate.readUnsignedShort();
                                        var13_77 = var11_63;
                                        var12_73 = var12_72 == 65535 ? -1 : var12_72 * 4;
                                        var10_58.put(var13_77, var12_73);
                                        continue;
                                    }
                                    var10_58.put(var11_63, this.mIn.mDelegate.readInt());
                                }
                                if (var3_14.mIsInvalid) {
                                    var5_30 = this.mTypeSpec.mName + var3_14.mQualifiers;
                                    if (this.mKeepBroken) {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected: " + var5_30);
                                    } else {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected. Dropping resources: " + var5_30);
                                    }
                                }
                                if (var3_14.mIsInvalid && !this.mKeepBroken) {
                                    var3_14 = null;
                                } else {
                                    var5_31 = this.mPkg;
                                    var9_51 = (ResType)var5_31.mConfigs.get(var3_14);
                                    if (var9_51 == null) {
                                        v27 = var5_31;
                                        var5_31 = v28;
                                        v28 = new ResType((ResConfigFlags)var3_14);
                                        v27.mConfigs.put(var3_14, var5_31);
                                        var3_14 = var5_31;
                                    } else {
                                        var3_14 = var9_51;
                                    }
                                }
                                this.mType = var3_14;
                                this.mIn.jumpTo(var7_49);
                                var3_14 = var10_58.keySet().iterator();
                                while (var3_14.hasNext()) {
                                    v29 = (Integer)var3_14.next();
                                    var5_32 = v29;
                                    this.mResId = this.mResId & -65536 | var5_32;
                                    var9_52 = (Integer)var10_58.get(v29);
                                    if (var9_52 == -1) {
                                        var5_33 = this.mResId;
                                        this.mMissingResSpecMap.put(var5_33, var4_21);
                                        continue;
                                    }
                                    var11_65 = var7_49 + (long)var9_52;
                                    var9_53 = this.mIn;
                                    if (var11_65 < var9_53.mCountIn.count) {
                                        var9_53.reset();
                                    }
                                    this.mIn.jumpTo(var11_65);
                                    var9_53 = this.mIn;
                                    if (var9_53.mCountIn.count >= this.mHeader.endPosition) {
                                        var3_15 = var6_44 - var5_32;
                                        var3_14 = var3_15;
                                        var4_26 = this.mTypeSpec.mName;
                                        ARSCDecoder.LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", new Object[]{var3_14, var4_26}));
                                        break;
                                    }
                                    var5_32 = var9_53.mDelegate.readUnsignedShort();
                                    var9_54 = this.mIn.mDelegate.readShort();
                                    var11_66 = (var9_54 & 1) != 0;
                                    var12_72 = (var9_54 & 8) != 0 ? 1 : 0;
                                    var13_76 = this.mIn.mDelegate.readInt();
                                    if (var13_76 == -1 && var12_72 == 0) {
                                        while (true) {
                                            var5_34 = null;
                                            break;
                                        }
                                    } else {
                                        if (var12_72 != 0) {
                                            v30 = this.mResTable;
                                            var14_79 /* !! */  = (char[])v30;
                                            if (!v30.mMainPkgLoaded) {
                                                var14_79 /* !! */ .mApkInfo.compactEntries = var14_80 = true;
                                            }
                                        }
                                        if (var12_72 != 0) {
                                            v31 = (byte)(var9_54 >> 8 & 255);
                                            var9_54 = v31;
                                            if (v31 == 3) {
                                                var9_55 = this.mPkg.getValueFactory();
                                                var11_67 = this.mTableStrings.getHTML(var13_76);
                                                var9_55.getClass();
                                                if (var11_67 == null) {
                                                    var9_55 = v32;
                                                    v32 = new ResFileValue(var13_76, "");
                                                } else if (var11_67.startsWith("res/")) {
                                                    var9_55 = v33;
                                                    v33 = new ResFileValue(var13_76, var11_67);
                                                } else if (!var11_67.startsWith("r/") && !var11_67.startsWith("R/")) {
                                                    var9_55 = v34;
                                                    v34 = new ResStringValue(var13_76, var11_67);
                                                } else {
                                                    var9_55 = v35;
                                                    v35 = new ResFileValue(var13_76, var11_67);
                                                }
                                            } else {
                                                var9_55 = this.mPkg.getValueFactory().factory(null, var9_54, var13_76);
                                            }
                                        } else if (var11_66) {
                                            var5_32 = this.mIn.mDelegate.readInt();
                                            var9_54 = this.mIn.mDelegate.readInt();
                                            var11_68 = this.mPkg.getValueFactory();
                                            var12_74 = new Pair[var9_54];
                                            for (var14_81 = 0; var14_81 < var9_54; ++var14_81) {
                                                var15_86 = this.mIn.mDelegate.readInt();
                                                var16_88 = this.readValue();
                                                if (var16_88 == null) continue;
                                                if (!(var16_88 instanceof ResScalarValue)) {
                                                    var17_90 = v36;
                                                    v37 = var16_88;
                                                    var16_88 = v37.toString();
                                                    v36 = new ResStringValue(v37.mRawIntValue, (String)var16_88);
                                                    var16_88 = var17_90;
                                                }
                                                var12_74[var14_81] = Pair.of(var15_86, (ResScalarValue)var16_88);
                                            }
                                            var14_82 = this.mTypeSpec;
                                            var15_85 /* !! */  = null;
                                            var16_87 = 0;
                                            var17_91 = v38;
                                            v38 = new ResReferenceValue(var11_68.mPackage, var5_32, (String)var15_85 /* !! */ , (boolean)var16_87);
                                            if (var9_54 == 0) {
                                                var5_35 = v39;
                                                v39 = new ResBagValue(var17_91);
                                                var9_55 = var5_35;
                                            } else {
                                                var5_35 = var14_82.mName;
                                                var5_35.getClass();
                                                var14_83 = -1;
                                                switch (var5_35.hashCode()) {
                                                    default: {
                                                        break;
                                                    }
                                                    case 93090393: {
                                                        if (!var5_35.equals("array")) break;
                                                        var14_83 = 3;
                                                        break;
                                                    }
                                                    case 3004913: {
                                                        if (!var5_35.equals("attr")) break;
                                                        var14_83 = 2;
                                                        break;
                                                    }
                                                    case -475309713: {
                                                        if (!var5_35.equals("plurals")) break;
                                                        var14_83 = 1;
                                                        break;
                                                    }
                                                    case -576469755: {
                                                        if (!var5_35.equals("^attr-private")) break;
                                                        var14_83 = 0;
                                                    }
                                                }
                                                switch (var14_83) {
                                                    default: {
                                                        if (var5_35.startsWith("style")) {
                                                            var5_35 = v40;
                                                            v40 = new ResStyleValue(var17_91, var12_74, var11_68);
                                                            var9_55 = var5_35;
                                                            break;
                                                        }
                                                        throw new AndrolibException("unsupported res type name for bags. Found: ".concat((String)var5_35));
                                                    }
                                                    case 3: {
                                                        var5_35 = v41;
                                                        v41 = new ResArrayValue(var17_91, var12_74);
                                                        var9_55 = var5_35;
                                                        break;
                                                    }
                                                    case 1: {
                                                        var5_35 = v42;
                                                        v42 = new ResPluralsValue(var17_91, var12_74);
                                                        var9_55 = var5_35;
                                                        break;
                                                    }
                                                    case 0: 
                                                    case 2: {
                                                        var5_35 = null;
                                                        var14_84 = null;
                                                        var15_85 /* !! */  = null;
                                                        block38: for (var16_87 = 1; var16_87 < var9_54; ++var16_87) {
                                                            var18_94 = (ImmutablePair)var12_74[var16_87];
                                                            switch ((Integer)var18_94.left) {
                                                                default: {
                                                                    break block38;
                                                                }
                                                                case 0x1000003: {
                                                                    var15_85 /* !! */  = (char[])(((ResScalarValue)var18_94.right).mRawIntValue != 0);
                                                                    continue block38;
                                                                }
                                                                case 0x1000002: {
                                                                    var14_84 = ((ResScalarValue)var18_94.right).mRawIntValue;
                                                                    continue block38;
                                                                }
                                                                case 0x1000001: {
                                                                    var5_35 = ((ResScalarValue)var18_94.right).mRawIntValue;
                                                                }
                                                            }
                                                        }
                                                        var18_92 = ((ResScalarValue)((ImmutablePair)var12_74[0]).right).mRawIntValue;
                                                        var19_95 = var18_92 & 65535;
                                                        if (var16_87 == var9_54) {
                                                            var9_55 = v43;
                                                            v43 = new ResAttr(var17_91, var19_95, (Integer)var5_35, var14_84, (Boolean)var15_85 /* !! */ );
                                                            break;
                                                        }
                                                        var20_97 = var17_91.mPackage;
                                                        var21_99 = new Pair[var9_54 - var16_87];
                                                        var22_100 = 0;
                                                        while (var16_87 < var9_54) {
                                                            var23_102 = (ImmutablePair)var12_74[var16_87];
                                                            var24_103 = (Integer)var23_102.left;
                                                            var20_97.mSynthesizedRes.add(new ResID(var24_103));
                                                            var25_105 = null;
                                                            var26_106 = false;
                                                            var21_99[var22_100] = Pair.of(new ResReferenceValue(var11_68.mPackage, var24_103, var25_105, var26_106), (ResScalarValue)var23_102.right);
                                                            ++var16_87;
                                                            ++var22_100;
                                                        }
                                                        var9_54 = var18_92 & 0xFF0000;
                                                        if (var9_54 != 65536) {
                                                            if (var9_54 == 131072) {
                                                                var9_55 = v44;
                                                                v44 = new ResFlagsAttr(var17_91, var19_95, (Integer)var5_35, var14_84, (Boolean)var15_85 /* !! */ , var21_99);
                                                                break;
                                                            }
                                                            throw new AndrolibException("Could not decode attr value");
                                                        }
                                                        var9_55 = v45;
                                                        v45 = new ResEnumAttr(var17_91, var19_95, (Integer)var5_35, var14_84, (Boolean)var15_85 /* !! */ , var21_99);
                                                    }
                                                }
                                            }
                                            var5_32 = var13_76;
                                        } else {
                                            var9_55 = this.readValue();
                                            var5_32 = var13_76;
                                        }
                                        if (var9_55 == null) ** continue;
                                        var11_69 = v46;
                                        new EntryData().specNamesId = var5_32;
                                        new EntryData().value = var9_55;
                                        var5_34 = var11_69;
                                    }
                                    if (var5_34 == null) ** GOTO lbl565
                                    v47 = var5_34;
                                    var5_36 = v47.specNamesId;
                                    var9_56 = v47.value;
                                    if (this.mTypeSpec.mName.equals("string") && var9_56 instanceof ResFileValue) {
                                        var11_70 = v48;
                                        v49 = var9_56;
                                        var9_56 = ((ResFileValue)v49).mPath;
                                        v48 = new ResStringValue(((ResFileValue)v49).mRawIntValue, (String)var9_56);
                                        var9_56 = var11_70;
                                    }
                                    if (this.mType == null) continue;
                                    var11_71 = v50;
                                    v50 = new ResID(this.mResId);
                                    if (!this.mPkg.mResSpecs.containsKey(var11_71)) ** GOTO lbl541
                                    var5_37 = (ResResSpec)this.mPkg.mResSpecs.get(var11_71);
                                    if (var5_37 == null) {
                                        throw new UndefinedResObjectException("resource spec: " + var11_71);
                                    }
                                    ** GOTO lbl548
lbl541:
                                    // 1 sources

                                    var12_75 = v51;
                                    var5_37 = this.mSpecNames.getString(var5_36);
                                    var13_78 = this.mTypeSpec;
                                    v51 = new ResResSpec((ResID)var11_71, (String)var5_37, this.mPkg, var13_78);
                                    if (this.mPkg.mResSpecs.put(var11_71, var12_75) != null) ** GOTO lbl564
                                    this.mTypeSpec.addResSpec(var12_75);
                                    var5_37 = var12_75;
lbl548:
                                    // 2 sources

                                    v52 = this.mType;
                                    var11_71 = new ResResource(v52, (ResResSpec)var5_37, (ResValue)var9_56);
                                    try {
                                        v52.addResource((ResResource)var11_71, false);
                                        var5_37.addResource((ResResource)var11_71, false);
                                        continue;
                                    }
                                    catch (AndrolibException var9_57) {
                                        if (this.mKeepBroken) {
                                            this.mType.addResource((ResResource)var11_71, true);
                                            var5_37.addResource((ResResource)var11_71, true);
                                            v53 = new StringBuilder("Duplicate Resource Detected. Ignoring duplicate: ");
                                            v53.append(var11_71);
                                            ARSCDecoder.LOGGER.warning(v53.toString());
                                            continue;
                                        }
                                        throw var9_57;
                                    }
lbl564:
                                    // 1 sources

                                    throw new AndrolibException("Multiple resource specs: " + var12_75);
lbl565:
                                    // 1 sources

                                    var5_34 = this.mResId;
                                    this.mMissingResSpecMap.put(var5_34, var4_21);
                                }
                                var3_16 = this.mHeader.endPosition;
                                var5_38 = this.mIn;
                                var6_45 = var5_38.mCountIn.count;
                                if (var3_16 <= var6_45) continue block29;
                                var3_16 = var5_38.skip(var3_16 - var6_45);
                                var5_38 = v54;
                                var5_38("Unknown data detected at end of type chunk. Skipping: ");
                                ARSCDecoder.LOGGER.warning(v54.append(var3_16).append(" byte(s)").toString());
                                continue block29;
lbl578:
                                // 1 sources

                                throw new AndrolibException("Config size < 8");
                            }
                            case 512: 
                        }
                        this.mTypeIdOffset = 0;
                        this.checkChunkType(512);
                        var4_21 = this.mIn.mDelegate.readInt();
                        if (var4_21 == 0) {
                            var4_21 = 2;
                            var5_28 = this.mResTable;
                            if (var5_28.mPackageOriginal == null && var5_28.mPackageRenamed == null) {
                                var5_28.mApkInfo.sharedLibrary = var5_39 = true;
                            }
                        }
                        var5_40 = this.mIn.readNullEndedString(128);
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        this.mIn.mDelegate.readInt();
                        if (this.mHeader.headerSize == 288) {
                            this.mTypeIdOffset = this.mIn.mDelegate.readInt();
                        }
                        if (this.mTypeIdOffset > 0) {
                            var3_7.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
                        }
                        this.mHeader.checkForUnreadHeader(this.mIn);
                        this.mTypeNames = StringBlock.readWithChunk(this.mIn);
                        this.mSpecNames = StringBlock.readWithChunk(this.mIn);
                        this.mResId = var4_21 << 24;
                        this.mPkg = var3_7 = v55;
                        var1_1.add(new ResPackage(this.mResTable, var4_21, var5_40));
                        continue;
                    }
                    this.checkChunkType(2);
                    this.mIn.mDelegate.readInt();
                    this.mHeader.checkForUnreadHeader(this.mIn);
                    continue;
                }
                this.checkChunkType(1);
                v56 = this.mHeader;
                var3_17 = v56.startPosition;
                var5_41 = v56.headerSize;
                var6_46 = v56.chunkSize;
                this.mTableStrings = StringBlock.readWithoutChunk(this.mIn, var3_17, var5_41, var6_46);
                continue;
            }
            this.checkChunkType(0);
            this.mHeader.checkForUnreadHeader(this.mIn);
            var3_7.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
            var3_7 = this.mHeader;
            this.mIn.skipBytes(var3_7.chunkSize - var3_7.headerSize);
        }
    }

    public final ResIntBasedValue readValue() {
        Object object;
        if (((ARSCDecoder)object).mIn.mDelegate.readShort() < 8) {
            return null;
        }
        byte by = 0;
        int n = ((ARSCDecoder)object).mIn.mDelegate.readByte();
        if (n == 0) {
            by = ((ARSCDecoder)object).mIn.mDelegate.readByte();
            n = ((ARSCDecoder)object).mIn.mDelegate.readInt();
            if (by == 3) {
                Object object2 = object;
                object = ((ARSCDecoder)object2).mPkg.getValueFactory();
                String string = ((ARSCDecoder)object2).mTableStrings.getHTML(n);
                object.getClass();
                if (string == null) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, "");
                } else if (string.startsWith("res/")) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                } else if (!string.startsWith("r/") && !string.startsWith("R/")) {
                    ResStringValue resStringValue;
                    object = resStringValue;
                    resStringValue = new ResStringValue(n, string);
                } else {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                }
            } else {
                object = ((ARSCDecoder)object).mPkg.getValueFactory().factory(null, by, n);
            }
            return object;
        }
        object = by;
        Byte by2 = (byte)n;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = by2;
        throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", objectArray2));
    }

    public final String readVariantLengthString(int n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(16);
        while (true) {
            short s;
            int n2 = n;
            n = n2 + -1;
            if (n2 == 0 || (s = (short)this.mIn.mDelegate.readByte()) == 0) break;
            stringBuilder2.append((char)s);
        }
        this.mIn.skipBytes(n);
        return stringBuilder2.toString();
    }

    public final void checkChunkType(int n) {
        if (((ARSCDecoder)((Object)n2)).mHeader.type == n) {
            return;
        }
        ARSCDecoder aRSCDecoder = n2;
        Integer n2 = n;
        Short s = aRSCDecoder.mHeader.type;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = s;
        throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", objectArray2));
    }
}

