/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util;

import com.frezrik.jiagu.pack.core.AppManager;
import com.frezrik.jiagu.pack.util.CmdUtils;
import com.frezrik.jiagu.pack.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class SignUtils {
    private SignUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static String signature(File unsignedApk, String keyStore, String keyPwd, String alias, String alisaPwd) throws InterruptedException, IOException {
        String path = unsignedApk.getAbsolutePath();
        String v1Name = path.substring(0, path.indexOf(".apk")) + "_v1.apk";
        String cmd = AppManager.BIN_RUNNER + "jarsigner -sigalg SHA1withRSA -digestalg SHA1 -keystore " + keyStore + " -storepass " + keyPwd + " -keypass " + alisaPwd + " -signedjar " + v1Name + " " + unsignedApk.getAbsolutePath() + " " + alias;
        System.out.println("v1------------------" + cmd);
        CmdUtils.exec("v1 sign", cmd);
        FileUtils.delete(path);
        return v1Name;
    }

    private static String apkZipalign(String v1Apk) throws IOException, InterruptedException {
        String zipalignName = v1Apk.substring(0, v1Apk.indexOf(".apk")) + "_align.apk";
        String cmd = AppManager.BIN_RUNNER + AppManager.BIN_PATH + "zipalign -p 4 " + v1Apk + " " + zipalignName;
        CmdUtils.exec("zipalign", cmd);
        FileUtils.delete(v1Apk);
        return zipalignName;
    }

    public static void apkSignature(File unsignedApk, File signedApk, String keyStore, String keyPwd, String alias, String alisaPwd) throws IOException, InterruptedException {
        String v1Name = SignUtils.signature(unsignedApk, keyStore, keyPwd, alias, alisaPwd);
        String zipalignName = SignUtils.apkZipalign(v1Name);
        String cmd = AppManager.CMD_RUNNER + AppManager.BIN_PATH + "apksigner sign --ks " + keyStore + " --ks-pass pass:" + keyPwd + " --ks-key-alias " + alias + " --key-pass pass:" + alisaPwd + " --out " + signedApk.getAbsolutePath() + " " + zipalignName;
        System.out.println("v1v2v3------------------" + cmd);
        CmdUtils.exec("v1v2v3 sign", cmd);
        FileUtils.delete(zipalignName);
        FileUtils.delete(signedApk.getAbsolutePath() + ".idsig");
    }

    public static void apkSignatureV2(File unsignedApk, File signedApk, String keyStore, String keyPwd, String alias, String alisaPwd) throws IOException, InterruptedException {
        String v1Name = SignUtils.signature(unsignedApk, keyStore, keyPwd, alias, alisaPwd);
        String zipalignName = SignUtils.apkZipalign(v1Name);
        String cmd = AppManager.CMD_RUNNER + AppManager.BIN_PATH + "apksigner sign --ks " + keyStore + " --ks-pass pass:" + keyPwd + " --ks-key-alias " + alias + " --key-pass pass:" + alisaPwd + " --v1-signing-enabled false --v2-signing-enabled true --v3-signing-enabled false --out " + signedApk.getAbsolutePath() + " " + zipalignName;
        System.out.println("v2------------------" + cmd);
        CmdUtils.exec("v2 sign", cmd);
        FileUtils.delete(zipalignName);
        FileUtils.delete(signedApk.getAbsolutePath() + ".idsig");
    }

    public static void apkSignatureV3(File unsignedApk, File signedApk, String keyStore, String keyPwd, String alias, String alisaPwd) throws IOException, InterruptedException {
        String v1Name = SignUtils.signature(unsignedApk, keyStore, keyPwd, alias, alisaPwd);
        String zipalignName = SignUtils.apkZipalign(v1Name);
        String cmd = AppManager.CMD_RUNNER + AppManager.BIN_PATH + "apksigner sign --ks " + keyStore + " --ks-pass pass:" + keyPwd + " --ks-key-alias " + alias + " --key-pass pass:" + alisaPwd + " --v1-signing-enabled false --v2-signing-enabled false --v3-signing-enabled true --out " + signedApk.getAbsolutePath() + " " + zipalignName;
        System.out.println("v3------------------" + cmd);
        CmdUtils.exec("v3 sign", cmd);
        FileUtils.delete(zipalignName);
        FileUtils.delete(signedApk.getAbsolutePath() + ".idsig");
    }

    public static void apkSignatureV2V3(File unsignedApk, File signedApk, String keyStore, String keyPwd, String alias, String alisaPwd) throws IOException, InterruptedException {
        String v1Name = SignUtils.signature(unsignedApk, keyStore, keyPwd, alias, alisaPwd);
        String zipalignName = SignUtils.apkZipalign(v1Name);
        String cmd = AppManager.CMD_RUNNER + AppManager.BIN_PATH + "apksigner sign --ks " + keyStore + " --ks-pass pass:" + keyPwd + " --ks-key-alias " + alias + " --key-pass pass:" + alisaPwd + " --v1-signing-enabled false --v2-signing-enabled true --v3-signing-enabled true --out " + signedApk.getAbsolutePath() + " " + zipalignName;
        System.out.println("v2v3------------------" + cmd);
        CmdUtils.exec("v2v3 sign", cmd);
        FileUtils.delete(zipalignName);
        FileUtils.delete(signedApk.getAbsolutePath() + ".idsig");
    }
}

