/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import org.conscrypt.NativeCrypto;
import org.conscrypt.ScryptKeySpec;

public class ScryptSecretKeyFactory
extends SecretKeyFactorySpi {
    @Override
    protected SecretKey engineGenerateSecret(KeySpec inKeySpec) throws InvalidKeySpecException {
        int keyOutputBits;
        int p;
        int r;
        int n;
        byte[] salt;
        char[] password;
        if (inKeySpec instanceof ScryptKeySpec) {
            ScryptKeySpec spec = (ScryptKeySpec)inKeySpec;
            password = spec.getPassword();
            salt = spec.getSalt();
            n = spec.getCostParameter();
            r = spec.getBlockSize();
            p = spec.getParallelizationParameter();
            keyOutputBits = spec.getKeyLength();
        } else {
            try {
                password = (char[])this.getValue(inKeySpec, "getPassword");
                salt = (byte[])this.getValue(inKeySpec, "getSalt");
                n = (Integer)this.getValue(inKeySpec, "getCostParameter");
                r = (Integer)this.getValue(inKeySpec, "getBlockSize");
                p = (Integer)this.getValue(inKeySpec, "getParallelizationParameter");
                keyOutputBits = (Integer)this.getValue(inKeySpec, "getKeyLength");
            }
            catch (Exception e) {
                throw new InvalidKeySpecException("Not a valid scrypt KeySpec", e);
            }
        }
        if (keyOutputBits % 8 != 0) {
            throw new InvalidKeySpecException("Cannot produce fractional-byte outputs");
        }
        try {
            return new ScryptKey(NativeCrypto.Scrypt_generate_key(new String(password).getBytes("UTF-8"), salt, n, r, p, keyOutputBits / 8));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object getValue(KeySpec spec, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = spec.getClass().getMethod(methodName, null);
        return method.invoke((Object)spec, new Object[0]);
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class aClass) throws InvalidKeySpecException {
        if (secretKey == null) {
            throw new InvalidKeySpecException("Null KeySpec");
        }
        throw new NotImplementedException();
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey == null) {
            throw new InvalidKeyException("Null SecretKey");
        }
        throw new NotImplementedException();
    }

    private static class ScryptKey
    implements SecretKey {
        private static final long serialVersionUID = 2024924811854189128L;
        private final byte[] key;

        public ScryptKey(byte[] key) {
            this.key = key;
        }

        @Override
        public String getAlgorithm() {
            return "SCRYPT";
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            return this.key;
        }
    }

    private static class NotImplementedException
    extends RuntimeException {
        NotImplementedException() {
            super("Not implemented");
        }
    }
}

