/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util;

import com.frezrik.jiagu.pack.core.AppManager;
import com.frezrik.jiagu.pack.util.CmdUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;

public class DexUtils {
    private DexUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void dxCommand(File jar, File dex) throws IOException, InterruptedException {
        String cmd = AppManager.CMD_RUNNER + AppManager.BIN_PATH + "dx --dex --output=" + dex.getAbsolutePath() + " " + jar.getAbsolutePath();
        CmdUtils.exec("dx", cmd);
    }

    public static byte[] intToByte(int number) {
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)(number & 0xFF);
            number >>= 8;
        }
        return b;
    }

    public static void mergeDex(String output, byte[] shelldex, byte[] encryptDex) {
        byte[] temp = new byte[shelldex.length + encryptDex.length + 4];
        System.arraycopy(shelldex, 0, temp, 0, shelldex.length);
        System.arraycopy(encryptDex, 0, temp, shelldex.length, encryptDex.length);
        System.arraycopy(DexUtils.intToByte(shelldex.length), 0, temp, shelldex.length + encryptDex.length, 4);
        FileOutputStream fos = null;
        try {
            DexUtils.fixDex(temp);
            fos = new FileOutputStream(output);
            fos.write(temp);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fixDex(byte[] newdex) throws NoSuchAlgorithmException {
        DexUtils.fixFileSizeHeader(newdex);
        DexUtils.fixSHA1Header(newdex);
        DexUtils.fixCheckSumHeader(newdex);
    }

    private static void fixCheckSumHeader(byte[] dexBytes) {
        Adler32 adler = new Adler32();
        adler.update(dexBytes, 12, dexBytes.length - 12);
        long value = adler.getValue();
        int va = (int)value;
        byte[] newcs = DexUtils.intToByte(va);
        byte[] recs = new byte[4];
        for (int i = 0; i < 4; ++i) {
            recs[i] = newcs[newcs.length - 1 - i];
        }
        System.arraycopy(recs, 0, dexBytes, 8, 4);
    }

    private static void fixSHA1Header(byte[] dexBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(dexBytes, 32, dexBytes.length - 32);
        byte[] newdt = md.digest();
        System.arraycopy(newdt, 0, dexBytes, 12, 20);
    }

    private static void fixFileSizeHeader(byte[] dexBytes) {
        byte[] newfs = DexUtils.intToByte(dexBytes.length);
        byte[] refs = new byte[4];
        for (int i = 0; i < 4; ++i) {
            refs[i] = newfs[newfs.length - 1 - i];
        }
        System.arraycopy(refs, 0, dexBytes, 32, 4);
    }
}

