/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util.axml.meditor.core;

import com.frezrik.jiagu.pack.util.axml.AxmlReader;
import com.frezrik.jiagu.pack.util.axml.AxmlVisitor;
import com.frezrik.jiagu.pack.util.axml.AxmlWriter;
import com.frezrik.jiagu.pack.util.axml.NodeVisitor;
import com.frezrik.jiagu.pack.util.axml.meditor.property.ModificationProperty;
import com.frezrik.jiagu.pack.util.axml.meditor.utils.Log;
import com.frezrik.jiagu.pack.util.axml.meditor.utils.Utils;
import com.frezrik.jiagu.pack.util.axml.meditor.visitor.ManifestTagVisitor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ManifestEditor {
    private InputStream inputStream;
    private OutputStream outputStream;
    private ModificationProperty properties;
    private boolean needClosedStream = false;

    public ManifestEditor(String srcManifestFilePath, String dstManifestFilePath, ModificationProperty properties) {
        this.properties = properties;
        try {
            this.inputStream = new FileInputStream(srcManifestFilePath);
            this.outputStream = new FileOutputStream(dstManifestFilePath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.needClosedStream = true;
    }

    public ManifestEditor(InputStream inputStream, OutputStream outputStream, ModificationProperty properties) {
        this.properties = properties;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processManifest() {
        if (this.inputStream == null || this.outputStream == null || this.properties == null) {
            Log.i(" processManifest failed , inputStream = " + this.inputStream + " outputStream=" + this.outputStream + " properties = " + this.properties);
            return "";
        }
        byte[] bytes = Utils.getBytesFromInputStream(this.inputStream);
        AxmlReader reader = new AxmlReader(bytes);
        AxmlWriter writer = new AxmlWriter();
        try {
            reader.accept(new AxmlVisitor(writer){

                @Override
                public NodeVisitor child(String ns, String name) {
                    NodeVisitor child = super.child(ns, name);
                    return new ManifestTagVisitor(child, ManifestEditor.this.properties);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            byte[] modified = writer.toByteArray();
            this.outputStream.write(modified);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.needClosedStream) {
                Utils.close(this.inputStream);
                Utils.close(this.outputStream);
            }
        }
        return reader.getApplicationName();
    }
}

