/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.conscrypt.ShortBufferWithoutStackTraceException;

public abstract class OpenSSLBaseDHKeyAgreement<T>
extends KeyAgreementSpi {
    private T mPrivateKey;
    private int mExpectedResultLength;
    private byte[] mResult;

    protected OpenSSLBaseDHKeyAgreement() {
    }

    @Override
    public Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException {
        byte[] result;
        if (this.mPrivateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!lastPhase) {
            throw new IllegalStateException("DH only has one phase");
        }
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("Not a public key: " + key.getClass());
        }
        byte[] buffer = new byte[this.mExpectedResultLength];
        T openSslPublicKey = this.convertPublicKey((PublicKey)key);
        int actualResultLength = this.computeKey(buffer, openSslPublicKey, this.mPrivateKey);
        if (actualResultLength == -1) {
            throw new RuntimeException("Engine returned -1");
        }
        if (actualResultLength == this.mExpectedResultLength) {
            result = buffer;
        } else if (actualResultLength < this.mExpectedResultLength) {
            result = new byte[actualResultLength];
            System.arraycopy(buffer, 0, this.mResult, 0, this.mResult.length);
        } else {
            throw new RuntimeException("Engine produced a longer than expected result. Expected: " + this.mExpectedResultLength + ", actual: " + actualResultLength);
        }
        this.mResult = result;
        return null;
    }

    protected abstract T convertPublicKey(PublicKey var1) throws InvalidKeyException;

    protected abstract T convertPrivateKey(PrivateKey var1) throws InvalidKeyException;

    protected abstract int computeKey(byte[] var1, T var2, T var3) throws InvalidKeyException;

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws ShortBufferException {
        this.checkCompleted();
        int available = sharedSecret.length - offset;
        if (this.mResult.length > available) {
            throw new ShortBufferWithoutStackTraceException("Needed: " + this.mResult.length + ", available: " + available);
        }
        System.arraycopy(this.mResult, 0, sharedSecret, offset, this.mResult.length);
        return this.mResult.length;
    }

    @Override
    protected byte[] engineGenerateSecret() {
        this.checkCompleted();
        return this.mResult;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) {
        this.checkCompleted();
        return new SecretKeySpec(this.engineGenerateSecret(), algorithm);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Not a private key: " + key.getClass());
        }
        T privateKey = this.convertPrivateKey((PrivateKey)key);
        this.mExpectedResultLength = this.getOutputSize(privateKey);
        this.mPrivateKey = privateKey;
    }

    protected abstract int getOutputSize(T var1);

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.engineInit(key, random);
    }

    private void checkCompleted() {
        if (this.mResult == null) {
            throw new IllegalStateException("Key agreement not completed");
        }
    }
}

