/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.arsc;

import brut.util.ExtDataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.commons.io.input.CountingInputStream;

public class ARSCHeader {
    public final short type;
    public final int headerSize;
    public final int chunkSize;
    public final int startPosition;
    public final int endPosition;

    public ARSCHeader(short type, int headerSize, int chunkSize, int headerStart) {
        this.type = type;
        this.headerSize = headerSize;
        this.chunkSize = chunkSize;
        this.startPosition = headerStart;
        this.endPosition = headerStart + chunkSize;
    }

    public static ARSCHeader read(ExtDataInput in, CountingInputStream countIn) throws IOException {
        short type;
        int start = countIn.getCount();
        try {
            type = in.readShort();
        }
        catch (EOFException ex) {
            return new ARSCHeader(-1, 0, 0, countIn.getCount());
        }
        return new ARSCHeader(type, in.readShort(), in.readInt(), start);
    }

    public void skipChunk(ExtDataInput in) throws IOException {
        in.skipBytes(this.chunkSize - this.headerSize);
    }
}

