/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.function.IOBaseStream;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOStreamAdapter;
import org.apache.commons.io.function.IOStreams;

public interface IOStream<T>
extends IOBaseStream<T, IOStream<T>, Stream<T>> {
    public static <T> IOStream<T> adapt(Stream<T> stream) {
        return IOStreamAdapter.adapt(stream);
    }

    public static <T> IOStream<T> empty() {
        return IOStreamAdapter.adapt(Stream.empty());
    }

    default public void forAll(IOConsumer<T> action, BiFunction<Integer, IOException, IOException> exSupplier) throws IOExceptionList {
        AtomicReference causeList = new AtomicReference();
        AtomicInteger index = new AtomicInteger();
        IOConsumer safeAction = IOStreams.toIOConsumer(action);
        ((Stream)this.unwrap()).forEach(e -> {
            block3: {
                try {
                    safeAction.accept(e);
                }
                catch (IOException innerEx) {
                    if (causeList.get() == null) {
                        causeList.set(new ArrayList());
                    }
                    if (exSupplier == null) break block3;
                    ((List)causeList.get()).add(exSupplier.apply(index.get(), innerEx));
                }
            }
            index.incrementAndGet();
        });
        IOExceptionList.checkEmpty((List)causeList.get(), null);
    }
}

