/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.chunk;

import cn.wjdiankong.chunk.Chunk;
import cn.wjdiankong.main.Utils;

public class EndTagChunk
implements Chunk {
    public byte[] type = new byte[4];
    public byte[] size = new byte[4];
    public byte[] lineNumber = new byte[4];
    public byte[] unknown = new byte[4];
    public byte[] uri = new byte[4];
    public byte[] name = new byte[4];
    public int offset;
    public String tagValue;

    public EndTagChunk() {
        this.type = Utils.int2Byte(0x100103);
        this.size = Utils.int2Byte(24);
        this.lineNumber = new byte[4];
        this.unknown = new byte[4];
        this.uri = Utils.int2Byte(-1);
    }

    public static EndTagChunk createChunk(int name) {
        EndTagChunk chunk = new EndTagChunk();
        chunk.name = Utils.int2Byte(name);
        return chunk;
    }

    @Override
    public byte[] getChunkByte() {
        byte[] bytes = new byte[this.getLen()];
        bytes = Utils.byteConcat(bytes, this.type, 0);
        bytes = Utils.byteConcat(bytes, this.size, 4);
        bytes = Utils.byteConcat(bytes, this.lineNumber, 8);
        bytes = Utils.byteConcat(bytes, this.unknown, 12);
        bytes = Utils.byteConcat(bytes, this.uri, 16);
        bytes = Utils.byteConcat(bytes, this.name, 20);
        return bytes;
    }

    public int getLen() {
        return this.type.length + this.size.length + this.lineNumber.length + this.unknown.length + this.uri.length + this.name.length;
    }

    public static EndTagChunk createChunk(byte[] byteSrc, int offset) {
        EndTagChunk chunk = new EndTagChunk();
        chunk.offset = offset;
        chunk.type = Utils.copyByte(byteSrc, 0, 4);
        chunk.size = Utils.copyByte(byteSrc, 4, 4);
        chunk.lineNumber = Utils.copyByte(byteSrc, 8, 4);
        chunk.unknown = Utils.copyByte(byteSrc, 12, 4);
        chunk.uri = Utils.copyByte(byteSrc, 16, 4);
        chunk.name = Utils.copyByte(byteSrc, 20, 4);
        return chunk;
    }
}

