/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.chunk;

import cn.wjdiankong.chunk.AttributeData;
import cn.wjdiankong.chunk.Chunk;
import cn.wjdiankong.main.Utils;
import java.util.ArrayList;

public class StartTagChunk
implements Chunk {
    public byte[] type = Utils.int2Byte(0x100102);
    public byte[] size;
    public byte[] lineNumber = new byte[4];
    public byte[] unknown = new byte[4];
    public byte[] uri;
    public byte[] name;
    public byte[] flag = new byte[4];
    public byte[] attCount;
    public byte[] classAttr = new byte[4];
    public byte[] attribute;
    public ArrayList<AttributeData> attrList;
    public int offset;

    public StartTagChunk() {
        int flatInt = 0;
        this.flag = Utils.int2Byte(flatInt |= 0x140014);
    }

    @Override
    public byte[] getChunkByte() {
        byte[] bytes = new byte[this.getLen()];
        bytes = Utils.byteConcat(bytes, this.type, 0);
        bytes = Utils.byteConcat(bytes, this.size, 4);
        bytes = Utils.byteConcat(bytes, this.lineNumber, 8);
        bytes = Utils.byteConcat(bytes, this.unknown, 12);
        bytes = Utils.byteConcat(bytes, this.uri, 16);
        bytes = Utils.byteConcat(bytes, this.name, 20);
        bytes = Utils.byteConcat(bytes, this.flag, 24);
        bytes = Utils.byteConcat(bytes, this.attCount, 28);
        bytes = Utils.byteConcat(bytes, this.classAttr, 32);
        bytes = Utils.byteConcat(bytes, this.attribute, 36);
        return bytes;
    }

    public int getLen() {
        return this.type.length + this.size.length + this.lineNumber.length + this.unknown.length + this.uri.length + this.name.length + this.flag.length + this.attCount.length + this.classAttr.length + this.attribute.length;
    }

    public static StartTagChunk createChunk(int name, int attCount, int uri, byte[] attribute) {
        StartTagChunk chunk = new StartTagChunk();
        chunk.size = new byte[4];
        chunk.name = Utils.int2Byte(name);
        chunk.uri = Utils.int2Byte(uri);
        chunk.attCount = Utils.int2Byte(attCount);
        chunk.attribute = attribute;
        chunk.size = Utils.int2Byte(chunk.getLen());
        return chunk;
    }

    public static StartTagChunk createChunk(byte[] byteSrc, int offset) {
        StartTagChunk chunk = new StartTagChunk();
        chunk.offset = offset;
        chunk.type = Utils.copyByte(byteSrc, 0, 4);
        chunk.size = Utils.copyByte(byteSrc, 4, 4);
        chunk.lineNumber = Utils.copyByte(byteSrc, 8, 4);
        chunk.unknown = Utils.copyByte(byteSrc, 12, 4);
        chunk.uri = Utils.copyByte(byteSrc, 16, 4);
        chunk.name = Utils.copyByte(byteSrc, 20, 4);
        chunk.flag = Utils.copyByte(byteSrc, 24, 4);
        chunk.attCount = Utils.copyByte(byteSrc, 28, 4);
        int attrCount = Utils.byte2int(chunk.attCount);
        chunk.classAttr = Utils.copyByte(byteSrc, 32, 4);
        chunk.attribute = Utils.copyByte(byteSrc, 36, attrCount * 20);
        chunk.attrList = new ArrayList(attrCount);
        int i = 0;
        while (i < attrCount) {
            Integer[] values = new Integer[5];
            AttributeData attrData = new AttributeData();
            int j = 0;
            while (j < 5) {
                int value = Utils.byte2int(Utils.copyByte(byteSrc, 36 + i * 20 + j * 4, 4));
                attrData.offset = offset + 36 + i * 20;
                switch (j) {
                    case 0: {
                        attrData.nameSpaceUri = value;
                        break;
                    }
                    case 1: {
                        attrData.name = value;
                        break;
                    }
                    case 2: {
                        attrData.valueString = value;
                        break;
                    }
                    case 3: {
                        attrData.type = value >>= 24;
                        break;
                    }
                    case 4: {
                        attrData.data = value;
                    }
                }
                values[j] = value;
                ++j;
            }
            chunk.attrList.add(attrData);
            ++i;
        }
        return chunk;
    }
}

