/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.main;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class Utils {
    public static byte[] byteConcat(byte[] src, byte[] subB, int start) {
        int i = 0;
        while (i < subB.length) {
            src[i + start] = subB[i];
            ++i;
        }
        return src;
    }

    public static int byte2int(byte[] res) {
        int targets = res[0] & 0xFF | res[1] << 8 & 0xFF00 | res[2] << 24 >>> 8 | res[3] << 24;
        return targets;
    }

    public static byte[] int2Byte(int value) {
        byte[] src = new byte[4];
        src[3] = (byte)(value >> 24 & 0xFF);
        src[2] = (byte)(value >> 16 & 0xFF);
        src[1] = (byte)(value >> 8 & 0xFF);
        src[0] = (byte)(value & 0xFF);
        return src;
    }

    public static byte[] shortToByte(short number) {
        int temp = number;
        byte[] b = new byte[2];
        int i = 0;
        while (i < b.length) {
            b[i] = new Integer(temp & 0xFF).byteValue();
            temp >>= 8;
            ++i;
        }
        return b;
    }

    public static short byte2Short(byte[] b) {
        short s = 0;
        short s0 = (short)(b[0] & 0xFF);
        short s1 = (short)(b[1] & 0xFF);
        s1 = (short)(s1 << 8);
        s = (short)(s0 | s1);
        return s;
    }

    public static String bytesToHexString(byte[] src1) {
        byte[] src = Utils.reverseBytes(src1);
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(String.valueOf(hv) + " ");
            ++i;
        }
        return stringBuilder.toString();
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static byte[] addByte(byte[] src, byte[] add) {
        if (src == null) {
            return null;
        }
        if (add == null) {
            return src;
        }
        byte[] newsrc = new byte[src.length + add.length];
        int i = 0;
        while (i < src.length) {
            newsrc[i] = src[i];
            ++i;
        }
        i = src.length;
        while (i < newsrc.length) {
            newsrc[i] = add[i - src.length];
            ++i;
        }
        return newsrc;
    }

    public static byte[] insertByte(byte[] src, int start, byte[] insertB) {
        if (src == null) {
            return null;
        }
        if (start > src.length) {
            return null;
        }
        byte[] newB = new byte[src.length + insertB.length];
        int i = 0;
        while (i < start) {
            newB[i] = src[i];
            ++i;
        }
        i = 0;
        while (i < insertB.length) {
            newB[i + start] = insertB[i];
            ++i;
        }
        i = start;
        while (i < src.length) {
            newB[i + insertB.length] = src[i];
            ++i;
        }
        return newB;
    }

    public static byte[] removeByte(byte[] src, int start, int len) {
        if (src == null) {
            return null;
        }
        if (start > src.length) {
            return null;
        }
        if (start + len > src.length) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        byte[] dest = new byte[src.length - len];
        int i = 0;
        while (i <= start) {
            dest[i] = src[i];
            ++i;
        }
        int k = 0;
        int i2 = start + len;
        while (i2 < src.length) {
            dest[start + k] = src[i2];
            ++k;
            ++i2;
        }
        return dest;
    }

    public static byte[] copyByte(byte[] src, int start, int len) {
        if (src == null) {
            return null;
        }
        if (start > src.length) {
            return null;
        }
        if (start + len > src.length) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (len <= 0) {
            return null;
        }
        byte[] resultByte = new byte[len];
        int i = 0;
        while (i < len) {
            resultByte[i] = src[i + start];
            ++i;
        }
        return resultByte;
    }

    public static byte[] replaceBytes(byte[] src, byte[] bytes, int start) {
        if (src == null) {
            return null;
        }
        if (bytes == null) {
            return src;
        }
        if (start > src.length) {
            return src;
        }
        if (start + bytes.length > src.length) {
            return src;
        }
        byte[] replaceB = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            replaceB[i] = src[i + start];
            src[i + start] = bytes[i];
            ++i;
        }
        return src;
    }

    public static byte[] reverseBytes(byte[] bytess) {
        byte[] bytes = new byte[bytess.length];
        int i = 0;
        while (i < bytess.length) {
            bytes[i] = bytess[i];
            ++i;
        }
        if (bytes == null || bytes.length % 2 != 0) {
            return bytes;
        }
        i = 0;
        int len = bytes.length;
        while (i < len / 2) {
            byte tmp = bytes[i];
            bytes[i] = bytes[len - i - 1];
            bytes[len - i - 1] = tmp;
            ++i;
        }
        return bytes;
    }

    public static String filterStringNull(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        byte[] strByte = str.getBytes();
        ArrayList<Byte> newByte = new ArrayList<Byte>();
        int i = 0;
        while (i < strByte.length) {
            if (strByte[i] != 0) {
                newByte.add(strByte[i]);
            }
            ++i;
        }
        byte[] newByteAry = new byte[newByte.size()];
        int i2 = 0;
        while (i2 < newByteAry.length) {
            newByteAry[i2] = (Byte)newByte.get(i2);
            ++i2;
        }
        return new String(newByteAry);
    }

    public static String getStringFromByteAry(byte[] srcByte, int start) {
        if (srcByte == null) {
            return "";
        }
        if (start < 0) {
            return "";
        }
        if (start >= srcByte.length) {
            return "";
        }
        byte val = srcByte[start];
        int i = 1;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (val != 0) {
            byteList.add(srcByte[start + i]);
            val = srcByte[start + i];
            ++i;
        }
        byte[] valAry = new byte[byteList.size()];
        int j = 0;
        while (j < byteList.size()) {
            valAry[j] = (Byte)byteList.get(j);
            ++j;
        }
        try {
            return new String(valAry, "UTF-8");
        }
        catch (Exception e) {
            System.out.println("encode error:" + e.toString());
            return "";
        }
    }
}

