/*
 * Decompiled with CFR 0.152.
 */
package cn.wjdiankong.main;

import cn.wjdiankong.chunk.AttributeData;
import cn.wjdiankong.chunk.EndTagChunk;
import cn.wjdiankong.chunk.StartTagChunk;
import cn.wjdiankong.chunk.StringChunk;
import cn.wjdiankong.chunk.TagChunk;
import cn.wjdiankong.main.ParserChunkUtils;
import cn.wjdiankong.main.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlEditor {
    public static int tagStartChunkOffset = 0;
    public static int tagEndChunkOffset;
    public static int subAppTagChunkOffset;
    public static int subTagChunkOffsets;
    public static String[] isNotAppTag;
    public static String prefixStr;

    static {
        subAppTagChunkOffset = 0;
        subTagChunkOffsets = 0;
        isNotAppTag = new String[]{"uses-permission", "uses-sdk", "compatible-screens", "instrumentation", "library", "original-package", "package-verifier", "permission", "permission-group", "permission-tree", "protected-broadcast", "resource-overlay", "supports-input", "supports-screens", "upgrade-key-set", "uses-configuration", "uses-feature"};
        prefixStr = "http://schemas.android.com/apk/res/android";
    }

    public static void removeTag(String tagName, String name) {
        ParserChunkUtils.parserXml();
        for (TagChunk tag : ParserChunkUtils.xmlStruct.tagChunkList) {
            int tagNameIndex = Utils.byte2int(tag.startTagChunk.name);
            String tagNameTmp = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(tagNameIndex);
            if (!tagName.equals(tagNameTmp)) continue;
            for (AttributeData attrData : tag.startTagChunk.attrList) {
                String value;
                String attrName = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(attrData.name);
                if (!"name".equals(attrName) || !name.equals(value = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(attrData.valueString))) continue;
                int size = Utils.byte2int(tag.endTagChunk.size);
                int delStart = tag.startTagChunk.offset;
                int delSize = tag.endTagChunk.offset - tag.startTagChunk.offset + size;
                ParserChunkUtils.xmlStruct.byteSrc = Utils.removeByte(ParserChunkUtils.xmlStruct.byteSrc, delStart, delSize);
                XmlEditor.modifyFileSize();
                return;
            }
        }
    }

    public static void addTag(String insertXml) {
        ParserChunkUtils.parserXml();
        try {
            XmlPullParserFactory pullParserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser pullParser = pullParserFactory.newPullParser();
            pullParser.setInput(new FileInputStream(insertXml), "UTF-8");
            int event = pullParser.getEventType();
            while (event != 1) {
                switch (event) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        String tagName = pullParser.getName();
                        int name = XmlEditor.getStrIndex(tagName);
                        int attCount = pullParser.getAttributeCount();
                        byte[] attribute = new byte[20 * attCount];
                        int i = 0;
                        while (i < pullParser.getAttributeCount()) {
                            int attruri = XmlEditor.getStrIndex(prefixStr);
                            String attrName = pullParser.getAttributeName(i);
                            String[] strAry = attrName.split(":");
                            int[] type = XmlEditor.getAttrType(pullParser.getAttributeValue(i));
                            int attrname = XmlEditor.getStrIndex(strAry[1]);
                            int attrvalue = XmlEditor.getStrIndex(pullParser.getAttributeValue(i));
                            int attrtype = type[0];
                            int attrdata = type[1];
                            AttributeData data = AttributeData.createAttribute(attruri, attrname, attrvalue, attrtype, attrdata);
                            attribute = Utils.byteConcat(attribute, data.getByte(), data.getLen() * i);
                            ++i;
                        }
                        StartTagChunk startChunk = StartTagChunk.createChunk(name, attCount, -1, attribute);
                        if (XmlEditor.isNotAppTag(tagName)) {
                            ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, subTagChunkOffsets, startChunk.getChunkByte());
                            subTagChunkOffsets += startChunk.getChunkByte().length;
                            break;
                        }
                        ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, subAppTagChunkOffset, startChunk.getChunkByte());
                        subAppTagChunkOffset += startChunk.getChunkByte().length;
                        break;
                    }
                    case 3: {
                        String tagName = pullParser.getName();
                        int name = XmlEditor.getStrIndex(tagName);
                        EndTagChunk endChunk = EndTagChunk.createChunk(name);
                        if (XmlEditor.isNotAppTag(tagName)) {
                            ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, subTagChunkOffsets, endChunk.getChunkByte());
                            subTagChunkOffsets += endChunk.getChunkByte().length;
                            break;
                        }
                        ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, subAppTagChunkOffset, endChunk.getChunkByte());
                        subAppTagChunkOffset += endChunk.getChunkByte().length;
                    }
                }
                event = pullParser.next();
            }
        }
        catch (XmlPullParserException e) {
            System.out.println("parse xml err:" + e.toString());
        }
        catch (IOException e) {
            System.out.println("parse xml err:" + e.toString());
        }
        XmlEditor.modifStringChunk();
        XmlEditor.modifyFileSize();
    }

    public static void removeAttr(String tag, String tagName, String attrName) {
        ParserChunkUtils.parserXml();
        for (StartTagChunk chunk : ParserChunkUtils.xmlStruct.startTagChunkList) {
            int tagNameIndex = Utils.byte2int(chunk.name);
            String tagNameTmp = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(tagNameIndex);
            if (!tag.equals(tagNameTmp)) continue;
            if (tag.equals("application") || tag.equals("manifest")) {
                for (AttributeData data : chunk.attrList) {
                    String attrNameTemp1 = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(data.name);
                    if (!attrName.equals(attrNameTemp1)) continue;
                    if (chunk.attrList.size() == 1) {
                        XmlEditor.removeTag(tag, tagName);
                        return;
                    }
                    int countStart = chunk.offset + 28;
                    byte[] modifyByte = Utils.int2Byte(chunk.attrList.size() - 1);
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByte, countStart);
                    int chunkSizeStart = chunk.offset + 4;
                    int chunkSize = Utils.byte2int(chunk.size);
                    byte[] modifyByteSize = Utils.int2Byte(chunkSize - 20);
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByteSize, chunkSizeStart);
                    int delStart = data.offset;
                    int delSize = data.getLen();
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.removeByte(ParserChunkUtils.xmlStruct.byteSrc, delStart, delSize);
                    XmlEditor.modifyFileSize();
                    return;
                }
            }
            for (AttributeData attrData : chunk.attrList) {
                String value;
                String attrNameTemp = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(attrData.name);
                if (!"name".equals(attrNameTemp) || !tagName.equals(value = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(attrData.valueString))) continue;
                for (AttributeData data : chunk.attrList) {
                    String attrNameTemp1 = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(data.name);
                    if (!attrName.equals(attrNameTemp1)) continue;
                    if (chunk.attrList.size() == 1) {
                        XmlEditor.removeTag(tag, tagName);
                        return;
                    }
                    int countStart = chunk.offset + 28;
                    byte[] modifyByte = Utils.int2Byte(chunk.attrList.size() - 1);
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByte, countStart);
                    int chunkSizeStart = chunk.offset + 4;
                    int chunkSize = Utils.byte2int(chunk.size);
                    byte[] modifyByteSize = Utils.int2Byte(chunkSize - 20);
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByteSize, chunkSizeStart);
                    int delStart = data.offset;
                    int delSize = data.getLen();
                    ParserChunkUtils.xmlStruct.byteSrc = Utils.removeByte(ParserChunkUtils.xmlStruct.byteSrc, delStart, delSize);
                    XmlEditor.modifyFileSize();
                    return;
                }
            }
        }
    }

    public static void modifyAttr(String tag, String tagName, String attrName, String attrValue) {
        ParserChunkUtils.parserXml();
        XmlEditor.removeAttr(tag, tagName, attrName);
        ParserChunkUtils.parserXml();
        XmlEditor.addAttr(tag, tagName, attrName, attrValue);
    }

    public static void addAttr(String tag, String tagName, String attrName, String attrValue) {
        ParserChunkUtils.parserXml();
        int[] type = XmlEditor.getAttrType(attrValue);
        int attrname = XmlEditor.getStrIndex(attrName);
        int attrvalue = XmlEditor.getStrIndex(attrValue);
        int attruri = XmlEditor.getStrIndex(prefixStr);
        int attrtype = type[0];
        int attrdata = type[1];
        AttributeData data = AttributeData.createAttribute(attruri, attrname, attrvalue, attrtype, attrdata);
        for (StartTagChunk chunk : ParserChunkUtils.xmlStruct.startTagChunkList) {
            int tagNameIndex = Utils.byte2int(chunk.name);
            String tagNameTmp = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(tagNameIndex);
            if (!tag.equals(tagNameTmp)) continue;
            if (tag.equals("application") || tag.equals("manifest")) {
                int countStart = chunk.offset + 28;
                byte[] modifyByte = Utils.int2Byte(chunk.attrList.size() + 1);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByte, countStart);
                int chunkSizeStart = chunk.offset + 4;
                int chunkSize = Utils.byte2int(chunk.size);
                byte[] modifyByteSize = Utils.int2Byte(chunkSize + 20);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByteSize, chunkSizeStart);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, chunk.offset + chunkSize, data.getByte());
                XmlEditor.modifStringChunk();
                XmlEditor.modifyFileSize();
                return;
            }
            for (AttributeData attrData : chunk.attrList) {
                String attrNameTemp = ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(attrData.name);
                if (!"name".equals(attrNameTemp)) continue;
                int countStart = chunk.offset + 28;
                byte[] modifyByte = Utils.int2Byte(chunk.attrList.size() + 1);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByte, countStart);
                int chunkSizeStart = chunk.offset + 4;
                int chunkSize = Utils.byte2int(chunk.size);
                byte[] modifyByteSize = Utils.int2Byte(chunkSize + 20);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, modifyByteSize, chunkSizeStart);
                ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, chunk.offset + chunkSize, data.getByte());
                XmlEditor.modifStringChunk();
                XmlEditor.modifyFileSize();
                return;
            }
        }
    }

    private static void modifStringChunk() {
        StringChunk strChunk = ParserChunkUtils.xmlStruct.stringChunk;
        byte[] newStrChunkB = strChunk.getByte(ParserChunkUtils.xmlStruct.stringChunk.stringContentList);
        ParserChunkUtils.xmlStruct.byteSrc = Utils.removeByte(ParserChunkUtils.xmlStruct.byteSrc, ParserChunkUtils.stringChunkOffset, Utils.byte2int(strChunk.size));
        ParserChunkUtils.xmlStruct.byteSrc = Utils.insertByte(ParserChunkUtils.xmlStruct.byteSrc, ParserChunkUtils.stringChunkOffset, newStrChunkB);
    }

    public static void modifyFileSize() {
        byte[] newFileSize = Utils.int2Byte(ParserChunkUtils.xmlStruct.byteSrc.length);
        ParserChunkUtils.xmlStruct.byteSrc = Utils.replaceBytes(ParserChunkUtils.xmlStruct.byteSrc, newFileSize, 4);
    }

    public static int getStrIndex(String str) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        int i = 0;
        while (i < ParserChunkUtils.xmlStruct.stringChunk.stringContentList.size()) {
            if (ParserChunkUtils.xmlStruct.stringChunk.stringContentList.get(i).equals(str)) {
                return i;
            }
            ++i;
        }
        ParserChunkUtils.xmlStruct.stringChunk.stringContentList.add(str);
        return ParserChunkUtils.xmlStruct.stringChunk.stringContentList.size() - 1;
    }

    public static boolean isNotAppTag(String tagName) {
        String[] stringArray = isNotAppTag;
        int n = isNotAppTag.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(tagName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int[] getAttrType(String tagValue) {
        int[] result = new int[2];
        if (tagValue.equals("true") || tagValue.equals("false")) {
            result[0] = result[0] | 0x12;
            result[1] = tagValue.equals("true") ? 1 : 0;
        } else if (tagValue.equals("singleTask") || tagValue.equals("standard") || tagValue.equals("singleTop") || tagValue.equals("singleInstance")) {
            result[0] = result[0] | 0x10;
            result[1] = tagValue.equals("standard") ? 0 : (tagValue.equals("singleTop") ? 1 : (tagValue.equals("singleTask") ? 2 : 3));
        } else if (tagValue.equals("minSdkVersion") || tagValue.equals("versionCode")) {
            result[0] = result[0] | 0x10;
            result[1] = Integer.valueOf(tagValue);
        } else if (tagValue.startsWith("@")) {
            result[0] = result[0] | 1;
            result[1] = 0x7F000000;
        } else if (tagValue.startsWith("#")) {
            result[0] = result[0] | 0x1E;
            result[1] = -1;
        } else {
            result[0] = result[0] | 3;
            result[1] = XmlEditor.getStrIndex(tagValue);
        }
        result[0] = result[0] | 0x8000000;
        result[0] = Utils.byte2int(Utils.reverseBytes(Utils.int2Byte(result[0])));
        return result;
    }
}

