/*
 * Decompiled with CFR 0.152.
 */
package bin.signer;

import bin.signer.key.BaseSignatureKey;
import bin.util.StreamUtil;
import bin.zip.ZipEntry;
import bin.zip.ZipFile;
import bin.zip.ZipOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class ApkSigner {
    private static final String CERT_RSA_NAME = "META-INF/CERT.RSA";
    private static final String CERT_SF_NAME = "META-INF/CERT.SF";
    private static Pattern stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");
    private static final ApkSignCallback SIGN_CALLBACK = new ApkSignCallback(){

        @Override
        public void onStep(Step step) {
        }

        @Override
        public void onProgress(int progress, int total) {
        }
    };

    private static Manifest addDigestsToManifest(ZipFile zipFile, ApkSignCallback callback) throws IOException, GeneralSecurityException {
        Manifest input = null;
        Manifest output = new Manifest();
        ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
        Attributes main = output.getMainAttributes();
        if (zipEntry != null) {
            input = new Manifest();
            input.read(zipFile.getInputStream(zipEntry));
            main.putAll((Map<?, ?>)input.getMainAttributes());
        } else {
            main.putValue("Manifest-Version", "1.0");
            main.putValue("Created-By", "1.0 (MT)");
        }
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] buffer = new byte[4096];
        TreeMap<String, ZipEntry> byName = new TreeMap<String, ZipEntry>();
        int total = 0;
        Enumeration<ZipEntry> e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
            ++total;
        }
        int progress = 0;
        for (ZipEntry entry : byName.values()) {
            String name = entry.getName();
            if (!(entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || name.equals(CERT_SF_NAME) || name.equals(CERT_RSA_NAME) || stripPattern != null && stripPattern.matcher(name).matches())) {
                int num;
                InputStream data = zipFile.getInputStream(entry);
                while ((num = data.read(buffer)) > 0) {
                    md.update(buffer, 0, num);
                }
                Attributes attr = null;
                if (input != null) {
                    attr = input.getAttributes(name);
                }
                attr = attr != null ? new Attributes(attr) : new Attributes();
                attr.putValue("SHA1-Digest", Base64.getEncoder().encodeToString(md.digest()));
                output.getEntries().put(name, attr);
            }
            callback.onProgress(++progress, total);
        }
        return output;
    }

    private static void copyFiles(Manifest manifest, ZipFile in, ZipOutputStream out, long timestamp, ApkSignCallback callback) throws IOException {
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        int progress = 0;
        int total = names.size();
        for (String name : names) {
            ZipEntry inEntry = in.getEntry(name);
            inEntry.setTime(timestamp);
            out.copyZipEntry(inEntry, in);
            callback.onProgress(++progress, total);
        }
    }

    private static KeySpec decryptPrivateKey(byte[] encryptedPrivateKey) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec("".toCharArray()));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        return epkInfo.getKeySpec(cipher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(InputStream input) throws IOException, GeneralSecurityException {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(input.available());
            byte[] bytes = new byte[1024];
            while ((len = input.read(bytes)) > 0) {
                baos.write(bytes, 0, len);
            }
            bytes = baos.toByteArray();
            baos.close();
            KeySpec spec = ApkSigner.decryptPrivateKey(bytes);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            try {
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
                return privateKey;
            }
            catch (InvalidKeySpecException ex) {
                PrivateKey privateKey = KeyFactory.getInstance("DSA").generatePrivate(spec);
                input.close();
                return privateKey;
            }
        }
        finally {
            input.close();
        }
    }

    private static X509Certificate readPublicKey(InputStream input) throws IOException, GeneralSecurityException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signApk(File input, File output, BaseSignatureKey key, ApkSignCallback callback) throws Exception {
        ZipFile inputJar = null;
        FileOutputStream outputFile = null;
        if (callback == null) {
            callback = SIGN_CALLBACK;
        }
        try {
            callback.onStep(Step.START);
            X509Certificate publicKey = ApkSigner.readPublicKey(key.getPublicKey());
            PrivateKey privateKey = ApkSigner.readPrivateKey(key.getPrivateKey());
            key.recycle();
            inputJar = new ZipFile(input);
            callback.onStep(Step.SIGN_FILE);
            Manifest manifest = ApkSigner.addDigestsToManifest(inputJar, callback);
            long timestamp = publicKey.getNotBefore().getTime() + 3600000L;
            outputFile = new FileOutputStream(output);
            ZipOutputStream outputJar = new ZipOutputStream(outputFile);
            outputJar.setZipEncoding(inputJar.getZipEncoding());
            outputJar.setMethod(8);
            outputJar.setLevel(9);
            ZipEntry je = new ZipEntry("META-INF/MANIFEST.MF");
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            manifest.write(outputJar);
            je = new ZipEntry(CERT_SF_NAME);
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey);
            ApkSigner.writeSignatureFile(manifest, new SignatureOutputStream(outputJar, signature));
            je = new ZipEntry(CERT_RSA_NAME);
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            ApkSigner.writeSignatureBlock(signature, publicKey, outputJar);
            callback.onStep(Step.OUTPUT);
            ApkSigner.copyFiles(manifest, inputJar, outputJar, timestamp, callback);
            outputJar.close();
            outputFile.flush();
            callback.onStep(Step.FINISH);
        }
        catch (Throwable throwable) {
            StreamUtil.close(inputJar);
            StreamUtil.close(outputFile);
            throw throwable;
        }
        StreamUtil.close(inputJar);
        StreamUtil.close(outputFile);
    }

    private static void writeSignatureBlock(Signature signature, X509Certificate publicKey, OutputStream out) throws IOException, GeneralSecurityException {
        SignerInfo signerInfo = new SignerInfo(new X500Name(publicKey.getIssuerX500Principal().getName()), publicKey.getSerialNumber(), AlgorithmId.get("SHA1"), AlgorithmId.get("RSA"), signature.sign());
        PKCS7 pkcs7 = new PKCS7(new AlgorithmId[]{AlgorithmId.get("SHA1")}, new ContentInfo(ContentInfo.DATA_OID, null), new X509Certificate[]{publicKey}, new SignerInfo[]{signerInfo});
        pkcs7.encodeSignedData(out);
    }

    private static void writeSignatureFile(Manifest manifest, SignatureOutputStream out) throws IOException, GeneralSecurityException {
        out.write("Signature-Version: 1.0\r\n".getBytes());
        out.write("Created-By: 1.0 (MT_Bin)\r\n".getBytes());
        MessageDigest md = MessageDigest.getInstance("SHA1");
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        manifest.write(print);
        print.flush();
        out.write(("SHA1-Digest-Manifest: " + Base64.getEncoder().encodeToString(md.digest()) + "\r\n\r\n").getBytes());
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            String nameEntry = "Name: " + entry.getKey() + "\r\n";
            print.print(nameEntry);
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            out.write(nameEntry.getBytes());
            out.write(("SHA1-Digest: " + Base64.getEncoder().encodeToString(md.digest()) + "\r\n\r\n").getBytes());
        }
        if (out.size() % 1024 == 0) {
            out.write(13);
            out.write(10);
        }
    }

    public static enum Step {
        START,
        SIGN_FILE,
        OUTPUT,
        FINISH;

    }

    public static interface ApkSignCallback {
        public void onStep(Step var1);

        public void onProgress(int var1, int var2);
    }

    private static class SignatureOutputStream
    extends OutputStream {
        private int mCount;
        private Signature mSignature;
        private OutputStream out;

        public SignatureOutputStream(OutputStream out, Signature sig) {
            this.out = out;
            this.mSignature = sig;
            this.mCount = 0;
        }

        public int size() {
            return this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.mSignature.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            this.out.write(b, off, len);
            this.mCount += len;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.mSignature.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            this.out.write(b);
            ++this.mCount;
        }
    }
}

