/*
 * Decompiled with CFR 0.152.
 */
package bin.util;

import bin.io.ZInput;
import bin.io.ZOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;

public class StringDecoder {
    private String[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private boolean m_isUTF8;
    private int styleOffsetCount;
    private int stylesOffset;
    private int flags;
    private int chunkSize;
    private int m_strings_size;
    private static final CharsetDecoder UTF16LE_DECODER = Charset.forName("UTF-16LE").newDecoder();
    private static final CharsetDecoder UTF8_DECODER = Charset.forName("UTF-8").newDecoder();
    private static final int CHUNK_STRINGPOOL_TYPE = 0x1C0001;
    private static final int CHUNK_NULL_TYPE = 0;
    public static final int IS_UTF8 = 256;

    public boolean isUtf8() {
        return this.m_isUTF8;
    }

    public static StringDecoder read(ZInput mIn) throws IOException {
        mIn.skipCheckChunkTypeInt(0x1C0001, 0);
        StringDecoder block = new StringDecoder();
        int chunkSize = block.chunkSize = mIn.readInt();
        int stringCount = mIn.readInt();
        int styleCount = block.styleOffsetCount = mIn.readInt();
        int flags = block.flags = mIn.readInt();
        int stringsOffset = mIn.readInt();
        int stylesOffset = block.stylesOffset = mIn.readInt();
        block.m_isUTF8 = (flags & 0x100) != 0;
        int[] m_stringOffsets = mIn.readIntArray(stringCount);
        if (styleCount != 0) {
            block.m_styleOffsets = mIn.readIntArray(styleCount);
        }
        int size = (stylesOffset == 0 ? chunkSize : stylesOffset) - stringsOffset;
        byte[] data = new byte[size];
        mIn.readFully(data);
        block.m_strings_size = size;
        if (stylesOffset != 0) {
            size = chunkSize - stylesOffset;
            block.m_styles = mIn.readIntArray(size / 4);
            int remaining = size % 4;
            if (remaining >= 1) {
                while (remaining-- > 0) {
                    mIn.readByte();
                }
            }
        }
        int i = 0;
        block.m_strings = new String[m_stringOffsets.length];
        for (int offset : m_stringOffsets) {
            int length;
            if (!block.m_isUTF8) {
                length = StringDecoder.getShort(data, offset) * 2;
                offset += 2;
            } else {
                offset += StringDecoder.getVarint(data, offset)[1];
                int[] varint = StringDecoder.getVarint(data, offset);
                offset += varint[1];
                length = varint[0];
            }
            block.m_strings[i++] = StringDecoder.decodeString(offset, length, block.m_isUTF8, data);
        }
        data = null;
        return block;
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.m_strings.length; ++i) {
            if (!this.getString(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void getStrings(List<String> list) {
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            list.add(this.getString(i));
        }
    }

    public void write(ZOutput out) throws IOException {
        this.write(this.m_strings, out);
    }

    public void write(String[] s, ZOutput out) throws IOException {
        int m_strings_size;
        int size_mod;
        char[] charBuf;
        String var;
        int i;
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        ZOutput led = new ZOutput(outBuf);
        int size = s.length;
        int[] offset = new int[size];
        int len = 0;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ZOutput mStrings = new ZOutput(bOut);
        if (this.m_isUTF8) {
            for (i = 0; i < size; ++i) {
                offset[i] = len;
                var = s[i];
                charBuf = var.toCharArray();
                byte[] byArray = StringDecoder.getVarBytes(charBuf.length);
                mStrings.writeFully(byArray);
                len += byArray.length;
                byte[] buf = var.getBytes("UTF-8");
                byte[] byArray2 = StringDecoder.getVarBytes(buf.length);
                mStrings.writeFully(byArray2);
                len += byArray2.length;
                mStrings.writeFully(buf);
                len += buf.length;
                mStrings.writeByte(0);
                ++len;
            }
        } else {
            for (i = 0; i < size; ++i) {
                offset[i] = len;
                var = s[i];
                charBuf = var.toCharArray();
                mStrings.writeShort((short)charBuf.length);
                for (char c : charBuf) {
                    mStrings.writeChar(c);
                }
                mStrings.writeShort((short)0);
                len += charBuf.length * 2 + 4;
            }
        }
        if ((size_mod = (m_strings_size = bOut.size()) % 4) != 0) {
            for (int i2 = 0; i2 < 4 - size_mod; ++i2) {
                bOut.write(0);
            }
            m_strings_size += 4 - size_mod;
        }
        byte[] m_strings = bOut.toByteArray();
        led.writeInt(size);
        led.writeInt(this.styleOffsetCount);
        led.writeInt(this.flags);
        int n = 28 + (size + this.styleOffsetCount) * 4;
        led.writeInt(n);
        int i3 = m_strings_size - this.m_strings_size;
        led.writeInt(this.stylesOffset == 0 ? 0 : this.stylesOffset + i3 * 4);
        led.writeIntArray(offset);
        if (this.styleOffsetCount != 0) {
            for (int j : this.m_styleOffsets) {
                led.writeInt(j);
            }
        }
        led.writeFully(m_strings);
        if (this.m_styles != null) {
            led.writeIntArray(this.m_styles);
        }
        out.writeInt(0x1C0001);
        byte[] b = outBuf.toByteArray();
        outBuf.close();
        led.close();
        out.writeInt(b.length + 8);
        out.writeFully(b);
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setString(int index, String s) {
        this.m_strings[index] = s;
    }

    public String getString(int index) {
        if (index >= 0) {
            return this.m_strings[index];
        }
        return null;
    }

    private static int[] getVarint(byte[] array, int offset) {
        if ((array[offset] & 0x80) == 0) {
            return new int[]{array[offset] & 0x7F, 1};
        }
        return new int[]{(array[offset] & 0x7F) << 8 | array[offset + 1] & 0xFF, 2};
    }

    protected static byte[] getVarBytes(int val) {
        if ((val & 0x7F) == val) {
            return new byte[]{(byte)val};
        }
        byte[] b = new byte[]{(byte)(val >>> 8 | 0x80), (byte)(val & 0xFF)};
        return b;
    }

    public int getSize() {
        return this.m_strings.length;
    }

    private static String decodeString(int offset, int length, boolean utf8, byte[] data) {
        try {
            return (utf8 ? UTF8_DECODER : UTF16LE_DECODER).decode(ByteBuffer.wrap(data, offset, length)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    private static int getShort(byte[] array, int offset) {
        return (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }
}

