/*
 * Decompiled with CFR 0.152.
 */
package bin.xml.decode;

import bin.io.ZInput;
import bin.util.StringDecoder;
import bin.xml.decode.XmlPullParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class AXmlResourceParser
implements XmlPullParser {
    public int currentAttributeStart;
    private ZInput m_reader;
    private boolean m_operational = false;
    private StringDecoder m_strings;
    private int[] m_resourceIDs;
    private NamespaceStack m_namespaces = new NamespaceStack();
    private boolean m_decreaseDepth;
    private int m_event;
    private int m_lineNumber;
    private int m_name;
    private int m_namespaceUri;
    private int[] m_attributes;
    private int m_idAttribute;
    private int m_classAttribute;
    private int m_styleAttribute;
    private static final String E_NOT_SUPPORTED = "Method is not supported.";
    private static final int ATTRIBUTE_IX_NAMESPACE_URI = 0;
    private static final int ATTRIBUTE_IX_NAME = 1;
    private static final int ATTRIBUTE_IX_VALUE_STRING = 2;
    private static final int ATTRIBUTE_IX_VALUE_TYPE = 3;
    private static final int ATTRIBUTE_IX_VALUE_DATA = 4;
    private static final int ATTRIBUTE_LENGHT = 5;
    private static final int CHUNK_AXML_FILE = 524291;
    private static final int CHUNK_RESOURCEIDS = 524672;
    private static final int CHUNK_XML_FIRST = 0x100100;
    private static final int CHUNK_XML_START_NAMESPACE = 0x100100;
    private static final int CHUNK_XML_END_NAMESPACE = 0x100101;
    private static final int CHUNK_XML_START_TAG = 0x100102;
    private static final int CHUNK_XML_END_TAG = 0x100103;
    private static final int CHUNK_XML_TEXT = 0x100104;
    private static final int CHUNK_XML_LAST = 0x100104;

    public AXmlResourceParser() {
        this.resetEventInfo();
    }

    public void open(InputStream stream) throws IOException {
        this.close();
        if (stream != null) {
            this.m_reader = new ZInput(stream);
        }
    }

    public void open(InputStream stream, StringDecoder strings) throws IOException {
        this.close();
        this.m_reader = new ZInput(stream);
        this.m_strings = strings;
        this.m_namespaces.increaseDepth();
        this.m_operational = true;
    }

    public void close() {
        if (!this.m_operational) {
            return;
        }
        this.m_operational = false;
        try {
            this.m_reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_reader = null;
        this.m_strings = null;
        this.m_resourceIDs = null;
        this.m_namespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws IOException {
        if (this.m_reader == null) {
            throw new IOException("Parser is not opened.");
        }
        try {
            this.doNext();
            return this.m_event;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public int nextToken() throws IOException {
        return this.next();
    }

    private static void readCheckType(ZInput reader, int expectedType) throws IOException {
        int type = reader.readInt();
        if (type != expectedType) {
            throw new IOException("Expected chunk of type 0x" + Integer.toHexString(expectedType) + ", read 0x" + Integer.toHexString(type) + ".");
        }
    }

    public int nextTag() throws IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new IOException("Expected start or end tag.");
        }
        return eventType;
    }

    public String nextText() throws IOException {
        if (this.getEventType() != 2) {
            throw new IOException("Parser must be on START_TAG to read next text.");
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new IOException("Event TEXT must be immediately followed by END_TAG.");
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new IOException("Parser must be on START_TAG or TEXT to read text.");
    }

    public void require(int type, String namespace, String name) throws IOException {
        if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new IOException(TYPES[type] + " is expected.");
        }
    }

    public int getDepth() {
        return this.m_namespaces.getDepth() - 1;
    }

    public int getEventType() throws IOException {
        return this.m_event;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getName() {
        if (this.m_name == -1 || this.m_event != 2 && this.m_event != 3) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    public String getText() {
        if (this.m_name == -1 || this.m_event != 4) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = text.length();
        char[] chars = new char[text.length()];
        text.getChars(0, text.length(), chars, 0);
        return chars;
    }

    public String getNamespace() {
        return this.m_strings.getString(this.m_namespaceUri);
    }

    public String getPrefix() {
        int prefix = this.m_namespaces.findPrefix(this.m_namespaceUri);
        return this.m_strings.getString(prefix);
    }

    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    public int getNamespaceCount(int depth) throws IOException {
        return this.m_namespaces.getAccumulatedCount(depth);
    }

    public String getNamespacePrefix(int pos) throws IOException {
        int prefix = this.m_namespaces.getPrefix(pos);
        return this.m_strings.getString(prefix);
    }

    public String getNamespaceUri(int pos) throws IOException {
        int uri = this.m_namespaces.getUri(pos);
        return this.m_strings.getString(uri);
    }

    public String getClassAttribute() {
        if (this.m_classAttribute == -1) {
            return null;
        }
        int offset = this.getAttributeOffset(this.m_classAttribute);
        int value = this.m_attributes[offset + 2];
        return this.m_strings.getString(value);
    }

    public String getIdAttribute() {
        if (this.m_idAttribute == -1) {
            return null;
        }
        int offset = this.getAttributeOffset(this.m_idAttribute);
        int value = this.m_attributes[offset + 2];
        return this.m_strings.getString(value);
    }

    public int getIdAttributeResourceValue(int defaultValue) {
        if (this.m_idAttribute == -1) {
            return defaultValue;
        }
        int offset = this.getAttributeOffset(this.m_idAttribute);
        int valueType = this.m_attributes[offset + 3];
        if (valueType != 1) {
            return defaultValue;
        }
        return this.m_attributes[offset + 4];
    }

    public int getStyleAttribute() {
        if (this.m_styleAttribute == -1) {
            return 0;
        }
        int offset = this.getAttributeOffset(this.m_styleAttribute);
        return this.m_attributes[offset + 4];
    }

    public int getAttributeCount() {
        if (this.m_event != 2) {
            return -1;
        }
        return this.m_attributes.length / 5;
    }

    public String getAttributeNamespace(int index) {
        int offset = this.getAttributeOffset(index);
        int namespace = this.m_attributes[offset + 0];
        if (namespace == -1) {
            return "";
        }
        return this.m_strings.getString(namespace);
    }

    public String getAttributePrefix(int index) {
        int offset = this.getAttributeOffset(index);
        int uri = this.m_attributes[offset + 0];
        int prefix = this.m_namespaces.findPrefix(uri);
        if (prefix == -1) {
            return "";
        }
        return this.m_strings.getString(prefix);
    }

    public String getAttributeName(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.m_attributes[offset + 1];
        if (name == -1) {
            return "";
        }
        return this.m_strings.getString(name);
    }

    public String getString(int index) {
        return this.m_strings.getString(index);
    }

    public int getAttributeNameResource(int index) {
        int offset = this.getAttributeOffset(index);
        int name = this.m_attributes[offset + 1];
        if (this.m_resourceIDs == null || name < 0 || name >= this.m_resourceIDs.length) {
            return 0;
        }
        return this.m_resourceIDs[name];
    }

    public int findResourceID(int id) {
        if (this.m_resourceIDs == null) {
            return -1;
        }
        for (int i = 0; i < this.m_resourceIDs.length; ++i) {
            if (this.m_resourceIDs[i] != id) continue;
            return i;
        }
        return -1;
    }

    public int getAttributeValueType(int index) {
        int offset = this.getAttributeOffset(index);
        return this.m_attributes[offset + 3];
    }

    public int getAttributeValueData(int index) {
        int offset = this.getAttributeOffset(index);
        return this.m_attributes[offset + 4];
    }

    public int getAttributeValueString(int index) {
        int offset = this.getAttributeOffset(index);
        return this.m_attributes[offset + 2];
    }

    public String getAttributeValue(int index) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.m_attributes[offset + 3];
        if (valueType == 3) {
            int valueString = this.m_attributes[offset + 2];
            return this.m_strings.getString(valueString);
        }
        return "";
    }

    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        return this.getAttributeIntValue(index, defaultValue ? 1 : 0) != 0;
    }

    public float getAttributeFloatValue(int index, float defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.m_attributes[offset + 3];
        if (valueType == 4) {
            int valueData = this.m_attributes[offset + 4];
            return Float.intBitsToFloat(valueData);
        }
        return defaultValue;
    }

    public int getAttributeIntValue(int index, int defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.m_attributes[offset + 3];
        if (valueType >= 16 && valueType <= 31) {
            return this.m_attributes[offset + 4];
        }
        return defaultValue;
    }

    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(index, defaultValue);
    }

    public int getAttributeResourceValue(int index, int defaultValue) {
        int offset = this.getAttributeOffset(index);
        int valueType = this.m_attributes[offset + 3];
        if (valueType == 1) {
            return this.m_attributes[offset + 4];
        }
        return defaultValue;
    }

    public String getAttributeValue(String namespace, String attribute) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return null;
        }
        return this.getAttributeValue(index);
    }

    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeBooleanValue(index, defaultValue);
    }

    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeFloatValue(index, defaultValue);
    }

    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeIntValue(index, defaultValue);
    }

    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeUnsignedIntValue(index, defaultValue);
    }

    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        int index = this.findAttribute(namespace, attribute);
        if (index == -1) {
            return defaultValue;
        }
        return this.getAttributeResourceValue(index, defaultValue);
    }

    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return 0;
    }

    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        return 0;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public void setInput(InputStream stream, String inputEncoding) throws IOException {
        throw new IOException(E_NOT_SUPPORTED);
    }

    public void setInput(Reader reader) throws IOException {
        throw new IOException(E_NOT_SUPPORTED);
    }

    public String getInputEncoding() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isEmptyElementTag() throws IOException {
        return false;
    }

    public boolean isWhitespace() throws IOException {
        return false;
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws IOException {
        throw new IOException(E_NOT_SUPPORTED);
    }

    public String getNamespace(String prefix) {
        throw new RuntimeException(E_NOT_SUPPORTED);
    }

    public Object getProperty(String name) {
        return null;
    }

    public void setProperty(String name, Object value) throws IOException {
        throw new IOException(E_NOT_SUPPORTED);
    }

    public boolean getFeature(String feature) {
        return false;
    }

    public void setFeature(String name, boolean value) throws IOException {
        throw new IOException(E_NOT_SUPPORTED);
    }

    final StringDecoder getStrings() {
        return this.m_strings;
    }

    private final int getAttributeOffset(int index) {
        if (this.m_event != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int offset = index * 5;
        if (offset >= this.m_attributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + index + ").");
        }
        return offset;
    }

    private final int findAttribute(String namespace, String attribute) {
        if (this.m_strings == null || attribute == null) {
            return -1;
        }
        int name = this.m_strings.find(attribute);
        if (name == -1) {
            return -1;
        }
        int uri = namespace != null ? this.m_strings.find(namespace) : -1;
        for (int o = 0; o != this.m_attributes.length; ++o) {
            if (name != this.m_attributes[o + 1] || uri != -1 && uri != this.m_attributes[o + 0]) continue;
            return o / 5;
        }
        return -1;
    }

    private final void resetEventInfo() {
        this.m_event = -1;
        this.m_lineNumber = -1;
        this.m_name = -1;
        this.m_namespaceUri = -1;
        this.m_attributes = null;
        this.m_idAttribute = -1;
        this.m_classAttribute = -1;
        this.m_styleAttribute = -1;
    }

    private void doNext() throws IOException {
        block14: {
            if (this.m_strings == null) {
                AXmlResourceParser.readCheckType(this.m_reader, 524291);
                this.m_reader.skipInt();
                this.m_strings = StringDecoder.read(this.m_reader);
                this.m_namespaces.increaseDepth();
                this.m_operational = true;
            }
            if (this.m_event == 1) {
                return;
            }
            int event = this.m_event;
            this.resetEventInfo();
            while (true) {
                if (this.m_decreaseDepth) {
                    this.m_decreaseDepth = false;
                    this.m_namespaces.decreaseDepth();
                }
                if (event == 3 && this.m_namespaces.getDepth() == 1 && this.m_namespaces.getCurrentCount() == 0) {
                    this.m_event = 1;
                    break block14;
                }
                int chunkType = event == 0 ? 0x100102 : this.m_reader.readInt();
                if (chunkType == 524672) {
                    int chunkSize = this.m_reader.readInt();
                    if (chunkSize < 8 || chunkSize % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + chunkSize + ").");
                    }
                    this.m_resourceIDs = this.m_reader.readIntArray(chunkSize / 4 - 2);
                    continue;
                }
                if (chunkType < 0x100100 || chunkType > 0x100104) {
                    throw new IOException("Invalid chunk type (" + chunkType + ").");
                }
                if (chunkType == 0x100102 && event == -1) {
                    this.m_event = 0;
                    break block14;
                }
                this.m_reader.skipInt();
                int lineNumber = this.m_reader.readInt();
                this.m_reader.skipInt();
                if (chunkType == 0x100100 || chunkType == 0x100101) {
                    if (chunkType == 0x100100) {
                        int prefix = this.m_reader.readInt();
                        int uri = this.m_reader.readInt();
                        this.m_namespaces.push(prefix, uri);
                        continue;
                    }
                    this.m_reader.skipInt();
                    this.m_reader.skipInt();
                    this.m_namespaces.pop();
                    continue;
                }
                this.m_lineNumber = lineNumber;
                if (chunkType == 0x100102) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_reader.skipInt();
                    int attributeCount = this.m_reader.readInt();
                    this.m_idAttribute = (attributeCount >>> 16) - 1;
                    this.m_classAttribute = this.m_reader.readInt();
                    this.m_styleAttribute = (this.m_classAttribute >>> 16) - 1;
                    this.m_classAttribute = (this.m_classAttribute & 0xFFFF) - 1;
                    this.currentAttributeStart = this.m_reader.getOffset();
                    this.m_attributes = this.m_reader.readIntArray((attributeCount &= 0xFFFF) * 5);
                    for (int i = 3; i < this.m_attributes.length; i += 5) {
                        this.m_attributes[i] = this.m_attributes[i] >>> 24;
                    }
                    this.m_namespaces.increaseDepth();
                    this.m_event = 2;
                    break block14;
                }
                if (chunkType == 0x100103) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_event = 3;
                    this.m_decreaseDepth = true;
                    break block14;
                }
                if (chunkType == 0x100104) break;
            }
            this.m_name = this.m_reader.readInt();
            this.m_reader.skipInt();
            this.m_reader.skipInt();
            this.m_event = 4;
        }
    }

    private static final class NamespaceStack {
        private int[] m_data = new int[32];
        private int m_dataLength;
        private int m_count;
        private int m_depth;

        public final void reset() {
            this.m_dataLength = 0;
            this.m_count = 0;
            this.m_depth = 0;
        }

        public final int getTotalCount() {
            return this.m_count;
        }

        public final int getCurrentCount() {
            if (this.m_dataLength == 0) {
                return 0;
            }
            int offset = this.m_dataLength - 1;
            return this.m_data[offset];
        }

        public final int getAccumulatedCount(int depth) {
            if (this.m_dataLength == 0 || depth < 0) {
                return 0;
            }
            if (depth > this.m_depth) {
                depth = this.m_depth;
            }
            int accumulatedCount = 0;
            int offset = 0;
            while (depth != 0) {
                int count = this.m_data[offset];
                accumulatedCount += count;
                offset += 2 + count * 2;
                --depth;
            }
            return accumulatedCount;
        }

        public final void push(int prefix, int uri) {
            if (this.m_depth == 0) {
                this.increaseDepth();
            }
            this.ensureDataCapacity(2);
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            this.m_data[offset - 1 - count * 2] = count + 1;
            this.m_data[offset] = prefix;
            this.m_data[offset + 1] = uri;
            this.m_data[offset + 2] = count + 1;
            this.m_dataLength += 2;
            ++this.m_count;
        }

        public final boolean pop(int prefix, int uri) {
            if (this.m_dataLength == 0) {
                return false;
            }
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            int i = 0;
            int o = offset - 2;
            while (i != count) {
                if (this.m_data[o] == prefix && this.m_data[o + 1] == uri) {
                    --count;
                    if (i == 0) {
                        this.m_data[o] = count;
                        this.m_data[o -= 1 + count * 2] = count;
                    } else {
                        this.m_data[offset] = count;
                        this.m_data[offset -= 3 + count * 2] = count;
                        System.arraycopy(this.m_data, o + 2, this.m_data, o, this.m_dataLength - o);
                    }
                    this.m_dataLength -= 2;
                    --this.m_count;
                    return true;
                }
                ++i;
                o -= 2;
            }
            return false;
        }

        public final boolean pop() {
            if (this.m_dataLength == 0) {
                return false;
            }
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            if (count == 0) {
                return false;
            }
            this.m_data[offset -= 2] = --count;
            this.m_data[offset -= 1 + count * 2] = count;
            this.m_dataLength -= 2;
            --this.m_count;
            return true;
        }

        public final int getPrefix(int index) {
            return this.get(index, true);
        }

        public final int getUri(int index) {
            return this.get(index, false);
        }

        public final int findPrefix(int uri) {
            return this.find(uri, false);
        }

        public final int findUri(int prefix) {
            return this.find(prefix, true);
        }

        public final int getDepth() {
            return this.m_depth;
        }

        public final void increaseDepth() {
            this.ensureDataCapacity(2);
            int offset = this.m_dataLength;
            this.m_data[offset] = 0;
            this.m_data[offset + 1] = 0;
            this.m_dataLength += 2;
            ++this.m_depth;
        }

        public final void decreaseDepth() {
            if (this.m_dataLength == 0) {
                return;
            }
            int offset = this.m_dataLength - 1;
            int count = this.m_data[offset];
            if (offset - 1 - count * 2 == 0) {
                return;
            }
            this.m_dataLength -= 2 + count * 2;
            this.m_count -= count;
            --this.m_depth;
        }

        private void ensureDataCapacity(int capacity) {
            int available = this.m_data.length - this.m_dataLength;
            if (available > capacity) {
                return;
            }
            int newLength = (this.m_data.length + available) * 2;
            int[] newData = new int[newLength];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_dataLength);
            this.m_data = newData;
        }

        private final int find(int prefixOrUri, boolean prefix) {
            if (this.m_dataLength == 0) {
                return -1;
            }
            int offset = this.m_dataLength - 1;
            for (int i = this.m_depth; i != 0; --i) {
                int count = this.m_data[offset];
                offset -= 2;
                while (count != 0) {
                    if (prefix) {
                        if (this.m_data[offset] == prefixOrUri) {
                            return this.m_data[offset + 1];
                        }
                    } else if (this.m_data[offset + 1] == prefixOrUri) {
                        return this.m_data[offset];
                    }
                    offset -= 2;
                    --count;
                }
            }
            return -1;
        }

        private final int get(int index, boolean prefix) {
            if (this.m_dataLength == 0 || index < 0) {
                return -1;
            }
            int offset = 0;
            for (int i = this.m_depth; i != 0; --i) {
                int count = this.m_data[offset];
                if (index >= count) {
                    index -= count;
                    offset += 2 + count * 2;
                    continue;
                }
                offset += 1 + index * 2;
                if (!prefix) {
                    ++offset;
                }
                return this.m_data[offset];
            }
            return -1;
        }
    }
}

