/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import org.jf.baksmali.Adaptors.EndTryLabelMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.util.IndentingWriter;

public class CatchMethodItem
extends MethodItem {
    private final String exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(@NonNull BaksmaliOptions options, @NonNull MethodDefinition.LabelCache labelCache, int codeAddress, @Nullable String exceptionType, int startAddress, int endAddress, int handlerAddress) {
        if (options == null) {
            CatchMethodItem.$$$reportNull$$$0(0);
        }
        if (labelCache == null) {
            CatchMethodItem.$$$reportNull$$$0(1);
        }
        super(codeAddress);
        this.exceptionType = exceptionType;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(options, startAddress, "try_start_"));
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(options, codeAddress, endAddress));
        this.handlerLabel = exceptionType == null ? labelCache.internLabel(new LabelMethodItem(options, handlerAddress, "catchall_")) : labelCache.internLabel(new LabelMethodItem(options, handlerAddress, "catch_"));
    }

    public LabelMethodItem getTryStartLabel() {
        return this.tryStartLabel;
    }

    public LabelMethodItem getTryEndLabel() {
        return this.tryEndLabel;
    }

    public LabelMethodItem getHandlerLabel() {
        return this.handlerLabel;
    }

    @Override
    public double getSortOrder() {
        return 102.0;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        if (this.exceptionType == null) {
            writer.write(".catchall");
        } else {
            writer.write(".catch ");
            writer.write(this.exceptionType);
        }
        writer.write(" {");
        this.tryStartLabel.writeTo(writer);
        writer.write(" .. ");
        this.tryEndLabel.writeTo(writer);
        writer.write("} ");
        this.handlerLabel.writeTo(writer);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "labelCache";
                break;
            }
        }
        objectArray[1] = "org/jf/baksmali/Adaptors/CatchMethodItem";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

