/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedStringReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.DexUtil;
import org.jf.util.ExceptionWithContext;

public class DexBackedDexFile
extends BaseDexBuffer
implements DexFile {
    @NonNull
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;

    protected DexBackedDexFile(@NonNull Opcodes opcodes, @NonNull byte[] buf, int offset, boolean verifyMagic) {
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(0);
        }
        if (buf == null) {
            DexBackedDexFile.$$$reportNull$$$0(1);
        }
        super(buf, offset);
        this.opcodes = opcodes;
        if (verifyMagic) {
            DexUtil.verifyDexHeader(buf, offset);
        }
        this.stringCount = this.readSmallUint(56);
        this.stringStartOffset = this.readSmallUint(60);
        this.typeCount = this.readSmallUint(64);
        this.typeStartOffset = this.readSmallUint(68);
        this.protoCount = this.readSmallUint(72);
        this.protoStartOffset = this.readSmallUint(76);
        this.fieldCount = this.readSmallUint(80);
        this.fieldStartOffset = this.readSmallUint(84);
        this.methodCount = this.readSmallUint(88);
        this.methodStartOffset = this.readSmallUint(92);
        this.classCount = this.readSmallUint(96);
        this.classStartOffset = this.readSmallUint(100);
    }

    public DexBackedDexFile(@NonNull Opcodes opcodes, @NonNull BaseDexBuffer buf) {
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            DexBackedDexFile.$$$reportNull$$$0(3);
        }
        this(opcodes, buf.buf, buf.baseOffset);
    }

    public DexBackedDexFile(@NonNull Opcodes opcodes, @NonNull byte[] buf, int offset) {
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(4);
        }
        if (buf == null) {
            DexBackedDexFile.$$$reportNull$$$0(5);
        }
        this(opcodes, buf, offset, false);
    }

    public DexBackedDexFile(@NonNull Opcodes opcodes, @NonNull byte[] buf) {
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(6);
        }
        if (buf == null) {
            DexBackedDexFile.$$$reportNull$$$0(7);
        }
        this(opcodes, buf, 0, true);
    }

    @NonNull
    public static DexBackedDexFile fromInputStream(@NonNull Opcodes opcodes, @NonNull InputStream is) throws IOException {
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(8);
        }
        if (is == null) {
            DexBackedDexFile.$$$reportNull$$$0(9);
        }
        DexUtil.verifyDexHeader(is);
        byte[] buf = ByteStreams.toByteArray(is);
        DexBackedDexFile dexBackedDexFile = new DexBackedDexFile(opcodes, buf, 0, false);
        if (dexBackedDexFile == null) {
            DexBackedDexFile.$$$reportNull$$$0(10);
        }
        return dexBackedDexFile;
    }

    @Override
    @NonNull
    public Opcodes getOpcodes() {
        Opcodes opcodes = this.opcodes;
        if (opcodes == null) {
            DexBackedDexFile.$$$reportNull$$$0(11);
        }
        return opcodes;
    }

    public boolean isOdexFile() {
        return false;
    }

    public boolean hasOdexOpcodes() {
        return false;
    }

    @NonNull
    public Set<? extends DexBackedClassDef> getClasses() {
        FixedSizeSet<DexBackedClassDef> fixedSizeSet = new FixedSizeSet<DexBackedClassDef>(){

            @Override
            @NonNull
            public DexBackedClassDef readItem(int index) {
                DexBackedClassDef dexBackedClassDef = new DexBackedClassDef(DexBackedDexFile.this, DexBackedDexFile.this.getClassDefItemOffset(index));
                if (dexBackedClassDef == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dexBackedClassDef;
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/DexBackedDexFile$1", "readItem"));
            }
        };
        if (fixedSizeSet == null) {
            DexBackedDexFile.$$$reportNull$$$0(12);
        }
        return fixedSizeSet;
    }

    public int getStringIdItemOffset(int stringIndex) {
        if (stringIndex < 0 || stringIndex >= this.stringCount) {
            throw new InvalidItemIndex(stringIndex, "String index out of bounds: %d", stringIndex);
        }
        return this.stringStartOffset + stringIndex * 4;
    }

    public int getTypeIdItemOffset(int typeIndex) {
        if (typeIndex < 0 || typeIndex >= this.typeCount) {
            throw new InvalidItemIndex(typeIndex, "Type index out of bounds: %d", typeIndex);
        }
        return this.typeStartOffset + typeIndex * 4;
    }

    public int getFieldIdItemOffset(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.fieldCount) {
            throw new InvalidItemIndex(fieldIndex, "Field index out of bounds: %d", fieldIndex);
        }
        return this.fieldStartOffset + fieldIndex * 8;
    }

    public int getMethodIdItemOffset(int methodIndex) {
        if (methodIndex < 0 || methodIndex >= this.methodCount) {
            throw new InvalidItemIndex(methodIndex, "Method index out of bounds: %d", methodIndex);
        }
        return this.methodStartOffset + methodIndex * 8;
    }

    public int getProtoIdItemOffset(int protoIndex) {
        if (protoIndex < 0 || protoIndex >= this.protoCount) {
            throw new InvalidItemIndex(protoIndex, "Proto index out of bounds: %d", protoIndex);
        }
        return this.protoStartOffset + protoIndex * 12;
    }

    public int getClassDefItemOffset(int classIndex) {
        if (classIndex < 0 || classIndex >= this.classCount) {
            throw new InvalidItemIndex(classIndex, "Class index out of bounds: %d", classIndex);
        }
        return this.classStartOffset + classIndex * 32;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public int getStringCount() {
        return this.stringCount;
    }

    public int getTypeCount() {
        return this.typeCount;
    }

    public int getProtoCount() {
        return this.protoCount;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    @NonNull
    public String getString(int stringIndex) {
        int stringOffset = this.getStringIdItemOffset(stringIndex);
        int stringDataOffset = this.readSmallUint(stringOffset);
        DexReader reader = this.readerAt(stringDataOffset);
        int utf16Length = reader.readSmallUleb128();
        String string = reader.readString(utf16Length);
        if (string == null) {
            DexBackedDexFile.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public String getOptionalString(int stringIndex) {
        if (stringIndex == -1) {
            return null;
        }
        return this.getString(stringIndex);
    }

    @NonNull
    public String getType(int typeIndex) {
        int typeOffset = this.getTypeIdItemOffset(typeIndex);
        int stringIndex = this.readSmallUint(typeOffset);
        String string = this.getString(stringIndex);
        if (string == null) {
            DexBackedDexFile.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public String getOptionalType(int typeIndex) {
        if (typeIndex == -1) {
            return null;
        }
        return this.getType(typeIndex);
    }

    public List<DexBackedStringReference> getStrings() {
        return new AbstractList<DexBackedStringReference>(){

            @Override
            public DexBackedStringReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getStringCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedStringReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getStringCount();
            }
        };
    }

    public List<DexBackedTypeReference> getTypes() {
        return new AbstractList<DexBackedTypeReference>(){

            @Override
            public DexBackedTypeReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getTypeCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedTypeReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getTypeCount();
            }
        };
    }

    public List<DexBackedMethodReference> getMethods() {
        return new AbstractList<DexBackedMethodReference>(){

            @Override
            public DexBackedMethodReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getMethodCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedMethodReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getMethodCount();
            }
        };
    }

    public List<DexBackedFieldReference> getFields() {
        return new AbstractList<DexBackedFieldReference>(){

            @Override
            public DexBackedFieldReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getFieldCount()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedFieldReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getFieldCount();
            }
        };
    }

    public List<? extends Reference> getReferences(int referenceType) {
        switch (referenceType) {
            case 0: {
                return this.getStrings();
            }
            case 1: {
                return this.getTypes();
            }
            case 3: {
                return this.getMethods();
            }
            case 2: {
                return this.getFields();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type: %d", referenceType));
    }

    @Override
    @NonNull
    public DexReader readerAt(int offset) {
        DexReader dexReader = new DexReader(this, offset);
        if (dexReader == null) {
            DexBackedDexFile.$$$reportNull$$$0(15);
        }
        return dexReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/DexBackedDexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/DexBackedDexFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInputStream";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpcodes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getString";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readerAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromInputStream";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidItemIndex
    extends ExceptionWithContext {
        private final int itemIndex;

        public InvalidItemIndex(int itemIndex) {
            super("", new Object[0]);
            this.itemIndex = itemIndex;
        }

        public InvalidItemIndex(int itemIndex, String message, Object ... formatArgs) {
            super(message, formatArgs);
            this.itemIndex = itemIndex;
        }

        public int getInvalidIndex() {
            return this.itemIndex;
        }
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(Throwable cause) {
            super(cause);
        }

        public NotADexFile(String message) {
            super(message);
        }

        public NotADexFile(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

