/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.List;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.util.ExceptionWithContext;

public class InstructionOffsetMap {
    @NonNull
    private final int[] instructionCodeOffsets;

    public InstructionOffsetMap(@NonNull List<? extends Instruction> instructions) {
        if (instructions == null) {
            InstructionOffsetMap.$$$reportNull$$$0(0);
        }
        this.instructionCodeOffsets = new int[instructions.size()];
        int codeOffset = 0;
        for (int i = 0; i < instructions.size(); ++i) {
            this.instructionCodeOffsets[i] = codeOffset;
            codeOffset += instructions.get(i).getCodeUnits();
        }
    }

    public int getInstructionIndexAtCodeOffset(int codeOffset) {
        return this.getInstructionIndexAtCodeOffset(codeOffset, true);
    }

    public int getInstructionIndexAtCodeOffset(int codeOffset, boolean exact) {
        int index = Arrays.binarySearch(this.instructionCodeOffsets, codeOffset);
        if (index < 0) {
            if (exact) {
                throw new InvalidInstructionOffset(codeOffset);
            }
            return ~index - 1;
        }
        return index;
    }

    public int getInstructionCodeOffset(int index) {
        if (index < 0 || index >= this.instructionCodeOffsets.length) {
            throw new InvalidInstructionIndex(index);
        }
        return this.instructionCodeOffsets[index];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "instructions", "org/jf/dexlib2/util/InstructionOffsetMap", "<init>"));
    }

    public static class InvalidInstructionIndex
    extends ExceptionWithContext {
        private final int instructionIndex;

        public InvalidInstructionIndex(int instructionIndex) {
            super("Instruction index out of bounds: %d", instructionIndex);
            this.instructionIndex = instructionIndex;
        }

        public int getInstructionIndex() {
            return this.instructionIndex;
        }
    }

    public static class InvalidInstructionOffset
    extends ExceptionWithContext {
        private final int instructionOffset;

        public InvalidInstructionOffset(int instructionOffset) {
            super("No instruction at offset %d", instructionOffset);
            this.instructionOffset = instructionOffset;
        }

        public int getInstructionOffset() {
            return this.instructionOffset;
        }
    }
}

