/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.stamp;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ApkSupportedSignature;
import com.android.apksig.internal.apk.NoApkSupportedSignaturesException;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.stamp.SourceStampCertificateLineage;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import java.io.ByteArrayInputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SourceStampVerifier {
    private SourceStampVerifier() {
    }

    public static void verifyV1SourceStamp(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, ApkSignerInfo result, byte[] apkDigest, byte[] sourceStampCertificateDigest, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        X509Certificate sourceStampCertificate = SourceStampVerifier.verifySourceStampCertificate(sourceStampBlockData, certFactory, sourceStampCertificateDigest, result);
        if (result.containsWarnings() || result.containsErrors()) {
            return;
        }
        ByteBuffer apkDigestSignatures = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(sourceStampBlockData);
        SourceStampVerifier.verifySourceStampSignature(apkDigest, minSdkVersion, maxSdkVersion, sourceStampCertificate, apkDigestSignatures, result);
    }

    public static void verifyV2SourceStamp(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, ApkSignerInfo result, Map<Integer, byte[]> signatureSchemeApkDigests, byte[] sourceStampCertificateDigest, int minSdkVersion, int maxSdkVersion) throws ApkFormatException, NoSuchAlgorithmException {
        X509Certificate sourceStampCertificate = SourceStampVerifier.verifySourceStampCertificate(sourceStampBlockData, certFactory, sourceStampCertificateDigest, result);
        if (result.containsWarnings() || result.containsErrors()) {
            return;
        }
        ByteBuffer signedSignatureSchemes = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(sourceStampBlockData);
        HashMap<Integer, ByteBuffer> signedSignatureSchemeData = new HashMap<Integer, ByteBuffer>();
        while (signedSignatureSchemes.hasRemaining()) {
            ByteBuffer signedSignatureScheme = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signedSignatureSchemes);
            int n = signedSignatureScheme.getInt();
            ByteBuffer apkDigestSignatures = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signedSignatureScheme);
            signedSignatureSchemeData.put(n, apkDigestSignatures);
        }
        for (Map.Entry entry : signatureSchemeApkDigests.entrySet()) {
            if ((Integer)entry.getKey() == 31) continue;
            if (!signedSignatureSchemeData.containsKey(entry.getKey())) {
                result.addWarning(17, new Object[0]);
                return;
            }
            SourceStampVerifier.verifySourceStampSignature((byte[])entry.getValue(), minSdkVersion, maxSdkVersion, sourceStampCertificate, (ByteBuffer)signedSignatureSchemeData.get(entry.getKey()), result);
            if (!result.containsWarnings() && !result.containsErrors()) continue;
            return;
        }
        if (sourceStampBlockData.hasRemaining()) {
            ByteBuffer stampAttributeData = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(sourceStampBlockData);
            ByteBuffer byteBuffer = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(sourceStampBlockData);
            byte[] stampAttributeBytes = new byte[stampAttributeData.remaining()];
            stampAttributeData.get(stampAttributeBytes);
            stampAttributeData.flip();
            SourceStampVerifier.verifySourceStampSignature(stampAttributeBytes, minSdkVersion, maxSdkVersion, sourceStampCertificate, byteBuffer, result);
            if (result.containsErrors() || result.containsWarnings()) {
                return;
            }
            SourceStampVerifier.parseStampAttributes(stampAttributeData, sourceStampCertificate, result);
        }
    }

    private static X509Certificate verifySourceStampCertificate(ByteBuffer sourceStampBlockData, CertificateFactory certFactory, byte[] sourceStampCertificateDigest, ApkSignerInfo result) throws NoSuchAlgorithmException, ApkFormatException {
        X509Certificate sourceStampCertificate;
        byte[] sourceStampEncodedCertificate = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(sourceStampBlockData);
        try {
            sourceStampCertificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(sourceStampEncodedCertificate));
        }
        catch (CertificateException e) {
            result.addWarning(18, e);
            return null;
        }
        sourceStampCertificate = new GuaranteedEncodedFormX509Certificate(sourceStampCertificate, sourceStampEncodedCertificate);
        result.certs.add(sourceStampCertificate);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(sourceStampEncodedCertificate);
        byte[] sourceStampBlockCertificateDigest = messageDigest.digest();
        if (!Arrays.equals(sourceStampCertificateDigest, sourceStampBlockCertificateDigest)) {
            result.addWarning(27, ApkSigningBlockUtilsLite.toHex(sourceStampBlockCertificateDigest), ApkSigningBlockUtilsLite.toHex(sourceStampCertificateDigest));
            return null;
        }
        return sourceStampCertificate;
    }

    private static void verifySourceStampSignature(byte[] data, int minSdkVersion, int maxSdkVersion, X509Certificate sourceStampCertificate, ByteBuffer signatures, ApkSignerInfo result) {
        List<ApkSupportedSignature> signaturesToVerify;
        Object signatureAlgorithm;
        int signatureCount = 0;
        ArrayList<ApkSupportedSignature> supportedSignatures = new ArrayList<ApkSupportedSignature>(1);
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signatures);
                int sigAlgorithmId = signature.getInt();
                byte[] sigBytes = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(signature);
                signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) {
                    result.addWarning(19, sigAlgorithmId);
                    continue;
                }
                supportedSignatures.add(new ApkSupportedSignature((SignatureAlgorithm)((Object)signatureAlgorithm), sigBytes));
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addWarning(20, signatureCount);
                return;
            }
        }
        if (supportedSignatures.isEmpty()) {
            result.addWarning(17, new Object[0]);
            return;
        }
        try {
            signaturesToVerify = ApkSigningBlockUtilsLite.getSignaturesToVerify(supportedSignatures, minSdkVersion, maxSdkVersion, true);
        }
        catch (NoApkSupportedSignaturesException e) {
            StringBuilder signatureAlgorithms = new StringBuilder();
            for (ApkSupportedSignature supportedSignature : supportedSignatures) {
                if (signatureAlgorithms.length() > 0) {
                    signatureAlgorithms.append(", ");
                }
                signatureAlgorithms.append((Object)supportedSignature.algorithm);
            }
            result.addWarning(26, signatureAlgorithms.toString(), e);
            return;
        }
        for (ApkSupportedSignature signature : signaturesToVerify) {
            signatureAlgorithm = signature.algorithm;
            String jcaSignatureAlgorithm = ((SignatureAlgorithm)((Object)signatureAlgorithm)).getJcaSignatureAlgorithmAndParams().getFirst();
            AlgorithmParameterSpec jcaSignatureAlgorithmParams = ((SignatureAlgorithm)((Object)signatureAlgorithm)).getJcaSignatureAlgorithmAndParams().getSecond();
            PublicKey publicKey = sourceStampCertificate.getPublicKey();
            try {
                Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
                sig.initVerify(publicKey);
                if (jcaSignatureAlgorithmParams != null) {
                    sig.setParameter(jcaSignatureAlgorithmParams);
                }
                sig.update(data);
                byte[] sigBytes = signature.signature;
                if (sig.verify(sigBytes)) continue;
                result.addWarning(21, signatureAlgorithm);
                return;
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                result.addWarning(22, signatureAlgorithm, e);
                return;
            }
        }
    }

    private static void parseStampAttributes(ByteBuffer stampAttributeData, X509Certificate sourceStampCertificate, ApkSignerInfo result) throws ApkFormatException {
        ByteBuffer stampAttributes = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(stampAttributeData);
        int stampAttributeCount = 0;
        while (stampAttributes.hasRemaining()) {
            ++stampAttributeCount;
            try {
                ByteBuffer attribute = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(stampAttributes);
                int id = attribute.getInt();
                byte[] value = ByteBufferUtils.toByteArray(attribute);
                if (id == -1654455305) {
                    SourceStampVerifier.readStampCertificateLineage(value, sourceStampCertificate, result);
                    continue;
                }
                if (id == -465807034) {
                    long timestamp = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    if (timestamp > 0L) {
                        result.timestamp = timestamp;
                        continue;
                    }
                    result.addWarning(38, timestamp);
                    continue;
                }
                result.addWarning(32, id);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                result.addWarning(31, stampAttributeCount);
                return;
            }
        }
    }

    private static void readStampCertificateLineage(byte[] lineageBytes, X509Certificate sourceStampCertificate, ApkSignerInfo result) {
        try {
            List<SourceStampCertificateLineage.SigningCertificateNode> nodes = SourceStampCertificateLineage.readSigningCertificateLineage(ByteBuffer.wrap(lineageBytes).order(ByteOrder.LITTLE_ENDIAN));
            for (int i = 0; i < nodes.size(); ++i) {
                result.certificateLineage.add(nodes.get((int)i).signingCert);
            }
            if (!sourceStampCertificate.equals(result.certificateLineage.get(result.certificateLineage.size() - 1))) {
                result.addWarning(34, new Object[0]);
            }
        }
        catch (SecurityException e) {
            result.addWarning(35, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            result.addWarning(34, new Object[0]);
        }
        catch (Exception e) {
            result.addWarning(33, new Object[0]);
        }
    }
}

