/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.StringBlock;
import brut.util.Duo;
import brut.util.ExtCountingDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

public final class ARSCDecoder {
    public static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    public final ExtCountingDataInput mIn;
    public final ResTable mResTable;
    public final ArrayList mFlagsOffsets;
    public final boolean mKeepBroken;
    public ARSCHeader mHeader;
    public StringBlock mTableStrings;
    public StringBlock mTypeNames;
    public StringBlock mSpecNames;
    public ResPackage mPkg;
    public ResTypeSpec mTypeSpec;
    public ResType mType;
    public int mResId;
    public int mTypeIdOffset = 0;
    public final LinkedHashMap mMissingResSpecMap;
    public final HashMap mResTypeSpecs;

    public static ARSCData decode(ResTable resPackageArray, InputStream object, boolean bl, boolean bl2) {
        FlagsOffset[] flagsOffsetArray;
        block7: {
            block6: {
                ARSCDecoder aRSCDecoder;
                try {
                    ARSCDecoder aRSCDecoder2 = new ARSCDecoder((ResTable)resPackageArray, (InputStream)object, bl, bl2);
                    aRSCDecoder = aRSCDecoder2;
                    resPackageArray = aRSCDecoder2.readResourceTable();
                }
                catch (IOException iOException) {
                    throw new AndrolibException("Could not decode arsc file", iOException);
                }
                flagsOffsetArray = aRSCDecoder.mFlagsOffsets;
                if (aRSCDecoder.mFlagsOffsets != null) break block6;
                flagsOffsetArray = null;
                break block7;
            }
            flagsOffsetArray = flagsOffsetArray.toArray(new FlagsOffset[0]);
        }
        Object object2 = object;
        ((ARSCData)object2)(resPackageArray, flagsOffsetArray);
        return object2;
    }

    public ARSCDecoder(ResTable resTable, InputStream inputStream, boolean bl, boolean bl2) {
        LinkedHashMap linkedHashMap;
        LittleEndianDataInputStream littleEndianDataInputStream;
        ExtCountingDataInput extCountingDataInput;
        HashMap hashMap;
        Object object = hashMap;
        hashMap = new HashMap();
        ((ARSCDecoder)object2).mResTypeSpecs = object;
        if (bl) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            ((ARSCDecoder)object2).mFlagsOffsets = object;
        } else {
            ((ARSCDecoder)object2).mFlagsOffsets = null;
        }
        ARSCDecoder aRSCDecoder = object2;
        Object object2 = extCountingDataInput;
        object = littleEndianDataInputStream;
        littleEndianDataInputStream = new LittleEndianDataInputStream(inputStream);
        extCountingDataInput = new ExtCountingDataInput((LittleEndianDataInputStream)object);
        aRSCDecoder.mIn = object2;
        aRSCDecoder.mResTable = resTable;
        aRSCDecoder.mKeepBroken = bl2;
        object2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        aRSCDecoder.mMissingResSpecMap = object2;
    }

    public static char[] unpackLanguageOrRegion(byte by, byte by2, char c) {
        if ((by >> 7 & 1) == 1) {
            byte by3 = by;
            byte by4 = by2;
            by2 = (byte)(by4 & 0x1F);
            byte by5 = by = (byte)(((by4 & 0xE0) >> 5) + ((by & 3) << 3));
            by = (byte)(by2 + c);
            by2 = (byte)(by5 + c);
            c = (char)(((by3 & 0x7C) >> 2) + c);
            return new char[]{(char)by, (char)by2, c};
        }
        by = by;
        by2 = by2;
        return new char[]{(char)by, (char)by2};
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final ResPackage[] readResourceTable() {
        var1_1 = v0;
        v0 = new LinkedHashSet<ResPackage>();
        var2_2 = 1;
        block34: while (true) {
            block113: {
                block114: {
                    block115: {
                        var3_5 = this.mIn;
                        var4_20 = var3_5.position();
                        try {
                            var5_28 = var3_5.mDelegate.readShort();
                        }
                        catch (EOFException v3) {
                            var6_39 = v4;
                            var3_6 = var3_5.position();
                            v4 = new ARSCHeader(-1, 0, 0, var3_6);
                        }
                        var6_39 = v1;
                        v2 = var3_5;
                        var3_6 = v2.mDelegate.readShort();
                        v1 = new ARSCHeader(var5_28, var3_6, v2.mDelegate.readInt(), var4_20);
                        this.mHeader = var6_39;
                        var3_7 = ARSCDecoder.LOGGER;
                        var4_21 = var2_2++;
                        var5_29 = this.mIn.position();
                        var6_39 = this.mHeader.type;
                        var7_41 = Integer.valueOf(this.mHeader.chunkSize);
                        v5 = new Object[4];
                        var8_51 = v5;
                        v5[0] = var4_21;
                        v5[1] = var5_29;
                        v5[2] = var6_39;
                        v5[3] = var7_41;
                        var3_7.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", var8_51));
                        var4_22 = this.mHeader.type;
                        if (var4_22 == 0) break block113;
                        if (var4_22 == 1) break block114;
                        if (var4_22 == 2) break block115;
                        switch (var4_22) {
                            default: {
                                if (var4_22 != -1) {
                                    v6 = var3_7;
                                    var2_3 = (short)var4_22;
                                    v7 = new Object[1];
                                    var3_7 = v7;
                                    v7[0] = var2_3;
                                    v6.severe(String.format("Unknown chunk type: %04x", (Object[])var3_7));
                                }
                                if (this.mResTable.mConfig.decodeResolveMode == 1 && (var2_4 = this.mPkg) != null && var2_4.mResSpecs.size() > 0) {
                                    for (Object var3_7 : this.mMissingResSpecMap.keySet()) {
                                        var4_23 = var3_7.intValue();
                                        var3_7 = (Integer)this.mMissingResSpecMap.get(var3_7);
                                        var3_7.getClass();
                                        var5_29 = "APKTOOL_DUMMY_" + Integer.toHexString(var4_23);
                                        var6_39 = v8;
                                        v8 = new ResID(var4_23);
                                        var4_24 = v9;
                                        var3_7 = (ResTypeSpec)this.mResTypeSpecs.get(var3_7);
                                        v9 = new ResResSpec((ResID)var6_39, (String)var5_29, this.mPkg, (ResTypeSpec)var3_7);
                                        if (this.mPkg.mResSpecs.containsKey(var6_39)) continue;
                                        if (this.mPkg.mResSpecs.put(var4_24.mId, var4_24) == null) {
                                            var4_24.mType.addResSpec(var4_24);
                                            var3_7 = this.mPkg;
                                            var5_29 = v10;
                                            v10 = new ResConfigFlags();
                                            var6_39 = (ResType)var3_7.mConfigs.get(var5_29);
                                            if (var6_39 == null) {
                                                var6_39 = v11;
                                                v11 = new ResType((ResConfigFlags)var5_29);
                                                var3_7.mConfigs.put(var5_29, var6_39);
                                            }
                                            var3_7 = v12;
                                            v12 = new ResReferenceValue(this.mPkg, "");
                                            var5_29 = v13;
                                            var6_39.addResource(new ResResource((ResType)var6_39, var4_24, (ResValue)var3_7), false);
                                            var4_24.addResource((ResResource)var5_29, false);
                                            continue;
                                        }
                                        throw new AndrolibException("Multiple resource specs: " + var4_24);
                                    }
                                }
                                return var1_1.toArray(new ResPackage[0]);
                            }
                            case 518: {
                                var3_8 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_22 = 0;
                                while (true) {
                                    if (var4_22 >= var3_8) continue block34;
                                    var5_29 = this.mIn.mDelegate.readInt();
                                    var6_39 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", new Object[]{var5_29, var6_39}));
                                    ++var4_22;
                                }
                            }
                            case 517: {
                                this.checkChunkType(517);
                                this.mIn.skipBytes(4);
                                var3_9 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_22 = 0;
                                while (true) {
                                    if (var4_22 >= var3_9) continue block34;
                                    var5_29 = this.mIn.mDelegate.readInt();
                                    ARSCDecoder.LOGGER.fine(String.format("Skipping overlay (%h)", new Object[]{var5_29}));
                                    ++var4_22;
                                }
                            }
                            case 516: {
                                v14 = var3_7;
                                this.checkChunkType(516);
                                var3_7 = this.mIn.readNullEndedString(256);
                                var4_25 = this.mIn.readNullEndedString(256);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                v15 = var5_29 = v16;
                                var5_29("Overlay name: \"");
                                v15.append((String)var3_7);
                                v15.append("\", actor: \"");
                                v16.append(var4_25);
                                v16.append("\")");
                                v14.fine(v16.toString());
                                continue block34;
                            }
                            case 515: {
                                this.checkChunkType(515);
                                var3_10 = this.mIn.mDelegate.readInt();
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var4_22 = 0;
                                while (true) {
                                    if (var4_22 >= var3_10) continue block34;
                                    var5_29 = this.mIn.readNullEndedString(128);
                                    var6_39 = this.mIn.mDelegate.readInt();
                                    v17 = new Object[2];
                                    var7_41 = v17;
                                    v17[0] = var5_29;
                                    v17[1] = var6_39;
                                    ARSCDecoder.LOGGER.info(String.format("Decoding Shared Library (%s), pkgId: %d", var7_41));
                                    ++var4_22;
                                }
                            }
                            case 514: {
                                this.checkChunkType(514);
                                var3_11 = this.mIn.mDelegate.readUnsignedByte();
                                this.mIn.skipBytes(1);
                                this.mIn.skipBytes(2);
                                var4_22 = this.mIn.mDelegate.readInt();
                                var5_29 = this.mFlagsOffsets;
                                if (var5_29 != null) {
                                    var5_29.add(new FlagsOffset(this.mIn.position(), var4_22));
                                }
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                this.mIn.skipBytes(var4_22 * 4);
                                var4_26 = v18;
                                v18 = new ResTypeSpec(var3_11, this.mTypeNames.getString(var3_11 - 1));
                                this.mTypeSpec = var4_26;
                                var3_12 = this.mPkg;
                                if (var3_12.mTypes.containsKey(var4_26.mName)) {
                                    ResPackage.LOGGER.warning("Multiple types detected! " + var4_26 + " ignored!");
                                } else {
                                    var3_12.mTypes.put(var4_26.mName, var4_26);
                                }
                                var3_12 = this.mTypeSpec;
                                this.mResTypeSpecs.put(var3_12.mId, var3_12);
                                continue block34;
                            }
                            case 513: {
                                this.checkChunkType(513);
                                var4_22 = this.mIn.mDelegate.readUnsignedByte() - this.mTypeIdOffset;
                                if (this.mResTypeSpecs.containsKey(var4_22)) {
                                    this.mTypeSpec = (ResTypeSpec)this.mResTypeSpecs.get(var4_22);
                                } else {
                                    var5_29 = v19;
                                    v19 = new ResTypeSpec(var4_22, this.mTypeNames.getString(var4_22 - 1));
                                    this.mTypeSpec = var5_29;
                                    this.mResTypeSpecs.put(var5_29.mId, var5_29);
                                    var5_29 = this.mPkg;
                                    var6_39 = this.mTypeSpec;
                                    if (var5_29.mTypes.containsKey(var6_39.mName)) {
                                        ResPackage.LOGGER.warning("Multiple types detected! " + var6_39 + " ignored!");
                                    } else {
                                        var5_29.mTypes.put(var6_39.mName, var6_39);
                                    }
                                }
                                this.mResId = this.mResId & -16777216 | this.mTypeSpec.mId << 16;
                                var5_30 = this.mIn.mDelegate.readByte();
                                this.mIn.skipBytes(2);
                                var6_40 = this.mIn.mDelegate.readInt();
                                var7_42 = this.mIn.mDelegate.readInt();
                                var8_52 = this.mIn.mDelegate.readInt();
                                var9_58 = 8;
                                if (var8_52 < 8) ** GOTO lbl595
                                var10_61 = 0;
                                var11_71 = this.mIn.mDelegate.readShort();
                                var12_74 = this.mIn.mDelegate.readShort();
                                var13_75 = new char[]{};
                                var14_80 /* !! */  = new char[]{};
                                if (var8_52 >= 12) {
                                    var13_75 = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), 'a');
                                    var14_80 /* !! */  = ARSCDecoder.unpackLanguageOrRegion(this.mIn.mDelegate.readByte(), this.mIn.mDelegate.readByte(), '0');
                                    var9_58 = 12;
                                }
                                var15_83 = false;
                                var16_86 = 0;
                                if (var8_52 >= 14) {
                                    var15_83 = this.mIn.mDelegate.readByte();
                                    var16_86 = this.mIn.mDelegate.readByte();
                                    var9_58 = 14;
                                }
                                var17_90 = 0;
                                if (var8_52 >= 16) {
                                    var17_90 = this.mIn.mDelegate.readUnsignedShort();
                                    var9_58 = 16;
                                }
                                var18_91 = 0;
                                var19_92 = 0;
                                var20_93 = 0;
                                var21_95 = 0;
                                if (var8_52 >= 20) {
                                    var18_91 = this.mIn.mDelegate.readByte();
                                    var19_92 = this.mIn.mDelegate.readByte();
                                    var20_93 = this.mIn.mDelegate.readByte();
                                    var21_95 = this.mIn.mDelegate.readByte();
                                    var9_58 = 20;
                                }
                                var22_96 = 0;
                                var23_97 = 0;
                                var24_99 = 0;
                                if (var8_52 >= 28) {
                                    var22_96 = this.mIn.mDelegate.readShort();
                                    var23_97 = this.mIn.mDelegate.readShort();
                                    var24_99 = this.mIn.mDelegate.readShort();
                                    this.mIn.skipBytes(2);
                                    var9_58 = 28;
                                }
                                var25_101 = false;
                                var26_102 = 0;
                                var27_104 = 0;
                                if (var8_52 >= 32) {
                                    var25_101 = this.mIn.mDelegate.readByte();
                                    var26_102 = this.mIn.mDelegate.readByte();
                                    var27_104 = this.mIn.mDelegate.readShort();
                                    var9_58 = 32;
                                }
                                var28_105 = 0;
                                var29_106 = 0;
                                if (var8_52 >= 36) {
                                    var28_105 = this.mIn.mDelegate.readShort();
                                    var29_106 = this.mIn.mDelegate.readShort();
                                    var9_58 = 36;
                                }
                                var30_107 = null;
                                var31_108 = null;
                                if (var8_52 >= 48) {
                                    var30_107 = this.readVariantLengthString(4).toCharArray();
                                    var31_108 = this.readVariantLengthString(8).toCharArray();
                                    var9_58 = 48;
                                }
                                var32_109 = 0;
                                var33_110 = 0;
                                if (var8_52 >= 52) {
                                    var32_109 = this.mIn.mDelegate.readByte();
                                    var33_110 = this.mIn.mDelegate.readByte();
                                    this.mIn.skipBytes(2);
                                    var9_58 = 52;
                                }
                                var34_111 = null;
                                if (var8_52 >= 60) {
                                    var34_111 = this.readVariantLengthString(8).toCharArray();
                                    var9_58 = 60;
                                }
                                if ((var35_112 = var8_52 - 64) > 0) {
                                    v20 = var35_112;
                                    var9_59 /* !! */  = new byte[v20];
                                    var35_112 = var9_58 + v20;
                                    this.mIn.mDelegate.readFully(var9_59 /* !! */ );
                                    var36_113 = v21;
                                    if (new BigInteger(1, var9_59 /* !! */ ).equals(BigInteger.ZERO)) {
                                        v22 = var3_7;
                                        var3_7 = 64;
                                        v23 = new Object[1];
                                        var9_59 /* !! */  = (byte[])v23;
                                        v23[0] = var3_7;
                                        v22.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", var9_59 /* !! */ ));
                                        var9_58 = var35_112;
                                    } else {
                                        v24 = var3_7;
                                        var3_7 = 64;
                                        var9_59 /* !! */  = (byte[])var8_52;
                                        v25 = new Object[3];
                                        var10_62 = v25;
                                        v25[0] = var3_7;
                                        v25[1] = var9_59 /* !! */ ;
                                        v25[2] = var36_113;
                                        v24.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", var10_62));
                                        var10_61 = 1;
                                        var9_58 = var35_112;
                                    }
                                }
                                if ((var3_13 = var8_52 - var9_58) > 0) {
                                    this.mIn.skipBytes(var3_13);
                                }
                                var3_14 = v26;
                                v26 = new ResConfigFlags(var11_71, (short)var12_74, var13_75, var14_80 /* !! */ , (byte)var15_83, var16_86, var17_90, (byte)var18_91, (byte)var19_92, var20_93, (byte)var21_95, (short)var22_96, var23_97, var24_99, (byte)var25_101, var26_102, var27_104, var28_105, var29_106, var30_107, var31_108, var32_109, var33_110, var34_111, (boolean)var10_61, var8_52);
                                this.mHeader.checkForUnreadHeader(this.mIn);
                                var8_52 = (var5_30 & 2) != 0 ? 1 : 0;
                                var5_30 = (var5_30 & 1) != 0 ? 1 : 0;
                                if (var5_30 != 0) {
                                    var9_60 = this.mResTable;
                                    if (!var9_60.mMainPkgLoaded) {
                                        var10_61 = 1;
                                        if (var9_60.mApkInfo.sparseResources != var10_61) {
                                            ResTable.LOGGER.info("Sparsely packed resources detected.");
                                        }
                                        var9_60.mApkInfo.sparseResources = var10_61;
                                    }
                                }
                                var9_57 = v27;
                                v27 = new LinkedHashMap<Integer, Integer>();
                                for (var10_61 = 0; var10_61 < var6_40; ++var10_61) {
                                    if (var5_30 != 0) {
                                        v28 = var9_57;
                                        v29 = this.mIn.mDelegate.readUnsignedShort();
                                        v30 = this.mIn;
lbl310:
                                        // 2 sources

                                        while (true) {
                                            v31 = v30.mDelegate.readUnsignedShort();
lbl312:
                                            // 2 sources

                                            while (true) {
                                                continue;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    if (var8_52 != 0) {
                                        v28 = var9_57;
                                        v29 = var10_61;
                                        v30 = this.mIn;
                                        ** continue;
                                    }
                                    v28 = var9_57;
                                    v29 = var10_61;
                                    v31 = this.mIn.mDelegate.readInt();
                                    ** continue;
                                    v28.put(v29, v31);
                                }
                                if (var3_14.isInvalid) {
                                    var5_31 = this.mTypeSpec.mName + var3_14.mQualifiers;
                                    if (this.mKeepBroken) {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected: " + var5_31);
                                    } else {
                                        ARSCDecoder.LOGGER.warning("Invalid config flags detected. Dropping resources: " + var5_31);
                                    }
                                }
                                if (var3_14.isInvalid && !this.mKeepBroken) {
                                    var3_14 = null;
                                } else {
                                    var5_32 = this.mPkg;
                                    var10_63 = (ResType)var5_32.mConfigs.get(var3_14);
                                    if (var10_63 == null) {
                                        v32 = var5_32;
                                        var5_32 = v33;
                                        v33 = new ResType((ResConfigFlags)var3_14);
                                        v32.mConfigs.put(var3_14, var5_32);
                                        var3_14 = var5_32;
                                    } else {
                                        var3_14 = var10_63;
                                    }
                                }
                                this.mType = var3_14;
                                var3_15 = var8_52 != 0 ? 65535 : -1;
                                var5_33 = this.mHeader.startPosition + var7_42;
                                if (this.mIn.position() < var5_33) {
                                    v34 = this.mIn;
                                    var7_43 = v34.mCountIn;
                                    var10_64 = var5_33 -= v34.position();
                                    synchronized (var7_43) {
                                        var10_64 = var7_43.skip$org$apache$commons$io$input$ProxyInputStream(var10_64);
                                        v35 = var7_43.count;
                                        var7_43.count = v35 + var10_64;
                                    }
                                    var5_34 = v36;
                                    var5_34("Skipping: ");
                                    ARSCDecoder.LOGGER.fine(v36.append(var10_64).append(" byte(s) to align with ResTable_entry start.").toString());
                                    ** GOTO lbl366
                                    {
                                        catch (Throwable v37) {
                                            throw v37;
                                        }
                                    }
                                }
lbl366:
                                // 7 sources

                                block42: for (Integer v38 : var9_57.keySet()) {
                                    var7_44 = v38;
                                    this.mResId = this.mResId & -65536 | var7_44;
                                    if ((Integer)var9_57.get(v38) == var3_15) {
                                        while (true) {
                                            var7_45 = this.mResId;
                                            this.mMissingResSpecMap.put(var7_45, var4_22);
                                            continue block42;
                                            break;
                                        }
                                    }
                                    if (this.mIn.position() == this.mHeader.endPosition) {
                                        var3_15 = var6_40 - var7_44;
                                        var3_16 = var3_15;
                                        var4_27 = this.mTypeSpec.mName;
                                        ARSCDecoder.LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", new Object[]{var3_16, var4_27}));
                                        break;
                                    }
                                    var7_44 = this.mIn.mDelegate.readShort();
                                    var8_53 = this.mIn.mDelegate.readShort();
                                    var10_65 = (var8_53 & 1) != 0;
                                    var11_71 = (var8_53 & 8) != 0 ? 1 : 0;
                                    if (var7_44 < 0 && var11_71 == 0) {
                                        throw new AndrolibException("Entry size is under 0 bytes and not compactly packed.");
                                    }
                                    var12_74 = this.mIn.mDelegate.readInt();
                                    if (var12_74 != -1 || var11_71 != 0) ** GOTO lbl392
                                    while (true) {
                                        var7_46 = null;
                                        ** GOTO lbl545
                                        break;
                                    }
lbl392:
                                    // 1 sources

                                    if (var11_71 == 0) ** GOTO lbl417
                                    v39 = (byte)(var8_53 >> 8 & 255);
                                    var8_53 = v39;
                                    if (v39 == 3) {
                                        var8_54 = this.mPkg.getValueFactory();
                                        var10_66 = this.mTableStrings.getHTML(var12_74);
                                        var8_54.getClass();
                                        if (var10_66 == null) {
                                            var8_54 = v40;
                                            v40 = new ResFileValue(var12_74, "");
                                        } else if (var10_66.startsWith("res/")) {
                                            var8_54 = v41;
                                            v41 = new ResFileValue(var12_74, var10_66);
                                        } else if (!var10_66.startsWith("r/") && !var10_66.startsWith("R/")) {
                                            var8_54 = v42;
                                            v42 = new ResStringValue(var12_74, var10_66);
                                        } else {
                                            var8_54 = v43;
                                            v43 = new ResFileValue(var12_74, var10_66);
                                        }
                                    } else {
                                        var8_54 = this.mPkg.getValueFactory().factory(null, var8_53, var12_74);
                                    }
                                    ** GOTO lbl540
lbl417:
                                    // 1 sources

                                    if (!var10_65) ** GOTO lbl538
                                    var7_44 = this.mIn.mDelegate.readInt();
                                    var8_53 = this.mIn.mDelegate.readInt();
                                    var10_67 = this.mPkg.getValueFactory();
                                    var11_72 = new Duo[var8_53];
                                    for (var13_76 = 0; var13_76 < var8_53; ++var13_76) {
                                        var14_81 = this.mIn.mDelegate.readInt();
                                        var15_84 = this.readValue();
                                        if (var15_84 == null) continue;
                                        if (!(var15_84 instanceof ResScalarValue)) {
                                            var16_87 = v44;
                                            v45 = var15_84;
                                            var15_84 = v45.toString();
                                            v44 = new ResStringValue(v45.mRawIntValue, (String)var15_84);
                                            var15_84 = var16_87;
                                        }
                                        var16_88 = v46;
                                        var14_82 = var14_81;
                                        v46 = new Duo(var14_82, (ResScalarValue)var15_84);
                                        var11_72[var13_76] = var16_88;
                                    }
                                    var13_77 = this.mTypeSpec;
                                    var14_80 /* !! */  = null;
                                    var15_83 = false;
                                    var16_89 = v47;
                                    v47 = new ResReferenceValue(var10_67.mPackage, var7_44, (String)var14_80 /* !! */ , var15_83);
                                    if (var8_53 != 0) ** GOTO lbl447
                                    var7_47 = v48;
                                    v48 = new ResBagValue(var16_89);
                                    var8_54 = var7_47;
                                    ** GOTO lbl536
lbl447:
                                    // 1 sources

                                    var7_47 = var13_77.mName;
                                    var7_47.getClass();
                                    var13_78 = -1;
                                    switch (var7_47.hashCode()) {
                                        default: {
                                            break;
                                        }
                                        case 93090393: {
                                            if (!var7_47.equals("array")) break;
                                            var13_78 = 3;
                                            break;
                                        }
                                        case 3004913: {
                                            if (!var7_47.equals("attr")) break;
                                            var13_78 = 2;
                                            break;
                                        }
                                        case -475309713: {
                                            if (!var7_47.equals("plurals")) break;
                                            var13_78 = 1;
                                            break;
                                        }
                                        case -576469755: {
                                            if (!var7_47.equals("^attr-private")) break;
                                            var13_78 = 0;
                                        }
                                    }
                                    switch (var13_78) {
                                        default: {
                                            if (var7_47.startsWith("style")) {
                                                var7_47 = v49;
                                                v49 = new ResStyleValue(var16_89, var11_72, var10_67);
                                                var8_54 = var7_47;
                                                break;
                                            }
                                            throw new AndrolibException("unsupported res type name for bags. Found: ".concat((String)var7_47));
                                        }
                                        case 3: {
                                            var7_47 = v50;
                                            v50 = new ResArrayValue(var16_89, var11_72);
                                            var8_54 = var7_47;
                                            break;
                                        }
                                        case 1: {
                                            var7_47 = v51;
                                            v51 = new ResPluralsValue(var16_89, var11_72);
                                            var8_54 = var7_47;
                                            break;
                                        }
                                        case 0: 
                                        case 2: {
                                            var7_47 = var10_67.mPackage;
                                            var13_79 = null;
                                            var14_80 /* !! */  = null;
                                            var15_85 = null;
                                            block46: for (var17_90 = 1; var17_90 < var8_53; ++var17_90) {
                                                switch ((Integer)var11_72[var17_90].m1) {
                                                    default: {
                                                        break block46;
                                                    }
                                                    case 0x1000003: {
                                                        var15_85 = ((ResScalarValue)var11_72[var17_90].m2).mRawIntValue != 0;
                                                        continue block46;
                                                    }
                                                    case 0x1000002: {
                                                        var14_80 /* !! */  = (char[])((ResScalarValue)var11_72[var17_90].m2).mRawIntValue;
                                                        continue block46;
                                                    }
                                                    case 0x1000001: {
                                                        var13_79 = ((ResScalarValue)var11_72[var17_90].m2).mRawIntValue;
                                                    }
                                                }
                                            }
                                            var18_91 = ((ResScalarValue)var11_72[0].m2).mRawIntValue;
                                            var19_92 = var18_91 & 65535;
                                            if (var17_90 != var8_53) ** GOTO lbl511
                                            var7_47 = v52;
                                            v52 = new ResAttr(var16_89, var19_92, var13_79, (Integer)var14_80 /* !! */ , var15_85);
                                            ** GOTO lbl535
lbl511:
                                            // 1 sources

                                            var20_94 = new Duo[var8_53 - var17_90];
                                            var21_95 = 0;
                                            while (var17_90 < var8_53) {
                                                var22_96 = (Integer)var11_72[var17_90].m1;
                                                var7_47.mSynthesizedRes.add(new ResID(var22_96));
                                                var23_98 = v53;
                                                var24_100 = null;
                                                var25_101 = false;
                                                var26_103 = v54;
                                                v54 = new ResReferenceValue(var10_67.mPackage, var22_96, var24_100, var25_101);
                                                v53 = new Duo(var26_103, (ResScalarValue)var11_72[var17_90].m2);
                                                var20_94[var21_95++] = var23_98;
                                                ++var17_90;
                                            }
                                            var7_48 = var18_91 & 0xFF0000;
                                            if (var7_48 == 65536) ** GOTO lbl533
                                            if (var7_48 == 131072) {
                                                var7_47 = v55;
                                                v55 = new ResFlagsAttr(var16_89, var19_92, var13_79, (Integer)var14_80 /* !! */ , var15_85, var20_94);
                                            } else {
                                                throw new AndrolibException("Could not decode attr value");
lbl533:
                                                // 1 sources

                                                var7_47 = v56;
                                                v56 = new ResEnumAttr(var16_89, var19_92, var13_79, (Integer)var14_80 /* !! */ , var15_85, var20_94);
                                            }
lbl535:
                                            // 3 sources

                                            var8_54 = var7_47;
                                        }
                                    }
lbl536:
                                    // 5 sources

                                    var7_44 = var12_74;
                                    ** GOTO lbl540
lbl538:
                                    // 1 sources

                                    var8_54 = this.readValue();
                                    var7_44 = var12_74;
lbl540:
                                    // 7 sources

                                    if (var8_54 == null) ** continue;
                                    var10_68 = v57;
                                    new EntryData().mSpecNamesId = var7_44;
                                    new EntryData().mValue = var8_54;
                                    var7_46 = var10_68;
lbl545:
                                    // 2 sources

                                    if (var7_46 == null) ** continue;
                                    v58 = var7_46;
                                    var7_49 = v58.mSpecNamesId;
                                    var8_55 = v58.mValue;
                                    if (this.mTypeSpec.mName.equalsIgnoreCase("string") && var8_55 instanceof ResFileValue) {
                                        var10_69 = v59;
                                        v60 = var8_55;
                                        var8_55 = ((ResFileValue)v60).mPath;
                                        v59 = new ResStringValue(((ResFileValue)v60).mRawIntValue, (String)var8_55);
                                        var8_55 = var10_69;
                                    }
                                    if (this.mType == null) continue;
                                    var10_70 = v61;
                                    v61 = new ResID(this.mResId);
                                    if (!this.mPkg.mResSpecs.containsKey(var10_70)) ** GOTO lbl563
                                    var7_50 = (ResResSpec)this.mPkg.mResSpecs.get(var10_70);
                                    if (var7_50 == null) {
                                        throw new UndefinedResObjectException("resource spec: ".concat(var10_70.toString()));
                                    }
                                    ** GOTO lbl569
lbl563:
                                    // 1 sources

                                    var11_73 = v62;
                                    var7_50 = this.mTypeSpec;
                                    v62 = new ResResSpec((ResID)var10_70, this.mSpecNames.getString(var7_49), this.mPkg, (ResTypeSpec)var7_50);
                                    if (this.mPkg.mResSpecs.put(var11_73.mId, var11_73) != null) ** GOTO lbl586
                                    this.mTypeSpec.addResSpec(var11_73);
                                    var7_50 = var11_73;
lbl569:
                                    // 2 sources

                                    var10_70 = v63;
                                    v64 = this.mType;
                                    var10_70(v64, (ResResSpec)var7_50, (ResValue)var8_55);
                                    try {
                                        v64.addResource((ResResource)var10_70, false);
                                        var7_50.addResource(v63, false);
                                        continue;
                                    }
                                    catch (AndrolibException var8_56) {
                                        if (this.mKeepBroken) {
                                            this.mType.addResource((ResResource)var10_70, true);
                                            var7_50.addResource((ResResource)var10_70, true);
                                            v65 = new StringBuilder("Duplicate Resource Detected. Ignoring duplicate: ");
                                            v65.append(var10_70);
                                            ARSCDecoder.LOGGER.warning(v65.toString());
                                            continue;
                                        }
                                        throw var8_56;
                                    }
lbl586:
                                    // 1 sources

                                    throw new AndrolibException("Multiple resource specs: " + var11_73);
                                }
                                var3_17 = this.mHeader.endPosition;
                                if (this.mIn.position() >= var3_17) continue block34;
                                v66 = this.mIn;
                                var3_18 = v66.skip(var3_17 - v66.position());
                                var5_35 = v67;
                                var5_35("Unknown data detected. Skipping: ");
                                ARSCDecoder.LOGGER.warning(v67.append(var3_18).append(" byte(s)").toString());
                                continue block34;
lbl595:
                                // 1 sources

                                throw new AndrolibException("Config size < 8");
                            }
                            case 512: 
                        }
                        this.mTypeIdOffset = 0;
                        this.checkChunkType(512);
                        var4_22 = this.mIn.mDelegate.readInt();
                        if (var4_22 == 0) {
                            var4_22 = 2;
                            var5_29 = this.mResTable;
                            if (var5_29.mPackageOriginal == null && var5_29.mPackageRenamed == null) {
                                var5_29.mApkInfo.sharedLibrary = var5_36 = true;
                            }
                        }
                        var5_37 = this.mIn.readNullEndedString(128);
                        this.mIn.skipBytes(4);
                        this.mIn.skipBytes(4);
                        this.mIn.skipBytes(4);
                        this.mIn.skipBytes(4);
                        if (this.mHeader.headerSize == 288) {
                            this.mTypeIdOffset = this.mIn.mDelegate.readInt();
                        }
                        if (this.mTypeIdOffset > 0) {
                            var3_7.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
                        }
                        this.mHeader.checkForUnreadHeader(this.mIn);
                        this.mTypeNames = StringBlock.readWithChunk(this.mIn);
                        this.mSpecNames = StringBlock.readWithChunk(this.mIn);
                        this.mResId = var4_22 << 24;
                        this.mPkg = var3_7 = v68;
                        var1_1.add(new ResPackage(this.mResTable, var4_22, var5_37));
                        continue;
                    }
                    this.checkChunkType(2);
                    this.mIn.skipBytes(4);
                    this.mHeader.checkForUnreadHeader(this.mIn);
                    continue;
                }
                this.checkChunkType(1);
                v69 = this.mHeader;
                var3_19 = v69.startPosition;
                var4_22 = v69.headerSize;
                var5_38 = v69.chunkSize;
                this.mTableStrings = StringBlock.readWithoutChunk(this.mIn, var3_19, var4_22, var5_38);
                continue;
            }
            this.checkChunkType(0);
            this.mHeader.checkForUnreadHeader(this.mIn);
            var3_7.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
            var3_7 = this.mHeader;
            this.mIn.skipBytes(var3_7.chunkSize - var3_7.headerSize);
        }
    }

    public final ResIntBasedValue readValue() {
        Object object;
        if (((ARSCDecoder)object).mIn.mDelegate.readShort() < 8) {
            return null;
        }
        byte by = 0;
        int n = ((ARSCDecoder)object).mIn.mDelegate.readByte();
        if (n == 0) {
            by = ((ARSCDecoder)object).mIn.mDelegate.readByte();
            n = ((ARSCDecoder)object).mIn.mDelegate.readInt();
            if (by == 3) {
                Object object2 = object;
                object = ((ARSCDecoder)object2).mPkg.getValueFactory();
                String string = ((ARSCDecoder)object2).mTableStrings.getHTML(n);
                object.getClass();
                if (string == null) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, "");
                } else if (string.startsWith("res/")) {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                } else if (!string.startsWith("r/") && !string.startsWith("R/")) {
                    ResStringValue resStringValue;
                    object = resStringValue;
                    resStringValue = new ResStringValue(n, string);
                } else {
                    ResFileValue resFileValue;
                    object = resFileValue;
                    resFileValue = new ResFileValue(n, string);
                }
            } else {
                object = ((ARSCDecoder)object).mPkg.getValueFactory().factory(null, by, n);
            }
            return object;
        }
        object = by;
        Byte by2 = (byte)n;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = by2;
        throw new IOException(String.format("Expected: 0x%08x, got: 0x%08x", objectArray2));
    }

    public final String readVariantLengthString(int n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(16);
        while (true) {
            short s;
            int n2 = n;
            n = n2 + -1;
            if (n2 == 0 || (s = (short)this.mIn.mDelegate.readByte()) == 0) break;
            stringBuilder2.append((char)s);
        }
        this.mIn.skipBytes(n);
        return stringBuilder2.toString();
    }

    public final void checkChunkType(int n) {
        if (((ARSCDecoder)((Object)n2)).mHeader.type == n) {
            return;
        }
        ARSCDecoder aRSCDecoder = n2;
        Integer n2 = n;
        Short s = aRSCDecoder.mHeader.type;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = s;
        throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", objectArray2));
    }
}

