/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipRODirectory
extends AbstractDirectory {
    public final ZipFile mZipFile;
    public final String mPath;

    public ZipRODirectory(File file) {
        ZipFile zipFile;
        String string = "";
        ZipFile zipFile2 = zipFile;
        try {
            zipFile = new ZipFile(file);
            this.mZipFile = zipFile2;
            this.mPath = string;
            return;
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }

    public ZipRODirectory(ZipFile zipFile, String string) {
        this.mZipFile = zipFile;
        this.mPath = string;
    }

    @Override
    public final AbstractDirectory createDirLocal(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final InputStream getFileInputLocal(String string) {
        ZipEntry zipEntry;
        ZipEntry zipEntry2;
        ZipFile zipFile;
        try {
            ZipEntry zipEntry3;
            zipFile = this.mZipFile;
            zipEntry2 = zipEntry3;
            zipEntry = zipEntry3;
        }
        catch (IOException iOException) {
            throw new PathNotExist(string, iOException);
        }
        zipEntry2(this.mPath + string);
        return zipFile.getInputStream(zipEntry);
    }

    @Override
    public final OutputStream getFileOutputLocal(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void loadDirs() {
        this.loadAll$1();
    }

    @Override
    public final void loadFiles() {
        this.loadAll$1();
    }

    @Override
    public final void removeFileLocal(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getSize(String string) {
        ZipEntry zipEntry = ((ZipRODirectory)((Object)zipEntry)).mZipFile.getEntry(string);
        if (zipEntry != null) {
            return zipEntry.getSize();
        }
        throw new PathNotExist("Entry not found: " + string);
    }

    @Override
    public final int getCompressionLevel(String string) {
        ZipEntry zipEntry = ((ZipRODirectory)((Object)zipEntry)).mZipFile.getEntry(string);
        if (zipEntry != null) {
            return zipEntry.getMethod();
        }
        throw new PathNotExist("Entry not found: " + string);
    }

    @Override
    public final void close() {
        this.mZipFile.close();
    }

    public final void loadAll$1() {
        ZipRODirectory zipRODirectory = this;
        zipRODirectory.mFiles = new LinkedHashSet();
        zipRODirectory.mDirs = new LinkedHashMap();
        int n = zipRODirectory.mPath.length();
        Enumeration<? extends ZipEntry> enumeration = zipRODirectory.mZipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipRODirectory zipRODirectory2;
            Object object = enumeration.nextElement();
            String string = ((ZipEntry)object).getName();
            if (string.equals(this.mPath) || !string.startsWith(this.mPath) || string.contains("../")) continue;
            int n2 = (string = string.substring(n)).indexOf(47);
            if (n2 == -1) {
                if (!((ZipEntry)object).isDirectory()) {
                    this.mFiles.add(string);
                    continue;
                }
            } else {
                string = string.substring(0, n2);
            }
            if (this.mDirs.containsKey(string)) continue;
            object = zipRODirectory2;
            zipRODirectory2 = new ZipRODirectory(this.mZipFile, this.mPath + string + '/');
            this.mDirs.put(string, object);
        }
    }
}

