/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;

public class OdexHeaderItem {
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 121, 10, 0, 0, 0, 0};
    private static final int[] SUPPORTED_ODEX_VERSIONS = new int[]{35, 36};

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            if (buf[offset + i] == MAGIC_VALUE[i]) continue;
            return false;
        }
        for (i = 4; i < 7; ++i) {
            if (buf[offset + i] >= 48 && buf[offset + i] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!OdexHeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return OdexHeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedOdexVersion(int version) {
        for (int i = 0; i < SUPPORTED_ODEX_VERSIONS.length; ++i) {
            if (SUPPORTED_ODEX_VERSIONS[i] != version) continue;
            return true;
        }
        return false;
    }

    public static int getDexOffset(byte[] buf) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readSmallUint(8);
    }
}

