/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.builder.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.builder.BuilderSwitchPayload;
import com.android.tools.smali.dexlib2.builder.Label;
import com.android.tools.smali.dexlib2.builder.instruction.BuilderSwitchElement;
import com.android.tools.smali.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class BuilderPackedSwitchPayload
extends BuilderSwitchPayload
implements PackedSwitchPayload {
    public static final Opcode OPCODE = Opcode.PACKED_SWITCH_PAYLOAD;
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderPackedSwitchPayload(int startKey, List<? extends Label> switchElements) {
        super(OPCODE);
        if (switchElements == null) {
            this.switchElements = ImmutableList.of();
        } else {
            this.switchElements = Lists.newArrayList();
            int key = startKey;
            for (Label label : switchElements) {
                this.switchElements.add(new BuilderSwitchElement(this, key++, label));
            }
        }
    }

    public List<BuilderSwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 4 + this.switchElements.size() * 2;
    }

    @Override
    public Format getFormat() {
        return BuilderPackedSwitchPayload.OPCODE.format;
    }
}

