/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.OptionValidator;
import org.apache.commons.cli.Util;

public class Option
implements Serializable,
Cloneable {
    static final Option[] EMPTY_ARRAY = new Option[0];
    private final String option;
    private String longOption;
    private String argName;
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int argCount = -1;
    private Class<?> type = String.class;
    private List<String> values = new ArrayList<String>();
    private char valuesep;

    public static Builder builder() {
        return Option.builder(null);
    }

    public static Builder builder(String option) {
        return new Builder(option);
    }

    private Option(Builder builder) {
        this.argName = builder.argName;
        this.description = builder.description;
        this.longOption = builder.longOption;
        this.argCount = builder.argCount;
        this.option = builder.option;
        this.optionalArg = builder.optionalArg;
        this.required = builder.required;
        this.type = builder.type;
        this.valuesep = builder.valueSeparator;
    }

    boolean acceptsArg() {
        return !(!this.hasArg() && !this.hasArgs() && !this.hasOptionalArg() || this.argCount > 0 && this.values.size() >= this.argCount);
    }

    private void add(String value) {
        if (!this.acceptsArg()) {
            throw new IllegalArgumentException("Cannot add value, list full.");
        }
        this.values.add(value);
    }

    void addValueForProcessing(String value) {
        if (this.argCount == -1) {
            throw new IllegalArgumentException("NO_ARGS_ALLOWED");
        }
        this.processValue(value);
    }

    public Object clone() {
        try {
            Option option = (Option)super.clone();
            option.values = new ArrayList<String>(this.values);
            return option;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        return Objects.equals(this.longOption, other.longOption) && Objects.equals(this.option, other.option);
    }

    public String getArgName() {
        return this.argName;
    }

    public int getArgs() {
        return this.argCount;
    }

    public String getDescription() {
        return this.description;
    }

    String getKey() {
        return this.option == null ? this.longOption : this.option;
    }

    public String getLongOpt() {
        return this.longOption;
    }

    public String getOpt() {
        return this.option;
    }

    public String[] getValues() {
        return this.hasNoValues() ? null : this.values.toArray(Util.EMPTY_STRING_ARRAY);
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public boolean hasArg() {
        return this.argCount > 0 || this.argCount == -2;
    }

    public boolean hasArgs() {
        return this.argCount > 1 || this.argCount == -2;
    }

    public int hashCode() {
        return Objects.hash(this.longOption, this.option);
    }

    public boolean hasLongOpt() {
        return this.longOption != null;
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasValueSeparator() {
        return this.valuesep > '\u0000';
    }

    public boolean isRequired() {
        return this.required;
    }

    private void processValue(String value) {
        if (this.hasValueSeparator()) {
            char sep = this.getValueSeparator();
            int index = value.indexOf(sep);
            while (index != -1 && this.values.size() != this.argCount - 1) {
                this.add(value.substring(0, index));
                value = value.substring(index + 1);
                index = value.indexOf(sep);
            }
        }
        this.add(value);
    }

    boolean requiresArg() {
        if (this.optionalArg) {
            return false;
        }
        if (this.argCount == -2) {
            return this.values.isEmpty();
        }
        return this.acceptsArg();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[ option: ");
        buf.append(this.option);
        if (this.longOption != null) {
            buf.append(" ").append(this.longOption);
        }
        buf.append(" ");
        if (this.hasArgs()) {
            buf.append("[ARG...]");
        } else if (this.hasArg()) {
            buf.append(" [ARG]");
        }
        buf.append(" :: ").append(this.description);
        if (this.type != null) {
            buf.append(" :: ").append(this.type);
        }
        buf.append(" ]");
        return buf.toString();
    }

    public static final class Builder {
        private String option;
        private String description;
        private String longOption;
        private String argName;
        private boolean required;
        private boolean optionalArg;
        private int argCount = -1;
        private Class<?> type = String.class;
        private char valueSeparator;

        private Builder(String option) throws IllegalArgumentException {
            this.option(option);
        }

        public Builder argName(String argName) {
            this.argName = argName;
            return this;
        }

        public Option build() {
            if (this.option == null && this.longOption == null) {
                throw new IllegalArgumentException("Either opt or longOpt must be specified");
            }
            return new Option(this);
        }

        public Builder desc(String description) {
            this.description = description;
            return this;
        }

        public Builder hasArg(boolean hasArg) {
            this.argCount = hasArg ? 1 : -1;
            return this;
        }

        public Builder longOpt(String longOpt) {
            this.longOption = longOpt;
            return this;
        }

        public Builder option(String option) throws IllegalArgumentException {
            this.option = OptionValidator.validate(option);
            return this;
        }
    }
}

