/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import java.util.Objects;

public class Position {
    private static final Position NO_POSITION = new Position(-1, null, null, null, false);
    public final int line;
    public final DexString file;
    public final boolean synthetic;
    public final DexMethod method;
    public final Position callerPosition;

    public Position(int line, DexString file, DexMethod method, Position callerPosition) {
        this(line, file, method, callerPosition, false);
        assert (line >= 0);
    }

    private Position(int line, DexString file, DexMethod method, Position callerPosition, boolean synthetic) {
        this.line = line;
        this.file = file;
        this.synthetic = synthetic;
        this.method = method;
        this.callerPosition = callerPosition;
        assert (callerPosition == null || callerPosition.method != null);
        assert (line == -1 || method != null);
    }

    public static Position synthetic(int line, DexMethod method, Position callerPosition) {
        assert (line >= 0);
        return new Position(line, null, method, callerPosition, true);
    }

    public static Position none() {
        return NO_POSITION;
    }

    public static Position noneWithMethod(DexMethod method, Position callerPosition) {
        assert (method != null);
        return new Position(-1, null, method, callerPosition, false);
    }

    public boolean isNone() {
        return this.line == -1;
    }

    public boolean isSome() {
        return !this.isNone();
    }

    public Position getOutermostCaller() {
        Position lastPosition = this;
        while (lastPosition.callerPosition != null) {
            lastPosition = lastPosition.callerPosition;
        }
        return lastPosition;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Position) {
            Position o = (Position)other;
            return !this.isNone() && this.line == o.line && this.file == o.file && this.method == o.method && Objects.equals(this.callerPosition, o.callerPosition);
        }
        return false;
    }

    public int hashCode() {
        int result = this.line;
        result = 31 * result + Objects.hashCode(this.file);
        result = 31 * result + (this.synthetic ? 1 : 0);
        result = 31 * result + Objects.hashCode(this.method);
        result = 31 * result + Objects.hashCode(this.callerPosition);
        return result;
    }

    private String toString(boolean forceMethod) {
        if (this.isNone()) {
            return "--";
        }
        StringBuilder builder = new StringBuilder();
        if (this.file != null) {
            builder.append(this.file).append(":");
        }
        if (this.method != null && (forceMethod || this.callerPosition != null)) {
            builder.append("[").append(this.method).append("]");
        }
        builder.append("#").append(this.line);
        if (this.callerPosition != null) {
            builder.append(" <- ").append(this.callerPosition.toString(true));
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(false);
    }
}

