/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.code.MoveType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterMove;
import com.android.tools.r8.ir.regalloc.RegisterMoveScheduler;
import com.android.tools.r8.ir.regalloc.SpillMove;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class SpillMoveSet {
    private final Map<Integer, Set<SpillMove>> instructionToInMoves = new HashMap<Integer, Set<SpillMove>>();
    private final Map<Integer, Set<SpillMove>> instructionToOutMoves = new HashMap<Integer, Set<SpillMove>>();
    private final Map<Integer, Set<SpillMove>> instructionToPhiMoves = new HashMap<Integer, Set<SpillMove>>();
    private final IRCode code;
    private final LinearScanRegisterAllocator allocator;
    private final int argumentRegisterLimit;
    private final Map<Integer, BasicBlock> blockStartMap = new HashMap<Integer, BasicBlock>();
    private int usedTempRegisters = 0;

    public SpillMoveSet(LinearScanRegisterAllocator allocator, IRCode code, int argumentRegisterLimit) {
        this.allocator = allocator;
        this.code = code;
        this.argumentRegisterLimit = argumentRegisterLimit;
        for (BasicBlock block : code.blocks) {
            this.blockStartMap.put(block.entry().getNumber(), block);
        }
    }

    public void addSpillOrRestoreMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (i % 2 == 1);
        assert (to.getSplitParent() == from.getSplitParent());
        BasicBlock atEntryToBlock = this.blockStartMap.get(i + 1);
        if (atEntryToBlock == null) {
            this.addInMove(i, to, from);
        }
    }

    public void addInResolutionMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (to.getSplitParent() == from.getSplitParent());
        this.addInMove(i, to, from);
    }

    public void addOutResolutionMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (to.getSplitParent() == from.getSplitParent());
        this.addOutMove(i, to, from);
    }

    public void addPhiMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (i % 2 == 1);
        SpillMove move = new SpillMove(this.moveTypeForIntervals(to, from), to, from);
        move.updateMaxNonSpilled();
        this.instructionToPhiMoves.computeIfAbsent(i, k -> new LinkedHashSet()).add(move);
    }

    private void addInMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (i % 2 == 1);
        this.instructionToInMoves.computeIfAbsent(i, k -> new LinkedHashSet()).add(new SpillMove(this.moveTypeForIntervals(to, from), to, from));
    }

    private void addOutMove(int i, LiveIntervals to, LiveIntervals from) {
        assert (i % 2 == 1);
        this.instructionToOutMoves.computeIfAbsent(i, k -> new LinkedHashSet()).add(new SpillMove(this.moveTypeForIntervals(to, from), to, from));
    }

    public int scheduleAndInsertMoves(int tempRegister) {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                int number = instruction.getNumber();
                if (!this.needsMovesBeforeInstruction(number)) continue;
                it.previous();
                this.scheduleMovesBeforeInstruction(tempRegister, number, it);
                it.next();
            }
        }
        return this.usedTempRegisters;
    }

    private boolean isArgumentRegister(int register) {
        return register < this.argumentRegisterLimit;
    }

    private MoveType moveTypeForIntervals(LiveIntervals to, LiveIntervals from) {
        MoveType toType = to.getMoveType();
        MoveType fromType = from.getMoveType();
        if (toType == MoveType.OBJECT || fromType == MoveType.OBJECT) {
            assert (fromType == MoveType.OBJECT || fromType == MoveType.SINGLE);
            assert (toType == MoveType.OBJECT || toType == MoveType.SINGLE);
            return MoveType.OBJECT;
        }
        assert (toType == fromType);
        return toType;
    }

    private boolean needsMovesBeforeInstruction(int i) {
        return this.instructionToOutMoves.containsKey(i - 1) || this.instructionToInMoves.containsKey(i - 1) || this.instructionToPhiMoves.containsKey(i - 1);
    }

    private SpillMove getMoveWithSource(LiveIntervals src, Collection<SpillMove> moves) {
        for (SpillMove move : moves) {
            if (move.from != src) continue;
            return move;
        }
        return null;
    }

    private SpillMove getMoveWritingSourceRegister(SpillMove inMove, Collection<SpillMove> moves) {
        int srcRegister = inMove.from.getRegister();
        int srcRegisters = inMove.type.requiredRegisters();
        for (SpillMove move : moves) {
            int dstRegister = move.to.getRegister();
            int dstRegisters = move.type.requiredRegisters();
            for (int s = 0; s < srcRegisters; ++s) {
                for (int d = 0; d < dstRegisters; ++d) {
                    if (dstRegister + d != srcRegister + s) continue;
                    return move;
                }
            }
        }
        return null;
    }

    private void pruneParallelMoveSets(Set<SpillMove> inMoves, Set<SpillMove> outMoves, Set<SpillMove> phiMoves) {
        Iterator<SpillMove> it = inMoves.iterator();
        while (it.hasNext()) {
            SpillMove inMove = it.next();
            SpillMove outMove = this.getMoveWithSource(inMove.to, outMoves);
            SpillMove blockingInMove = this.getMoveWritingSourceRegister(inMove, inMoves);
            SpillMove blockingPhiMove = this.getMoveWithSource(inMove.to, phiMoves);
            if (outMove == null || blockingInMove != null || blockingPhiMove != null) continue;
            it.remove();
            outMove.from = inMove.from;
        }
    }

    private void scheduleMovesBeforeInstruction(int tempRegister, int instruction, InstructionListIterator insertAt) {
        Position position;
        if (insertAt.hasPrevious() && insertAt.peekPrevious().isMoveException()) {
            position = insertAt.peekPrevious().getPosition();
        } else {
            Instruction next = insertAt.peekNext();
            assert (next.getNumber() == instruction);
            position = next.getPosition();
            if (position.isNone() && next.isGoto()) {
                position = next.asGoto().getTarget().getPosition();
            }
        }
        Set inMoves = this.instructionToInMoves.computeIfAbsent(instruction - 1, k -> new LinkedHashSet());
        this.removeArgumentRestores(inMoves);
        Set outMoves = this.instructionToOutMoves.computeIfAbsent(instruction - 1, k -> new LinkedHashSet());
        this.removeArgumentRestores(outMoves);
        Set phiMoves = this.instructionToPhiMoves.computeIfAbsent(instruction - 1, k -> new LinkedHashSet());
        this.pruneParallelMoveSets(inMoves, outMoves, phiMoves);
        outMoves.addAll(phiMoves);
        this.scheduleMoves(tempRegister, inMoves, insertAt, position);
        this.scheduleMoves(tempRegister, outMoves, insertAt, position);
    }

    private void removeArgumentRestores(Set<SpillMove> moves) {
        Iterator<SpillMove> moveIterator = moves.iterator();
        while (moveIterator.hasNext()) {
            SpillMove move = moveIterator.next();
            if (!this.isArgumentRegister(move.to.getRegister())) continue;
            moveIterator.remove();
        }
    }

    private void scheduleMoves(int tempRegister, Set<SpillMove> moves, InstructionListIterator insertAt, Position position) {
        RegisterMoveScheduler scheduler = new RegisterMoveScheduler(insertAt, tempRegister, position);
        for (SpillMove move : moves) {
            if (move.to.isSpilledAndRematerializable(this.allocator)) continue;
            if (move.from.isSpilledAndRematerializable(this.allocator)) {
                scheduler.addMove(new RegisterMove(move.to.getRegister(), move.type, move.from.getValue().definition));
                continue;
            }
            if (move.to.getRegister() == move.from.getRegister()) continue;
            if (this.code.options.canHaveBoundsCheckEliminationBug() && move.from.getValue().isConstNumber() && move.type == MoveType.SINGLE && this.allocator.unadjustedRealRegisterFromAllocated(move.to.getRegister()) < 256) {
                scheduler.addMove(new RegisterMove(move.to.getRegister(), move.type, move.from.getValue().definition));
                continue;
            }
            scheduler.addMove(new RegisterMove(move.to.getRegister(), move.from.getRegister(), move.type));
        }
        scheduler.schedule();
        this.usedTempRegisters = Math.max(this.usedTempRegisters, scheduler.getUsedTempRegisters());
    }
}

