/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.position;

import com.android.tools.r8.position.Position;

public class TextPosition
implements Position {
    public static final int UNKNOWN_COLUMN = -1;
    private final long offset;
    private final int line;
    private final int column;

    public TextPosition(long offset, int line, int column) {
        assert (offset >= 0L && line >= 1 && (column >= 1 || column == -1));
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Offset: " + this.offset + ", Line: " + this.line + ", column: " + this.column;
    }

    @Override
    public String getDescription() {
        return "Line: " + this.line + (this.column != -1 ? ", column: " + this.column : "");
    }

    public int hashCode() {
        return Long.hashCode(this.offset) ^ this.line ^ this.column << 16;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass().equals(TextPosition.class)) {
            TextPosition other = (TextPosition)o;
            return this.offset == other.offset && this.line == other.line && this.column == other.column;
        }
        return false;
    }
}

