/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class ExceptionUtils {
    public static final int STATUS_ERROR = 1;

    public static void withConsumeResourceHandler(Reporter reporter, StringConsumer consumer, String data) {
        ExceptionUtils.withConsumeResourceHandler(reporter, handler -> consumer.accept(data, (DiagnosticsHandler)handler));
    }

    public static void withConsumeResourceHandler(Reporter reporter, Consumer<DiagnosticsHandler> consumer) {
        consumer.accept(reporter);
        reporter.failIfPendingErrors();
    }

    public static void withD8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action, Compiler.D8);
    }

    public static void withR8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action, Compiler.R8);
    }

    public static void withCompilationHandler(Reporter reporter, CompileAction action, Compiler compiler) throws CompilationFailedException {
        try {
            try {
                action.run();
            }
            catch (IOException e) {
                throw reporter.fatalError(new IOExceptionDiagnostic(e));
            }
            catch (CompilationException e) {
                throw reporter.fatalError(new StringDiagnostic(compiler == Compiler.D8 ? e.getMessageForD8() : e.getMessageForR8()), e);
            }
            catch (CompilationError e) {
                throw reporter.fatalError(e);
            }
            catch (ResourceException e) {
                throw reporter.fatalError(e.getCause() instanceof IOException ? new IOExceptionDiagnostic((IOException)e.getCause(), e.getOrigin()) : new StringDiagnostic(e.getMessage(), e.getOrigin()));
            }
            reporter.failIfPendingErrors();
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }

    public static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
    }

    public static interface MainAction {
        public void run() throws CompilationFailedException;
    }

    private static enum Compiler {
        D8,
        R8;

    }

    public static interface CompileAction {
        public void run() throws IOException, CompilationException, CompilationError, ResourceException;
    }
}

