/*
 * Decompiled with CFR 0.152.
 */
package androidx.renderscript;

import androidx.renderscript.RSIllegalArgumentException;
import androidx.renderscript.RSInvalidStateException;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.RenderScript;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BaseObj {
    private long mID;
    private boolean mDestroyed;
    RenderScript mRS;

    BaseObj(long id, RenderScript rs) {
        rs.validate();
        this.mRS = rs;
        this.mID = id;
        this.mDestroyed = false;
    }

    void setID(long id) {
        if (this.mID != 0L) {
            throw new RSRuntimeException("Internal Error, reset of object ID.");
        }
        this.mID = id;
    }

    long getID(RenderScript rs) {
        this.mRS.validate();
        if (this.mDestroyed) {
            throw new RSInvalidStateException("using a destroyed object.");
        }
        if (this.mID == 0L) {
            throw new RSRuntimeException("Internal error: Object id 0.");
        }
        if (rs != null && rs != this.mRS) {
            throw new RSInvalidStateException("using object with mismatched context.");
        }
        return this.mID;
    }

    android.renderscript.BaseObj getNObj() {
        return null;
    }

    void checkValid() {
        if (this.mID == 0L && this.getNObj() == null) {
            throw new RSIllegalArgumentException("Invalid object.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpDestroy() {
        boolean shouldDestroy = false;
        BaseObj baseObj = this;
        synchronized (baseObj) {
            if (!this.mDestroyed) {
                shouldDestroy = true;
                this.mDestroyed = true;
            }
        }
        if (shouldDestroy) {
            ReentrantReadWriteLock.ReadLock rlock = this.mRS.mRWLock.readLock();
            rlock.lock();
            if (this.mRS.isAlive()) {
                this.mRS.nObjDestroy(this.mID);
            }
            rlock.unlock();
            this.mRS = null;
            this.mID = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.helpDestroy();
        super.finalize();
    }

    public void destroy() {
        if (this.mDestroyed) {
            throw new RSInvalidStateException("Object already destroyed.");
        }
        this.helpDestroy();
    }

    public int hashCode() {
        return (int)(this.mID & 0xFFFFFFFL ^ this.mID >> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseObj b = (BaseObj)obj;
        return this.mID == b.mID;
    }
}

