/*
 * Decompiled with CFR 0.152.
 */
package android.support.v8.renderscript;

import android.support.v8.renderscript.BaseObj;
import android.support.v8.renderscript.Byte2;
import android.support.v8.renderscript.Byte3;
import android.support.v8.renderscript.Byte4;
import android.support.v8.renderscript.Double2;
import android.support.v8.renderscript.Double3;
import android.support.v8.renderscript.Double4;
import android.support.v8.renderscript.Float2;
import android.support.v8.renderscript.Float3;
import android.support.v8.renderscript.Float4;
import android.support.v8.renderscript.Int2;
import android.support.v8.renderscript.Int3;
import android.support.v8.renderscript.Int4;
import android.support.v8.renderscript.Long2;
import android.support.v8.renderscript.Long3;
import android.support.v8.renderscript.Long4;
import android.support.v8.renderscript.Matrix2f;
import android.support.v8.renderscript.Matrix3f;
import android.support.v8.renderscript.Matrix4f;
import android.support.v8.renderscript.RSIllegalArgumentException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.Short2;
import android.support.v8.renderscript.Short3;
import android.support.v8.renderscript.Short4;
import android.util.Log;
import java.util.BitSet;

public class FieldPacker {
    private byte[] mData;
    private int mPos;
    private int mLen;
    private BitSet mAlignment;

    public FieldPacker(int len) {
        this.mPos = 0;
        this.mLen = len;
        this.mData = new byte[len];
        this.mAlignment = new BitSet();
    }

    public FieldPacker(byte[] data) {
        this.mPos = data.length;
        this.mLen = data.length;
        this.mData = data;
        this.mAlignment = new BitSet();
    }

    static FieldPacker createFromArray(Object[] args) {
        FieldPacker fp = new FieldPacker(RenderScript.sPointerSize * 8);
        for (Object arg : args) {
            fp.addSafely(arg);
        }
        fp.resize(fp.mPos);
        return fp;
    }

    public void align(int v) {
        if (v <= 0 || (v & v - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + v);
        }
        while ((this.mPos & v - 1) != 0) {
            this.mAlignment.flip(this.mPos);
            this.mData[this.mPos++] = 0;
        }
    }

    public void subalign(int v) {
        if ((v & v - 1) != 0) {
            throw new RSIllegalArgumentException("argument must be a non-negative non-zero power of 2: " + v);
        }
        while ((this.mPos & v - 1) != 0) {
            --this.mPos;
        }
        if (this.mPos > 0) {
            while (this.mAlignment.get(this.mPos - 1)) {
                --this.mPos;
                this.mAlignment.flip(this.mPos);
            }
        }
    }

    public void reset() {
        this.mPos = 0;
    }

    public void reset(int i) {
        if (i < 0 || i > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = i;
    }

    public void skip(int i) {
        int res = this.mPos + i;
        if (res < 0 || res > this.mLen) {
            throw new RSIllegalArgumentException("out of range argument: " + i);
        }
        this.mPos = res;
    }

    public void addI8(byte v) {
        this.mData[this.mPos++] = v;
    }

    public byte subI8() {
        this.subalign(1);
        return this.mData[--this.mPos];
    }

    public void addI16(short v) {
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public short subI16() {
        this.subalign(2);
        short v = 0;
        v = (short)((this.mData[--this.mPos] & 0xFF) << 8);
        v = (short)(v | (short)(this.mData[--this.mPos] & 0xFF));
        return v;
    }

    public void addI32(int v) {
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFF);
    }

    public int subI32() {
        this.subalign(4);
        int v = 0;
        v = (this.mData[--this.mPos] & 0xFF) << 24;
        v |= (this.mData[--this.mPos] & 0xFF) << 16;
        v |= (this.mData[--this.mPos] & 0xFF) << 8;
        return v |= this.mData[--this.mPos] & 0xFF;
    }

    public void addI64(long v) {
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public long subI64() {
        this.subalign(8);
        long v = 0L;
        byte x = 0;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 56;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 48;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 40;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 32;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 24;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 16;
        x = this.mData[--this.mPos];
        v |= ((long)x & 0xFFL) << 8;
        x = this.mData[--this.mPos];
        return v |= (long)x & 0xFFL;
    }

    public void addU8(short v) {
        if (v < 0 || v > 255) {
            Log.e((String)"rs", (String)("FieldPacker.addU8( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.mData[this.mPos++] = (byte)v;
    }

    public void addU16(int v) {
        if (v < 0 || v > 65535) {
            Log.e((String)"rs", (String)("FieldPacker.addU16( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        this.mData[this.mPos++] = (byte)(v & 0xFF);
        this.mData[this.mPos++] = (byte)(v >> 8);
    }

    public void addU32(long v) {
        if (v < 0L || v > 0xFFFFFFFFL) {
            Log.e((String)"rs", (String)("FieldPacker.addU32( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
    }

    public void addU64(long v) {
        if (v < 0L) {
            Log.e((String)"rs", (String)("FieldPacker.addU64( " + v + " )"));
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        this.mData[this.mPos++] = (byte)(v & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 8 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 16 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 24 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 32 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 40 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 48 & 0xFFL);
        this.mData[this.mPos++] = (byte)(v >> 56 & 0xFFL);
    }

    public void addF32(float v) {
        this.addI32(Float.floatToRawIntBits(v));
    }

    public float subF32() {
        return Float.intBitsToFloat(this.subI32());
    }

    public void addF64(double v) {
        this.addI64(Double.doubleToRawLongBits(v));
    }

    public double subF64() {
        return Double.longBitsToDouble(this.subI64());
    }

    public void addObj(BaseObj obj) {
        if (obj != null) {
            if (RenderScript.sPointerSize == 8) {
                this.addI64(obj.getID(null));
                this.addI64(0L);
                this.addI64(0L);
                this.addI64(0L);
            } else {
                this.addI32((int)obj.getID(null));
            }
        } else if (RenderScript.sPointerSize == 8) {
            this.addI64(0L);
            this.addI64(0L);
            this.addI64(0L);
            this.addI64(0L);
        } else {
            this.addI32(0);
        }
    }

    public void addF32(Float2 v) {
        this.addF32(v.x);
        this.addF32(v.y);
    }

    public void addF32(Float3 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
    }

    public void addF32(Float4 v) {
        this.addF32(v.x);
        this.addF32(v.y);
        this.addF32(v.z);
        this.addF32(v.w);
    }

    public void addF64(Double2 v) {
        this.addF64(v.x);
        this.addF64(v.y);
    }

    public void addF64(Double3 v) {
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
    }

    public void addF64(Double4 v) {
        this.addF64(v.x);
        this.addF64(v.y);
        this.addF64(v.z);
        this.addF64(v.w);
    }

    public void addI8(Byte2 v) {
        this.addI8(v.x);
        this.addI8(v.y);
    }

    public void addI8(Byte3 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
    }

    public void addI8(Byte4 v) {
        this.addI8(v.x);
        this.addI8(v.y);
        this.addI8(v.z);
        this.addI8(v.w);
    }

    public void addU8(Short2 v) {
        this.addU8(v.x);
        this.addU8(v.y);
    }

    public void addU8(Short3 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
    }

    public void addU8(Short4 v) {
        this.addU8(v.x);
        this.addU8(v.y);
        this.addU8(v.z);
        this.addU8(v.w);
    }

    public void addI16(Short2 v) {
        this.addI16(v.x);
        this.addI16(v.y);
    }

    public void addI16(Short3 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
    }

    public void addI16(Short4 v) {
        this.addI16(v.x);
        this.addI16(v.y);
        this.addI16(v.z);
        this.addI16(v.w);
    }

    public void addU16(Int2 v) {
        this.addU16(v.x);
        this.addU16(v.y);
    }

    public void addU16(Int3 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
    }

    public void addU16(Int4 v) {
        this.addU16(v.x);
        this.addU16(v.y);
        this.addU16(v.z);
        this.addU16(v.w);
    }

    public void addI32(Int2 v) {
        this.addI32(v.x);
        this.addI32(v.y);
    }

    public void addI32(Int3 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
    }

    public void addI32(Int4 v) {
        this.addI32(v.x);
        this.addI32(v.y);
        this.addI32(v.z);
        this.addI32(v.w);
    }

    public void addU32(Long2 v) {
        this.addU32(v.x);
        this.addU32(v.y);
    }

    public void addU32(Long3 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
    }

    public void addU32(Long4 v) {
        this.addU32(v.x);
        this.addU32(v.y);
        this.addU32(v.z);
        this.addU32(v.w);
    }

    public void addI64(Long2 v) {
        this.addI64(v.x);
        this.addI64(v.y);
    }

    public void addI64(Long3 v) {
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
    }

    public void addI64(Long4 v) {
        this.addI64(v.x);
        this.addI64(v.y);
        this.addI64(v.z);
        this.addI64(v.w);
    }

    public void addU64(Long2 v) {
        this.addU64(v.x);
        this.addU64(v.y);
    }

    public void addU64(Long3 v) {
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
    }

    public void addU64(Long4 v) {
        this.addU64(v.x);
        this.addU64(v.y);
        this.addU64(v.z);
        this.addU64(v.w);
    }

    public Float2 subFloat2() {
        Float2 v = new Float2();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Float3 subFloat3() {
        Float3 v = new Float3();
        v.z = this.subF32();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Float4 subFloat4() {
        Float4 v = new Float4();
        v.w = this.subF32();
        v.z = this.subF32();
        v.y = this.subF32();
        v.x = this.subF32();
        return v;
    }

    public Double2 subDouble2() {
        Double2 v = new Double2();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Double3 subDouble3() {
        Double3 v = new Double3();
        v.z = this.subF64();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Double4 subDouble4() {
        Double4 v = new Double4();
        v.w = this.subF64();
        v.z = this.subF64();
        v.y = this.subF64();
        v.x = this.subF64();
        return v;
    }

    public Byte2 subByte2() {
        Byte2 v = new Byte2();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Byte3 subByte3() {
        Byte3 v = new Byte3();
        v.z = this.subI8();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Byte4 subByte4() {
        Byte4 v = new Byte4();
        v.w = this.subI8();
        v.z = this.subI8();
        v.y = this.subI8();
        v.x = this.subI8();
        return v;
    }

    public Short2 subShort2() {
        Short2 v = new Short2();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Short3 subShort3() {
        Short3 v = new Short3();
        v.z = this.subI16();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Short4 subShort4() {
        Short4 v = new Short4();
        v.w = this.subI16();
        v.z = this.subI16();
        v.y = this.subI16();
        v.x = this.subI16();
        return v;
    }

    public Int2 subInt2() {
        Int2 v = new Int2();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Int3 subInt3() {
        Int3 v = new Int3();
        v.z = this.subI32();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Int4 subInt4() {
        Int4 v = new Int4();
        v.w = this.subI32();
        v.z = this.subI32();
        v.y = this.subI32();
        v.x = this.subI32();
        return v;
    }

    public Long2 subLong2() {
        Long2 v = new Long2();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public Long3 subLong3() {
        Long3 v = new Long3();
        v.z = this.subI64();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public Long4 subLong4() {
        Long4 v = new Long4();
        v.w = this.subI64();
        v.z = this.subI64();
        v.y = this.subI64();
        v.x = this.subI64();
        return v;
    }

    public void addMatrix(Matrix4f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix4f subMatrix4f() {
        Matrix4f v = new Matrix4f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addMatrix(Matrix3f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix3f subMatrix3f() {
        Matrix3f v = new Matrix3f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addMatrix(Matrix2f v) {
        for (int i = 0; i < v.mMat.length; ++i) {
            this.addF32(v.mMat[i]);
        }
    }

    public Matrix2f subMatrix2f() {
        Matrix2f v = new Matrix2f();
        for (int i = v.mMat.length - 1; i >= 0; --i) {
            v.mMat[i] = this.subF32();
        }
        return v;
    }

    public void addBoolean(boolean v) {
        this.addI8((byte)(v ? 1 : 0));
    }

    public boolean subBoolean() {
        byte v = this.subI8();
        return v == 1;
    }

    public final byte[] getData() {
        return this.mData;
    }

    public int getPos() {
        return this.mPos;
    }

    private static void addToPack(FieldPacker fp, Object obj) {
        if (obj instanceof Boolean) {
            fp.addBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof Byte) {
            fp.addI8((Byte)obj);
            return;
        }
        if (obj instanceof Short) {
            fp.addI16((Short)obj);
            return;
        }
        if (obj instanceof Integer) {
            fp.addI32((Integer)obj);
            return;
        }
        if (obj instanceof Long) {
            fp.addI64((Long)obj);
            return;
        }
        if (obj instanceof Float) {
            fp.addF32(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            fp.addF64((Double)obj);
            return;
        }
        if (obj instanceof Byte2) {
            fp.addI8((Byte2)obj);
            return;
        }
        if (obj instanceof Byte3) {
            fp.addI8((Byte3)obj);
            return;
        }
        if (obj instanceof Byte4) {
            fp.addI8((Byte4)obj);
            return;
        }
        if (obj instanceof Short2) {
            fp.addI16((Short2)obj);
            return;
        }
        if (obj instanceof Short3) {
            fp.addI16((Short3)obj);
            return;
        }
        if (obj instanceof Short4) {
            fp.addI16((Short4)obj);
            return;
        }
        if (obj instanceof Int2) {
            fp.addI32((Int2)obj);
            return;
        }
        if (obj instanceof Int3) {
            fp.addI32((Int3)obj);
            return;
        }
        if (obj instanceof Int4) {
            fp.addI32((Int4)obj);
            return;
        }
        if (obj instanceof Long2) {
            fp.addI64((Long2)obj);
            return;
        }
        if (obj instanceof Long3) {
            fp.addI64((Long3)obj);
            return;
        }
        if (obj instanceof Long4) {
            fp.addI64((Long4)obj);
            return;
        }
        if (obj instanceof Float2) {
            fp.addF32((Float2)obj);
            return;
        }
        if (obj instanceof Float3) {
            fp.addF32((Float3)obj);
            return;
        }
        if (obj instanceof Float4) {
            fp.addF32((Float4)obj);
            return;
        }
        if (obj instanceof Double2) {
            fp.addF64((Double2)obj);
            return;
        }
        if (obj instanceof Double3) {
            fp.addF64((Double3)obj);
            return;
        }
        if (obj instanceof Double4) {
            fp.addF64((Double4)obj);
            return;
        }
        if (obj instanceof Matrix2f) {
            fp.addMatrix((Matrix2f)obj);
            return;
        }
        if (obj instanceof Matrix3f) {
            fp.addMatrix((Matrix3f)obj);
            return;
        }
        if (obj instanceof Matrix4f) {
            fp.addMatrix((Matrix4f)obj);
            return;
        }
        if (obj instanceof BaseObj) {
            fp.addObj((BaseObj)obj);
            return;
        }
    }

    private static int getPackedSize(Object obj) {
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof Byte) {
            return 1;
        }
        if (obj instanceof Short) {
            return 2;
        }
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof Long) {
            return 8;
        }
        if (obj instanceof Float) {
            return 4;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof Byte2) {
            return 2;
        }
        if (obj instanceof Byte3) {
            return 3;
        }
        if (obj instanceof Byte4) {
            return 4;
        }
        if (obj instanceof Short2) {
            return 4;
        }
        if (obj instanceof Short3) {
            return 6;
        }
        if (obj instanceof Short4) {
            return 8;
        }
        if (obj instanceof Int2) {
            return 8;
        }
        if (obj instanceof Int3) {
            return 12;
        }
        if (obj instanceof Int4) {
            return 16;
        }
        if (obj instanceof Long2) {
            return 16;
        }
        if (obj instanceof Long3) {
            return 24;
        }
        if (obj instanceof Long4) {
            return 32;
        }
        if (obj instanceof Float2) {
            return 8;
        }
        if (obj instanceof Float3) {
            return 12;
        }
        if (obj instanceof Float4) {
            return 16;
        }
        if (obj instanceof Double2) {
            return 16;
        }
        if (obj instanceof Double3) {
            return 24;
        }
        if (obj instanceof Double4) {
            return 32;
        }
        if (obj instanceof Matrix2f) {
            return 16;
        }
        if (obj instanceof Matrix3f) {
            return 36;
        }
        if (obj instanceof Matrix4f) {
            return 64;
        }
        if (obj instanceof BaseObj) {
            if (RenderScript.sPointerSize == 8) {
                return 32;
            }
            return 4;
        }
        return 0;
    }

    static FieldPacker createFieldPack(Object[] args) {
        int len = 0;
        for (Object arg : args) {
            len += FieldPacker.getPackedSize(arg);
        }
        FieldPacker fp = new FieldPacker(len);
        for (Object arg : args) {
            FieldPacker.addToPack(fp, arg);
        }
        return fp;
    }

    private boolean resize(int newSize) {
        if (newSize == this.mLen) {
            return false;
        }
        byte[] newData = new byte[newSize];
        System.arraycopy(this.mData, 0, newData, 0, this.mPos);
        this.mData = newData;
        this.mLen = newSize;
        return true;
    }

    private void addSafely(Object obj) {
        boolean retry;
        int oldPos = this.mPos;
        do {
            retry = false;
            try {
                FieldPacker.addToPack(this, obj);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.mPos = oldPos;
                this.resize(this.mLen * 2);
                retry = true;
            }
        } while (retry);
    }
}

